/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public abstract class BaseLine
extends BaseGraphComponent {
    @Concealed
    protected String m_name;

    @Concealed
    public BaseLine(CommonGraph graph) {
        super(graph);
    }

    @Override
    @Concealed
    public void setXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("value");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("value", new Double(pNode.getValueAsDouble()));
            } else {
                this.setValue(pNode.getValueAsDouble());
            }
        }
    }

    @Override
    @Concealed
    public ObjectNode getXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(this.m_name);
        boolean nodeExists = false;
        Object val = this.m_pfj.getNonZeroBaselineValueObj(this.m_identObj);
        if (val != null) {
            node.addProperty("value", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    public double getValue() {
        if (this.m_pfj.getNonZeroBaseline(this.m_identObj)) {
            return this.m_pfj.getNonZeroBaselineValue(this.m_identObj);
        }
        return 0.0;
    }

    public void setValue(double value) {
        if (value == 0.0) {
            this.m_pfj.setNonZeroBaseline(this.m_identObj, false);
            return;
        }
        this.m_pfj.setNonZeroBaseline(this.m_identObj, true);
        this.m_pfj.setNonZeroBaselineValue(this.m_identObj, value);
    }
}

