/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import oracle.dss.dataView.VerticalAlignment;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.GraphFont;
import oracle.dss.graph.SFX;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class Annotation
extends BaseGraphComponent
implements VerticalAlignment {
    @Concealed
    protected SFX m_sfx;
    @Concealed
    protected GraphFont m_font;
    protected IdentObj m_idBox = null;
    protected int m_series = 0;
    protected int m_group = 0;

    @Concealed
    public Annotation(CommonGraph graph, int series, int group) {
        super(graph);
        SFX sfx;
        Color borderColor;
        Color fillColor;
        this.m_series = series;
        this.m_group = group;
        this.m_identObj = this.m_pfj.createAnnotation(series, group);
        this.m_idBox = this.m_pfj.getAnnotationBox(this.m_identObj);
        boolean isNoXML = this.m_pfj.isNoXMLMode();
        GraphFont annotationDefault = this.m_commonGraph.getAnnotationDefaultFont();
        if (annotationDefault != null) {
            this.m_font = new GraphFont(this.m_commonGraph, this.m_identObj);
            if (annotationDefault.getGraphFontTypeface() != null && !annotationDefault.getGraphFontTypeface().equals(this.m_font.getGraphFontTypeface())) {
                this.m_font.setGraphFontTypeface(annotationDefault.getGraphFontTypeface());
            }
            if (annotationDefault.getGraphFontColor() != null && !annotationDefault.getGraphFontColor().equals(this.m_font.getGraphFontColor())) {
                this.m_font.setGraphFontColor(annotationDefault.getGraphFontColor());
            }
            if (annotationDefault.getGraphFontStyle() != this.m_font.getGraphFontStyle()) {
                this.m_font.setGraphFontStyle(annotationDefault.getGraphFontStyle());
            }
            if (annotationDefault.getGraphFontSize() != this.m_font.getGraphFontSize()) {
                this.m_font.setGraphFontSize(annotationDefault.getGraphFontSize());
            }
        }
        if ((fillColor = this.m_pfj.getFillColor(this.m_pfj.getAnnotationBoxDefault(), false)) != null && !fillColor.equals(this.getFillColor())) {
            this.setFillColor(fillColor);
        }
        if ((borderColor = this.m_pfj.getBorderColor(this.m_pfj.getAnnotationBoxDefault(), false)) != null && !borderColor.equals(this.getBorderColor())) {
            this.setBorderColor(borderColor);
        }
        if ((sfx = this.m_commonGraph.getAnnotationDefaultSFX()) != null) {
            if (sfx.getFillType() != this.getSFX().getFillType()) {
                this.getSFX().setFillType(sfx.getFillType());
            }
            if (sfx.getGradientDirection() != this.getSFX().getGradientDirection()) {
                this.getSFX().setGradientDirection(sfx.getGradientDirection());
            }
            if (sfx.getGradientNumStops() != this.getSFX().getGradientNumStops()) {
                this.getSFX().setGradientNumStops(sfx.getGradientNumStops());
            }
            if (sfx.getTextureDisplayMode() != this.getSFX().getTextureDisplayMode()) {
                this.getSFX().setTextureDisplayMode(sfx.getTextureDisplayMode());
            }
            if (sfx.getTextureURL() != this.getSFX().getTextureURL()) {
                this.getSFX().setTextureURL(sfx.getTextureURL());
            }
            if (sfx.isGradientReversed() != this.getSFX().isGradientReversed()) {
                this.getSFX().setGradientReversed(sfx.isGradientReversed());
            }
            for (int i = 0; i < sfx.getGradientNumStops(); ++i) {
                if (sfx.getGradientStopColor(i) != this.getSFX().getGradientStopColor(i)) {
                    this.getSFX().setGradientStopColor(sfx.getGradientStopColor(i), i);
                }
                if (sfx.getGradientStopPosition(i) == this.getSFX().getGradientStopPosition(i)) continue;
                this.getSFX().setGradientStopPosition(sfx.getGradientStopPosition(i), i);
            }
        }
        this.m_pfj.setNoXMLMode(isNoXML);
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public void setPosition(GraphConstants.AnnotationPosition pos) {
        this.m_pfj.setAnnotationPosition(this.m_identObj, pos);
    }

    public GraphConstants.AnnotationPosition getPosition() {
        return this.m_pfj.getAnnotationPosition(this.m_identObj);
    }

    public GraphConstants.AnnotationLocation getLocation() {
        return this.m_pfj.getAnnotationLocation(this.m_identObj);
    }

    public void setLocation(GraphConstants.AnnotationLocation location) {
        this.m_pfj.setAnnotationLocation(this.m_identObj, location);
    }

    public void setXValue(double value) {
        this.m_pfj.setAnnotationXValue(this.m_identObj, value);
    }

    public double getXValue() {
        return this.m_pfj.getAnnotationXValue(this.m_identObj);
    }

    public void setYValue(double value) {
        this.m_pfj.setAnnotationYValue(this.m_identObj, value);
    }

    public double getYValue() {
        return this.m_pfj.getAnnotationYValue(this.m_identObj);
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_idBox);
    }

    public void setBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_idBox, newColor);
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_idBox);
    }

    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBackground( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_idBox, newColor);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
        this.m_pfj.setDisplay(this.m_idBox, yesNo);
    }

    public GraphFont getGraphFont() {
        if (this.m_font == null) {
            this.m_font = new GraphFont(this.m_commonGraph, this.m_identObj);
        } else {
            this.m_font.setObjectId(this.m_identObj);
        }
        return this.m_font;
    }

    public void setFont(Font f) {
        this.getGraphFont();
        this.m_font.setFont(f);
    }

    public Font getFont() {
        this.getGraphFont();
        return this.m_font.getFont();
    }

    public String getText() {
        return this.m_pfj.getTextString(this.m_identObj);
    }

    public void setText(String str) {
        this.m_pfj.setTextString(this.m_identObj, str);
    }

    public int getHorizontalAlignment() {
        return this.m_pfj.getTextJustHoriz(this.m_identObj);
    }

    public void setHorizontalAlignment(int a) {
        if (a == 2 || a == 0 || a == 4 || a == 10) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        }
    }

    @Override
    public int getVerticalAlignment() {
        return this.m_pfj.getTextJustVert(this.m_identObj);
    }

    @Override
    public void setVerticalAlignment(int a) {
        if (a == 1 || a == 0 || a == 3) {
            this.m_pfj.setTextJustVert(this.m_identObj, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid vertical aligment", this.getClass().toString(), "setVerticalAlignment(alignment)");
        }
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    public int getID() {
        return this.m_identObj.getMiscID();
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "Annotation";
    }

    @Concealed
    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ObjectNode graphFont;
        ContainerNode sfxNode;
        ObjectNode node = new ObjectNode(this.getComponentName());
        boolean nodeExists = false;
        Object val = this.m_pfj.getTextString(this.m_identObj);
        if (val != null || allProperties) {
            node.addProperty("series", this.m_series);
            node.addProperty("group", this.m_group);
            node.addProperty("text", (String)val);
            nodeExists = true;
        }
        if ((val = this.m_pfj.getAnnotationXValue(this.m_identObj)) != null || allProperties) {
            node.addProperty("xValue", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getAnnotationYValue(this.m_identObj)) != null || allProperties) {
            node.addProperty("yValue", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj)) != null || allProperties) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getAnnotationPosition(this.m_identObj)) != null) {
            node.addProperty("position", ((GraphConstants.AnnotationPosition)((Object)val)).toString());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getAnnotationLocation(this.m_identObj)) != null) {
            node.addProperty("location", ((GraphConstants.AnnotationLocation)((Object)val)).toString());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextJustHorizObj(this.m_identObj)) != null) {
            node.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextJustVertObj(this.m_identObj)) != null) {
            int tmp = (Integer)val;
            String alignment = Annotation.convertVerticalAlignmentToString(tmp);
            node.addProperty("verticalAlignment", alignment);
            nodeExists = true;
        }
        if ((val = this.m_pfj.getBorderColor(this.m_idBox)) != null) {
            node.addProperty("borderColor", Annotation.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getFillColor(this.m_idBox)) != null) {
            node.addProperty("fillColor", Annotation.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties)) != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        if ((graphFont = this.getGraphFont().getXML(allProperties)) != null) {
            node.addProperty(graphFont);
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    @Override
    @Concealed
    public void setXML(ObjectNode node, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    @Override
    @Concealed
    public void setXML(ObjectNode node) {
        ObjectNode graphFont;
        ContainerNode sfx;
        PropertyNode pNode;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.m_jsfHashMap != null) {
            this.m_jsfHashMap.put(new Integer(this.getID()), map);
        }
        if ((pNode = node.getProperty("series")) != null && this.m_jsfHashMap != null) {
            map.put("series", new Integer(pNode.getValueAsInteger()));
        }
        if ((pNode = node.getProperty("group")) != null && this.m_jsfHashMap != null) {
            map.put("group", new Integer(pNode.getValueAsInteger()));
        }
        if ((pNode = node.getProperty("text")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("text", pNode.getValueAsString());
            } else {
                this.setText(pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty("xValue")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("xValue", new Double(pNode.getValueAsDouble()));
            } else {
                this.setXValue(pNode.getValueAsDouble());
            }
        }
        if ((pNode = node.getProperty("yValue")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("yValue", new Double(pNode.getValueAsDouble()));
            } else {
                this.setYValue(pNode.getValueAsDouble());
            }
        }
        if ((pNode = node.getProperty("visible")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("position")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("position", (Object)GraphConstants.AnnotationPosition.convertStringToEnum(pNode.getValueAsString()));
            } else {
                this.setPosition(GraphConstants.AnnotationPosition.convertStringToEnum(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("location")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("location", (Object)GraphConstants.AnnotationLocation.convertStringToEnum(pNode.getValueAsString()));
            } else {
                this.setLocation(GraphConstants.AnnotationLocation.convertStringToEnum(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("horizontalAlignment")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("horizontalAlignment", new Integer(Annotation.convertHorizontalAlignmentToInt(pNode.getValueAsString())));
            } else {
                this.setHorizontalAlignment(Annotation.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("verticalAlignment")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("verticalAlignment", new Integer(Annotation.convertVerticalAlignmentToInt(pNode.getValueAsString())));
            } else {
                this.setVerticalAlignment(Annotation.convertVerticalAlignmentToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("borderColor")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("borderColor", new Color(Annotation.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setBorderColor(new Color(Annotation.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((pNode = node.getProperty("fillColor")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("fillColor", new Color(Annotation.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setFillColor(new Color(Annotation.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((sfx = node.getContainer("SFX")) != null) {
            this.getSFX().setXML(sfx, false);
        }
        if ((graphFont = node.getPropertyValueAsObjectNode("GraphFont", true)) != null) {
            if (this.m_jsfHashMap != null) {
                HashMap graphFontMap = new HashMap();
                map.put("GraphFont", graphFontMap);
                this.getGraphFont().setXML(graphFont, graphFontMap);
            } else {
                this.getGraphFont().setXML(graphFont);
            }
        }
    }
}

