/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.javatools.annotations.Concealed;

public class TokenSubstitutionAdapter
implements TokenSubstitution {
    private ResourceBundle rBundle = null;
    protected Variable[] m_variable;
    protected DataviewCommon m_dataview = null;
    protected Locale m_locale = null;
    protected int m_item;
    protected final String DIMENSION_KEY = "__DIM__";
    protected final String MEMBER_KEY = "__MEM__";
    protected final String DIM_MEM_KEY = "__D&M__";
    protected final String DATE_KEY = "__DATE__";
    protected final String TIME_KEY = "__TIME__";
    protected final String PAGE_KEY = "__PAGE__";
    protected Variable dimension;
    protected Variable member;
    protected Variable dim_mem;
    protected Variable date;
    protected Variable time;
    protected Variable page;
    public static final int DIMENSION = 1;
    public static final int MEMBER = 2;
    public static final int DIMENSION_MEMBER = 4;
    public static final int DATE = 8;
    public static final int TIME = 16;
    public static final int PAGE = 32;
    public static final int ALL = 63;

    public TokenSubstitutionAdapter() {
    }

    @Concealed
    public TokenSubstitutionAdapter(ViewPrinter printer, int item) {
    }

    public TokenSubstitutionAdapter(DataviewCommon view) {
        this.m_dataview = view;
        this.m_item = 7;
        this._init();
    }

    public String[] getListItems() {
        String[] str = new String[this.m_variable.length];
        for (int i = 0; i < this.m_variable.length; ++i) {
            str[i] = this.m_variable[i].listItem;
        }
        return str;
    }

    public String getToken(String listItem) {
        for (int i = 0; i < this.m_variable.length; ++i) {
            if (!this.m_variable[i].listItem.equals(listItem)) continue;
            return this.m_variable[i].token;
        }
        return null;
    }

    public String getKeyString(String tokenString) {
        String token = "";
        int startAt = 0;
        int foundAt = 0;
        String parsedStr = "";
        String finalStr = tokenString;
        String subStr = "";
        String str = tokenString;
        boolean found = false;
        for (int i = 0; i < this.m_variable.length; ++i) {
            token = this.m_variable[i].token;
            parsedStr = "";
            while ((foundAt = str.indexOf(token, 0)) != -1) {
                if (foundAt != startAt) {
                    parsedStr = parsedStr + str.substring(0, foundAt);
                }
                parsedStr = (subStr = str.substring(foundAt, foundAt + token.length())).equals(token) ? parsedStr + this.m_variable[i].key : parsedStr + subStr;
                str = str.substring(foundAt + token.length());
                found = true;
            }
            if (!found) continue;
            finalStr = str = (parsedStr = parsedStr + str);
            found = false;
        }
        return finalStr;
    }

    public String getTokenString(String keyString) {
        String key = "";
        int startAt = 0;
        int foundAt = 0;
        String parsedStr = "";
        String finalStr = keyString;
        String subStr = "";
        String str = keyString;
        boolean found = false;
        for (int i = 0; i < this.m_variable.length; ++i) {
            key = this.m_variable[i].key;
            parsedStr = "";
            while ((foundAt = str.indexOf(key, 0)) != -1) {
                if (foundAt != startAt) {
                    parsedStr = parsedStr + str.substring(0, foundAt);
                }
                parsedStr = (subStr = str.substring(foundAt, foundAt + key.length())).equals(key) ? parsedStr + this.m_variable[i].token : parsedStr + subStr;
                str = str.substring(foundAt + key.length());
                found = true;
            }
            if (!found) continue;
            finalStr = str = (parsedStr = parsedStr + str);
            found = false;
        }
        return finalStr;
    }

    public String getParsedString(String keyString) {
        String token = "";
        int startAt = 0;
        int foundAt = 0;
        String parsedStr = "";
        String finalStr = keyString;
        String subStr = "";
        String str = keyString;
        boolean found = false;
        for (int i = 0; i < this.m_variable.length; ++i) {
            token = this.m_variable[i].key;
            parsedStr = "";
            while ((foundAt = str.indexOf(token, 0)) != -1) {
                if (foundAt != startAt) {
                    parsedStr = parsedStr + str.substring(0, foundAt);
                }
                parsedStr = (subStr = str.substring(foundAt, foundAt + token.length())).equals(token) ? parsedStr + this.getParsedKey(subStr) : parsedStr + subStr;
                str = str.substring(foundAt + token.length());
                found = true;
            }
            if (!found) continue;
            finalStr = str = (parsedStr = parsedStr + str);
            found = false;
        }
        return finalStr;
    }

    public String getKey(String listItem) {
        return "";
    }

    protected String getParsedKey(String subStr) {
        String parsedStr = "";
        int dimCnt = 0;
        String dimMemSeparator = ":";
        String dimSeparator = ", ";
        String memSeparator = ", ";
        String dimMemPairSeparator = ", ";
        Object obj = null;
        if (subStr.equals("__DATE__") || subStr.equals("__TIME__")) {
            Locale loc = null;
            if (this.m_dataview != null) {
                loc = this.m_dataview.getLocale();
            }
            if (loc == null) {
                loc = Locale.getDefault();
            }
            Calendar cal = null;
            boolean bForceGregCal = loc.getLanguage().compareTo("th") == 0 && loc.getCountry().compareTo("TH") == 0;
            cal = bForceGregCal ? new GregorianCalendar(loc) : Calendar.getInstance(loc);
            DateFormat formatter = subStr.equals("__DATE__") ? (DateFormat)DateFormat.getDateInstance(3, loc).clone() : (DateFormat)DateFormat.getTimeInstance(3, loc).clone();
            if (bForceGregCal) {
                formatter.setCalendar(cal);
            }
            formatter.setTimeZone(TimeZone.getDefault());
            return formatter.format(cal.getTime());
        }
        if (subStr.equals("__D&M__")) {
            DataAccess dataAccess;
            Model model = this.m_dataview.getModel();
            if (model != null) {
                dataAccess = model.getDataAccess();
            } else if (this.m_dataview instanceof CommonDataview) {
                dataAccess = ((CommonDataview)this.m_dataview).getDataAccess();
            } else {
                return null;
            }
            if (dataAccess == null) {
                return null;
            }
            String layerLabelType = this.m_dataview.getLayerMetadataLabelType(2);
            String memberLabelType = this.m_dataview.getMemberMetadataLabelType(2);
            boolean bLayerTypeSupported = this.m_dataview.isLayerMetadataLabelTypeSupported(layerLabelType);
            boolean bMemberTypeSupported = this.m_dataview.isMemberMetadataLabelTypeSupported(memberLabelType);
            if (bLayerTypeSupported || bMemberTypeSupported) {
                try {
                    dimCnt = dataAccess.getLayerCount(2);
                    int[] context = dataAccess.getEdgeCurrentHPos(2);
                    for (int dim = 0; dim < dimCnt; ++dim) {
                        String dimStr = "";
                        if (bLayerTypeSupported) {
                            obj = dataAccess.getLayerMetadata(2, dim, layerLabelType);
                        }
                        if (obj != null) {
                            dimStr = obj.toString();
                        }
                        String memStr = "";
                        if (bMemberTypeSupported && context != null) {
                            obj = dataAccess.getMemberMetadata(2, context, dim, context[dim], memberLabelType);
                            if (obj != null) {
                                memStr = obj.toString();
                            }
                            memStr = dimMemSeparator + memStr;
                        }
                        parsedStr = parsedStr + dimStr + memStr;
                        if (dim + 1 >= dimCnt) continue;
                        parsedStr = parsedStr + dimMemPairSeparator;
                    }
                }
                catch (EdgeOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (SliceOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (LayerOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
            }
        } else {
            String layerLabelType = this.m_dataview.getLayerMetadataLabelType(2);
            boolean bLayerTypeSupported = this.m_dataview.isLayerMetadataLabelTypeSupported(layerLabelType);
            if (subStr.equals("__DIM__") && bLayerTypeSupported) {
                DataAccess dataAccess;
                Model model = this.m_dataview.getModel();
                if (model != null) {
                    dataAccess = model.getDataAccess();
                } else if (this.m_dataview instanceof CommonDataview) {
                    dataAccess = ((CommonDataview)this.m_dataview).getDataAccess();
                } else {
                    return null;
                }
                if (dataAccess == null) {
                    return null;
                }
                try {
                    dimCnt = dataAccess.getLayerCount(2);
                    for (int dim = 0; dim < dimCnt; ++dim) {
                        String dimStr = null;
                        obj = dataAccess.getLayerMetadata(2, dim, layerLabelType);
                        if (obj != null) {
                            dimStr = obj.toString();
                        }
                        parsedStr = parsedStr + dimStr;
                        if (dim + 1 >= dimCnt) continue;
                        parsedStr = parsedStr + dimSeparator;
                    }
                }
                catch (EdgeOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (LayerOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
            }
            String memberLabelType = this.m_dataview.getMemberMetadataLabelType(2);
            boolean bMemberTypeSupported = this.m_dataview.isMemberMetadataLabelTypeSupported(memberLabelType);
            if (subStr.equals("__MEM__") && bMemberTypeSupported) {
                DataAccess dataAccess;
                Model model = this.m_dataview.getModel();
                if (model != null) {
                    dataAccess = model.getDataAccess();
                } else if (this.m_dataview instanceof CommonDataview) {
                    dataAccess = ((CommonDataview)this.m_dataview).getDataAccess();
                } else {
                    return null;
                }
                if (dataAccess == null) {
                    return null;
                }
                try {
                    dimCnt = dataAccess.getLayerCount(2);
                    int[] context = dataAccess.getEdgeCurrentHPos(2);
                    if (context != null) {
                        for (int dim = 0; dim < dimCnt; ++dim) {
                            String memStr = null;
                            obj = dataAccess.getMemberMetadata(2, context, dim, context[dim], memberLabelType);
                            if (obj != null) {
                                memStr = obj.toString();
                            }
                            parsedStr = parsedStr + memStr;
                            if (dim + 1 >= dimCnt) continue;
                            parsedStr = parsedStr + memSeparator;
                        }
                    }
                }
                catch (EdgeOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (SliceOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (LayerOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
            }
        }
        return parsedStr;
    }

    protected void _init() {
        this.dimension = new Variable();
        this.member = new Variable();
        this.dim_mem = new Variable();
        this.date = new Variable();
        this.time = new Variable();
        this.page = new Variable();
        this.dimension.key = "__DIM__";
        this.member.key = "__MEM__";
        this.dim_mem.key = "__D&M__";
        this.date.key = "__DATE__";
        this.time.key = "__TIME__";
        this.page.key = "__PAGE__";
        this.setLocale(this.m_dataview.getLocale());
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        this.updateResourceBundle();
        this.localizeVariablesArray();
    }

    public void updateResourceBundle() {
        this.rBundle = CommonDataview.getDataviewResourceBundle(this.m_locale);
    }

    protected void localizeVariablesArray() {
        this.dimension.token = this.m_dataview.getIntlString("&Dimension", this.rBundle);
        this.member.token = this.m_dataview.getIntlString("&Member", this.rBundle);
        this.dim_mem.token = this.m_dataview.getIntlString("&DimMem", this.rBundle);
        this.date.token = this.m_dataview.getIntlString("&Date", this.rBundle);
        this.time.token = this.m_dataview.getIntlString("&Time", this.rBundle);
        this.page.token = this.m_dataview.getIntlString("&Page", this.rBundle);
        this.dimension.listItem = this.m_dataview.getIntlString("Dimension", this.rBundle);
        this.member.listItem = this.m_dataview.getIntlString("Member", this.rBundle);
        this.dim_mem.listItem = this.m_dataview.getIntlString("DimensionMember", this.rBundle);
        this.date.listItem = this.m_dataview.getIntlString("Date", this.rBundle);
        this.time.listItem = this.m_dataview.getIntlString("Time", this.rBundle);
        this.page.listItem = this.m_dataview.getIntlString("Page", this.rBundle);
        Vector<Variable> v = new Vector<Variable>();
        if ((this.m_item & 1) == 1) {
            v.addElement(this.dimension);
        }
        if ((this.m_item & 2) == 2) {
            v.addElement(this.member);
        }
        if ((this.m_item & 4) == 4) {
            v.addElement(this.dim_mem);
        }
        if ((this.m_item & 8) == 8) {
            v.addElement(this.date);
        }
        if ((this.m_item & 0x10) == 16) {
            v.addElement(this.time);
        }
        if ((this.m_item & 0x20) == 32) {
            v.addElement(this.page);
        }
        this.m_variable = new Variable[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            this.m_variable[i] = (Variable)v.elementAt(i);
        }
    }

    class Variable {
        public String listItem;
        public String token;
        public String key;

        Variable() {
        }
    }
}

