/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import javax.swing.event.EventListenerList;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class LocalXMLDataSource
extends DataAccessAdapter
implements CubeDataDirector,
CubeDataAccess,
RelationalDataDirector,
RelationalDataAccess,
DataSource {
    protected EventListenerList m_listenerList = new EventListenerList();
    protected DataMap m_dataMap = null;
    protected MetadataMap m_metadataMap = null;
    protected int m_columnCount = 0;
    protected int m_rowCount = 0;
    protected int m_pageCount = 0;
    protected Object[] m_columnLabels = null;
    protected Object[] m_rowLabels = null;
    protected Object[][] m_data = null;

    public LocalXMLDataSource(Object[] columnLabels, Object[] rowLabels, Object[][] data) {
        if (columnLabels != null) {
            this.m_columnCount = columnLabels.length;
            this.m_columnLabels = columnLabels;
        }
        if (rowLabels != null) {
            this.m_rowCount = rowLabels.length;
            this.m_rowLabels = rowLabels;
        }
        if (data != null) {
            this.m_data = data;
        }
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    public void addDataDirectorListener(DataDirectorListener l) {
        if (l != null) {
            this.m_listenerList.add(DataDirectorListener.class, l);
            this.fireDataAvailableEvent(new DataAvailableEvent((Object)this, (DataAccess)this));
        }
    }

    public void removeDataDirectorListener(DataDirectorListener l) {
        if (l != null) {
            this.m_listenerList.remove(DataDirectorListener.class, l);
        }
    }

    public DataDirector createDataDirector() {
        return this;
    }

    public DataAccess getDataAccess() throws DataDirectorException {
        return this;
    }

    public DataMap getDataMap() {
        if (this.m_dataMap == null) {
            this.m_dataMap = new DataMap(new String[]{"dataValue"});
        }
        return this.m_dataMap;
    }

    public int getEdgeCount() {
        return 3;
    }

    public int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        switch (edge) {
            case 0: {
                return this.m_columnCount;
            }
            case 1: {
                return this.m_rowCount;
            }
            case 2: {
                return this.m_pageCount;
            }
        }
        return 0;
    }

    public int getLayerCount(int edge) throws EdgeOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        switch (edge) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public Object getLayerMetadata(int edge, int layer, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (type.equals("layerName")) {
            if (edge == 0) {
                return "ColumnEdgeLayer";
            }
            if (edge == 1) {
                return "RowEdgeLayer";
            }
        }
        return super.getLayerMetadata(edge, layer, type);
    }

    public int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge == 0 || edge == 1) {
            return 1;
        }
        return super.getMemberDepth(edge, layer, slice);
    }

    public int getMemberExtent(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (layer < 0 || layer >= this.getLayerCount(edge)) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount(edge) - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        switch (edge) {
            case 0: 
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public Object getMemberMetadata(int edge, int layer, int slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (layer < 0 || layer >= this.getLayerCount(edge)) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount(edge) - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        if (!(type.equals("shortName") || type.equals("mediumName") || type.equals("label") || type.equals("value") || type.equals("dataValue"))) {
            return null;
        }
        switch (edge) {
            case 0: {
                return this.m_columnLabels[slice];
            }
            case 1: {
                return this.m_rowLabels[slice];
            }
        }
        return null;
    }

    public int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (layer < 0 || layer >= this.getLayerCount(edge)) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount(edge) - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        switch (edge) {
            case 0: {
                return slice;
            }
            case 1: {
                return slice;
            }
        }
        return 0;
    }

    public MetadataMap getMetadataMap(int edge, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (this.m_metadataMap == null) {
            this.m_metadataMap = new MetadataMap(new String[]{"shortName", "mediumName", "label"});
        }
        return this.m_metadataMap;
    }

    public Object getSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        if (!(type.equals("shortName") || type.equals("mediumName") || type.equals("label") || type.equals("value"))) {
            return null;
        }
        switch (edge) {
            case 0: {
                return this.m_columnLabels[slice];
            }
            case 1: {
                return this.m_rowLabels[slice];
            }
        }
        return null;
    }

    public int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount() - 1);
        }
        if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
        }
        switch (edge) {
            case 0: 
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public Object getValue(int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            if (row < 0 || row >= this.getEdgeExtent(1)) {
                throw new RowOutOfRangeException((long)row, (long)(this.getEdgeExtent(1) - 1));
            }
            if (col < 0 || col >= this.getEdgeExtent(0)) {
                throw new ColumnOutOfRangeException((long)col, (long)(this.getEdgeExtent(0) - 1));
            }
        }
        catch (EdgeOutOfRangeException e) {
            return null;
        }
        if (!type.equals("dataValue")) {
            return null;
        }
        if (this.m_data == null || this.m_data[col] == null) {
            return null;
        }
        return this.m_data[col][row];
    }

    public QDR getValueQDR(int row, int column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        try {
            if (row < 0 || row >= this.getEdgeExtent(1)) {
                throw new RowOutOfRangeException((long)row, (long)(this.getEdgeExtent(1) - 1));
            }
            if (column < 0 || column >= this.getEdgeExtent(0)) {
                throw new ColumnOutOfRangeException((long)column, (long)(this.getEdgeExtent(0) - 1));
            }
            Object rowDim = this.getLayerMetadata(1, 0, "layerName");
            Object colDim = this.getLayerMetadata(0, 0, "layerName");
            Object rowLabel = this.getMemberMetadata(1, 0, row, "value");
            Object colLabel = this.getMemberMetadata(0, 0, column, "value");
            if (rowDim != null && rowLabel != null && colDim != null && colLabel != null) {
                QDR qdr = new QDR();
                qdr.addDimMemberPair(rowDim.toString(), rowLabel.toString());
                qdr.addDimMemberPair(colDim.toString(), colLabel.toString());
                return qdr;
            }
        }
        catch (EdgeOutOfRangeException e) {
            return super.getValueQDR(row, column, flags);
        }
        catch (LayerOutOfRangeException e) {
            return super.getValueQDR(row, column, flags);
        }
        catch (SliceOutOfRangeException e) {
            return super.getValueQDR(row, column, flags);
        }
        return super.getValueQDR(row, column, flags);
    }

    public QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            if (slice < 0 || slice >= this.getEdgeExtent(edge)) {
                throw new SliceOutOfRangeException(slice, this.getEdgeExtent(edge) - 1);
            }
            boolean pairAdded = false;
            QDR qdr = new QDR();
            for (int i = 0; i < this.getLayerCount(edge); ++i) {
                Object dim = this.getLayerMetadata(edge, i, "layerName");
                Object member = this.getMemberMetadata(edge, i, slice, "value");
                if (dim == null || member == null) continue;
                qdr.addDimMemberPair(dim.toString(), member.toString());
                pairAdded = true;
            }
            if (pairAdded) {
                return qdr;
            }
        }
        catch (EdgeOutOfRangeException e) {
            return super.getSliceQDR(edge, slice, flags);
        }
        catch (LayerOutOfRangeException e) {
            return super.getSliceQDR(edge, slice, flags);
        }
        return super.getSliceQDR(edge, slice, flags);
    }

    public QDR getMemberQDR(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getSliceQDR(edge, slice, flags);
    }

    protected void fireDataAvailableEvent(DataAvailableEvent e) {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataDirectorListener.class) continue;
            ((DataDirectorListener)listeners[i + 1]).viewDataAvailable(e);
        }
    }

    public DataMap getSupportedDataMap() {
        String[] supported = new String[]{"dataValue"};
        return new DataMap(supported);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] supported = new String[]{"label", "mediumName", "shortName", "date", "value", "viewStyle"};
        return new MetadataMap(supported);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] supported = new String[]{"layerLabel", "dimMediumName", "dimShortName"};
        return new LayerMetadataMap(supported);
    }
}

