/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.item.ComponentItem;
import oracle.bali.jle.tool.InlineEditHandler;
import oracle.bali.jle.tool.InlineEditTool;
import oracle.bali.share.collection.StringKey;

public abstract class JFCTextEditHandler
extends InlineEditHandler {
    public static final Object EDIT_FONT_KEY = new StringKey("EDIT_FONT_KEY");
    public static final Object EDIT_BORDER_PAINTER_KEY = new StringKey("EDIT_BORDER_PAINTER_KEY");
    public static final Object EDIT_BG_COLOR_KEY = new StringKey("EDIT_BG_COLOR_KEY");
    public static final Object EDIT_FG_COLOR_KEY = new StringKey("EDIT_FG_COLOR_KEY");
    private ComponentItem _editItem = null;
    private JTextComponent _field = null;
    private String _originalValue = null;
    private LayoutItem _editing;
    private InlineEditTool _tool;
    private Font _dFont;
    private Border _dBorder;
    private Color _dBGC;
    private Color _dTC;
    private static Border _sDefaultBorder;

    protected JFCTextEditHandler() {
    }

    @Override
    public Object startEdit(InlineEditTool tool, LayoutItem item) {
        String startVal = null;
        try {
            startVal = (String)JFCTextEditHandler.getEditData(item);
        }
        catch (ClassCastException e) {
            startVal = "";
        }
        this.getEditComponent().setText(startVal);
        this._originalValue = startVal;
        this._editing = item;
        this._tool = tool;
        this._initializeTextField(item);
        return startVal;
    }

    @Override
    public Object commitEdit(InlineEditTool tool, LayoutItem item) {
        String currVal = this._field.getText();
        Object commit = JFCTextEditHandler.setEditData(item, currVal);
        if (commit == PropertyManager.REJECTED_VALUE) {
            commit = this._originalValue;
            JFCTextEditHandler.setEditData(item, commit);
        }
        this._editing = null;
        this._tool = null;
        return currVal;
    }

    @Override
    public Object cancelEdit(InlineEditTool tool, LayoutItem item) {
        JFCTextEditHandler.setEditData(item, this._originalValue);
        this._editing = null;
        this._tool = null;
        return this._originalValue;
    }

    @Override
    public LayoutItem getEditControlItem() {
        return this._getEditItem();
    }

    public JTextComponent getEditComponent() {
        if (this._field == null) {
            this._field = this.createComponent();
            this._field.setBorder(this._getDefaultBorder());
            this._field.setOpaque(false);
            this._saveDefaults();
        }
        return this._field;
    }

    protected abstract JTextComponent createComponent();

    protected InlineEditTool getTool() {
        return this._tool;
    }

    protected LayoutItem getEditedItem() {
        return this._editing;
    }

    public static void setItemEditBorder(LayoutItem item, Border border) {
        if (item == null) {
            return;
        }
        item.putProperty(EDIT_BORDER_PAINTER_KEY, border);
    }

    public static void setItemEditFont(LayoutItem item, Font font) {
        if (item == null) {
            return;
        }
        item.putProperty(EDIT_FONT_KEY, font);
    }

    public static void setItemEditBackground(LayoutItem item, Color bg) {
        if (item == null) {
            return;
        }
        item.putProperty(EDIT_BG_COLOR_KEY, bg);
    }

    public static void setItemEditForeground(LayoutItem item, Color fg) {
        if (item == null) {
            return;
        }
        item.putProperty(EDIT_FG_COLOR_KEY, fg);
    }

    public static Border getItemEditBorder(LayoutItem item) {
        if (item == null) {
            return null;
        }
        Object found = item.getProperty(EDIT_BORDER_PAINTER_KEY);
        if (found == PropertyManager.NOT_FOUND_OBJECT) {
            found = null;
        }
        return (Border)found;
    }

    public static Font getItemEditFont(LayoutItem item) {
        if (item == null) {
            return null;
        }
        Object found = item.getProperty(EDIT_FONT_KEY);
        if (found == PropertyManager.NOT_FOUND_OBJECT) {
            found = null;
        }
        return (Font)found;
    }

    public static Color getItemEditBackground(LayoutItem item) {
        if (item == null) {
            return null;
        }
        Object found = item.getProperty(EDIT_BG_COLOR_KEY);
        if (found == PropertyManager.NOT_FOUND_OBJECT) {
            found = null;
        }
        return (Color)found;
    }

    public static Color getItemEditForeground(LayoutItem item) {
        if (item == null) {
            return null;
        }
        Object found = item.getProperty(EDIT_FG_COLOR_KEY);
        if (found == PropertyManager.NOT_FOUND_OBJECT) {
            found = null;
        }
        return (Color)found;
    }

    private Border _getDefaultBorder() {
        if (_sDefaultBorder == null) {
            _sDefaultBorder = new SimpleBorder();
        }
        return _sDefaultBorder;
    }

    private void _initializeTextField(LayoutItem item) {
        Color useColor;
        Border useBorder;
        this._restoreDefaults();
        JTextComponent field = this.getEditComponent();
        Font useFont = JFCTextEditHandler.getItemEditFont(item);
        if (useFont != null) {
            field.setFont(useFont);
        }
        if ((useBorder = JFCTextEditHandler.getItemEditBorder(item)) != null) {
            field.setBorder(useBorder);
        }
        if ((useColor = JFCTextEditHandler.getItemEditBackground(item)) != null) {
            field.setBackground(useColor);
        }
        if ((useColor = JFCTextEditHandler.getItemEditForeground(item)) != null) {
            field.setForeground(useColor);
        }
    }

    private void _saveDefaults() {
        JTextComponent field = this.getEditComponent();
        this._dFont = field.getFont();
        this._dBorder = field.getBorder();
        this._dBGC = field.getBackground();
        this._dTC = field.getForeground();
    }

    private void _restoreDefaults() {
        JTextComponent field = this.getEditComponent();
        field.setFont(this._dFont);
        field.setBorder(this._dBorder);
        field.setBackground(this._dBGC);
        field.setForeground(this._dTC);
    }

    private LayoutItem _getEditItem() {
        if (this._editItem == null) {
            JTextComponent field = this.getEditComponent();
            this._editItem = new ComponentItem(field);
        }
        return this._editItem;
    }

    private class SimpleBorder
    extends AbstractBorder {
        SimpleBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.drawRect(x, y, width - 1, height - 1);
        }
    }
}

