/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.gallery.GalleryElementActionFactory;
import oracle.ideimpl.gallery.GalleryElementReference;
import oracle.ideimpl.gallery.NewMenuCustomizationHook;

final class NewMenuListenerForApp
implements ContextMenuListener {
    private static List<JMenuItem> _newMenuCustomizationItems;

    NewMenuListenerForApp() {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (contextMenu.getContext() != null) {
            this.addNewMenuCustomizations(contextMenu);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void addNewMenuCustomizations(ContextMenu contextMenu) {
        if (_newMenuCustomizationItems == null) {
            List<GalleryElementReference> galleryItems = NewMenuCustomizationHook.get().getGalleryItems();
            if (!galleryItems.isEmpty()) {
                GalleryElementActionFactory actionFactory = GalleryElementActionFactory.getInstance();
                _newMenuCustomizationItems = new ArrayList<JMenuItem>(galleryItems.size());
                for (GalleryElementReference item : galleryItems) {
                    IdeAction action = actionFactory.actionForItemNamed(item.getName(), item.getId());
                    if (action == null) continue;
                    JMenuItem menuItem = contextMenu.createMenuItem((ToggleAction)action);
                    contextMenu.add((Component)menuItem, 7.077f);
                    _newMenuCustomizationItems.add(menuItem);
                }
            } else {
                _newMenuCustomizationItems = Collections.emptyList();
            }
        }
        if (!_newMenuCustomizationItems.isEmpty()) {
            for (JMenuItem m : _newMenuCustomizationItems) {
                contextMenu.add((Component)m, 3.077f);
            }
        }
    }
}

