/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.gallery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ideimpl.gallery.GalleryElementReference;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

final class GalleryCustomizationsHook
extends HashStructureHook {
    private boolean initialized = false;
    private List<GalleryElementReference> _items;
    private List<FolderReference> _folders;
    private static final String GALLERY_ITEM_ELEMENT_KEY = "gallery-item";
    private static final String FOLDER_ELEMENT_KEY = "gallery-folder";
    private static final String FOLDER_NAME_KEY = "name";
    private static final String HIDDEN_ELEMENT_KEY = "hidden";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/customization", "gallery-customizations");
    private static final Logger LOGGER = Logger.getLogger(GalleryCustomizationsHook.class.getName());

    GalleryCustomizationsHook() {
    }

    public void start(ElementStartContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.start(context);
        }
    }

    public void end(ElementEndContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.end(context);
        }
    }

    static GalleryCustomizationsHook get() {
        return (GalleryCustomizationsHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    LOGGER.log(Level.SEVERE, "The gallery-customizations hook can be used once in the role file.");
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    HashStructure hash = e.getCombinedHashStructure();
                    GalleryCustomizationsHook.this.populateGalleryItems(hash);
                    GalleryCustomizationsHook.this.populateFolders(hash);
                }
            });
        }
    }

    private void populateGalleryItems(HashStructure hash) {
        List galleryItems = hash.getAsList(GALLERY_ITEM_ELEMENT_KEY);
        if (galleryItems == null) {
            this._items = Collections.emptyList();
            return;
        }
        this._items = new ArrayList<GalleryElementReference>(galleryItems.size());
        for (HashStructure itemHash : galleryItems) {
            GalleryElementReference elementReference = GalleryElementReference.getInstance(itemHash);
            if (elementReference.getName() == null) {
                LOGGER.log(Level.SEVERE, "gallery-item is not defined correctly in role file. Missing attribute: item-name.");
                continue;
            }
            this._items.add(elementReference);
        }
    }

    private void populateFolders(HashStructure hash) {
        List folders = hash.getAsList(FOLDER_ELEMENT_KEY);
        if (folders == null) {
            this._folders = Collections.emptyList();
            return;
        }
        this._folders = new ArrayList<FolderReference>(folders.size());
        for (HashStructure itemHash : folders) {
            FolderReference folderRef = FolderReference.getInstance(itemHash);
            if (folderRef.getName() == null) {
                LOGGER.log(Level.SEVERE, "Gallery folder is not defined correctly in role file. Missing attribute: name.");
                continue;
            }
            this._folders.add(folderRef);
        }
    }

    final Set<GalleryElementReference> getHiddenItems() {
        if (!this.initialized) {
            this.initialize();
        }
        HashSet<GalleryElementReference> items = new HashSet<GalleryElementReference>(this._items.size());
        for (GalleryElementReference ref : this._items) {
            if (!ref.getBoolean(HIDDEN_ELEMENT_KEY, false)) continue;
            items.add(ref);
        }
        return items;
    }

    final Set<String> getHiddenFolderNames() {
        if (!this.initialized) {
            this.initialize();
        }
        HashSet<String> folderNames = new HashSet<String>(this._folders.size());
        for (FolderReference f : this._folders) {
            if (!f.isHidden()) continue;
            folderNames.add(f.getName());
        }
        return folderNames;
    }

    private static final class FolderReference
    extends HashStructureAdapter {
        private FolderReference(HashStructure hashStructure) {
            super(hashStructure);
        }

        static FolderReference getInstance(HashStructure hashStructure) {
            return new FolderReference(hashStructure);
        }

        String getName() {
            return this._hash.getString(GalleryCustomizationsHook.FOLDER_NAME_KEY);
        }

        boolean isHidden() {
            if (this._hash.containsKey(GalleryCustomizationsHook.HIDDEN_ELEMENT_KEY)) {
                HashStructure hashStructure = this._hash.getHashStructure(GalleryCustomizationsHook.HIDDEN_ELEMENT_KEY);
                return hashStructure.getBoolean("#text", false);
            }
            return false;
        }
    }
}

