/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Enumeration;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.layout.EqualRowLayout;
import oracle.ewt.lwAWT.LWComponent;

class WizardRowLayout
extends EqualRowLayout {
    public static final String CANCEL_CONSTRAINT = "Cancel";
    public static final String HELP_CONSTRAINT = "Help";
    public static final String BACK_CONSTRAINT = "Back";
    public static final String NEXT_CONSTRAINT = "Next";
    public static final String APPLY_CONSTRAINT = "Apply";
    public static final String FINISH_CONSTRAINT = "Finish";
    private Component _cancel;
    private Component _help;
    private Component _back;
    private Component _next;
    private Component _apply;
    private Component _finish;
    private int _reserved;

    public WizardRowLayout(int n) {
        super(n);
    }

    public void setReservedButtonSpaces(int n) {
        this._reserved = n;
    }

    public int getReservedButtonSpaces() {
        return this._reserved;
    }

    public void layoutContainer(Container container) {
        boolean bl = false;
        if (container instanceof LWComponent) {
            bl = ((LWComponent)container).getActualReadingDirection() == 2;
        }
        Insets insets = container.getInsets();
        Dimension dimension = this.getCellSize(container, true);
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = n + this.getInteriorGap();
        int n4 = container.getSize().width - insets.right;
        int n5 = insets.left;
        int n6 = n4;
        int n7 = insets.top;
        int n8 = n6 - n;
        if (bl) {
            n8 = n4 - n8 - n;
        }
        this._finish.setBounds(n8, n7, n, n2);
        n8 = (n6 -= n3) - n;
        if (bl) {
            n8 = n4 - n8 - n;
        }
        this._next.setBounds(n8, n7, n, n2);
        n8 = (n6 -= n) - n + 1;
        if (bl) {
            n8 = n4 - n8 - n;
        }
        this._back.setBounds(n8, n7, n, n2);
        n6 -= n3;
        n8 = insets.left;
        Enumeration enumeration = this.getComponentEnumeration(container);
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!component.isVisible()) continue;
            if (component == this._back) break;
            if (n8 + n > n6) {
                n = n6 - n8 - this.getInteriorGap();
            }
            if (n < 0) {
                n = 0;
            }
            if (bl) {
                component.setBounds(n4 - n8 - n, n7, n, n2);
            } else {
                component.setBounds(n8, n7, n, n2);
            }
            n8 += n3;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        if (CANCEL_CONSTRAINT.equals(string)) {
            this._cancel = component;
        } else if (HELP_CONSTRAINT.equals(string)) {
            this._help = component;
        } else if (APPLY_CONSTRAINT.equals(string)) {
            this._apply = component;
        } else if (FINISH_CONSTRAINT.equals(string)) {
            this._finish = component;
        } else if (NEXT_CONSTRAINT.equals(string)) {
            this._next = component;
        } else if (BACK_CONSTRAINT.equals(string)) {
            this._back = component;
        }
    }

    protected Dimension getInsetLayoutSize(Container container, boolean bl) {
        int n = this._reserved;
        n += 4;
        if (this._help.isVisible()) {
            ++n;
        }
        if (this._apply.isVisible()) {
            ++n;
        }
        Dimension dimension = this.getCellSize(container, bl);
        int n2 = dimension.width * n;
        if (n > 1) {
            n2 += this.getInteriorGap() * (n - 1);
        }
        return new Dimension(n2, dimension.height);
    }

    protected Dimension getCellSize(Container container, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            if (n2 < dimension.height) {
                n2 = dimension.height;
            }
            if (n >= dimension.width) continue;
            n = dimension.width;
        }
        Font font = container.getFont();
        if (font != null) {
            n += 3 * FontUtils.getAverageWidth(font);
        }
        return new Dimension(n, n2);
    }
}

