/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util.stringFilter;

import oracle.ewt.util.stringFilter.StringFilter;

public class TabFilter
implements StringFilter {
    private String _spaceString;
    private StringFilter _inputFilter;

    public TabFilter() {
        this(4);
    }

    public TabFilter(int n) {
        this(null, n);
    }

    public TabFilter(StringFilter stringFilter) {
        this(stringFilter, 0);
    }

    public TabFilter(StringFilter stringFilter, int n) {
        this._inputFilter = stringFilter;
        this.setSpacesPerTab(n);
    }

    public void setSpacesPerTab(int n) {
        if (n != this.getSpacesPerTab()) {
            this._spaceString = TabFilter._makeSpaceString(n);
        }
    }

    public int getSpacesPerTab() {
        return this._spaceString != null ? this._spaceString.length() : 0;
    }

    public void setInputFilter(StringFilter stringFilter) {
        this._inputFilter = stringFilter;
    }

    public StringFilter getInputFilter() {
        return this._inputFilter;
    }

    public static String convertTabsToSpaces(String string, int n) {
        return TabFilter._convertTabsToSpaces(string, TabFilter._makeSpaceString(n));
    }

    public String convertString(String string) {
        if (this._inputFilter != null) {
            string = this._inputFilter.convertString(string);
        }
        return TabFilter._convertTabsToSpaces(string, this._spaceString);
    }

    private static String _convertTabsToSpaces(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        String string3 = "";
        do {
            if ((n = string.indexOf(9, n2)) < 0) {
                n = n3;
                string2 = null;
            }
            if (n > 0) {
                string3 = string3 + string.substring(n2, n);
            }
            if (string2 == null) continue;
            string3 = string3 + string2;
        } while ((n2 = n + 1) <= n3);
        return string3;
    }

    private static String _makeSpaceString(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }
}

