/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Image;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.toolBar.ToolBarButton;

public class ToolBarMultiIconButton
extends ToolBarButton {
    Image[] _iconList;
    private int _currentIcon;

    public ToolBarMultiIconButton(Image[] imageArray) {
        this(-1, imageArray);
    }

    public ToolBarMultiIconButton(int n, Image[] imageArray) {
        this.setID(n);
        this.setIcons(imageArray);
    }

    public void setIconIndex(int n) {
        if (n != this._currentIcon) {
            this._currentIcon = n;
            this.setIcon(this._iconList[this._currentIcon]);
        }
    }

    public int getIconIndex() {
        return this._currentIcon;
    }

    public void activate() {
        if (++this._currentIcon >= this._iconList.length) {
            this._currentIcon = 0;
        }
        this.setIcon(this._iconList[this._currentIcon]);
        super.activate();
    }

    public void setIcons(Image[] imageArray) {
        this._iconList = imageArray;
        this._currentIcon = 0;
        this.setIcon(imageArray[0]);
    }

    public Image[] getIcons() {
        return this._iconList;
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private class Access
    extends ToolBarButton.ButtonAccess
    implements AccessibleValue {
        private Access() {
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger((int)ToolBarMultiIconButton.this.getIconIndex());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            ToolBarMultiIconButton.this.setIconIndex(number.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger((int)0);
        }

        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger((int)(ToolBarMultiIconButton.this._iconList.length - 1));
        }
    }
}

