/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.EwtComponent;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.plaf.ToolBarUI;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarComponentWrapper;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarMouseListener;
import oracle.ewt.toolBar.ToolBarToolTip;
import oracle.ewt.util.ImmInsets;

public class ToolBar
extends EwtComponent {
    private int _nitems;
    private ToolBarItem[] _items;
    private ToolBarItem _motionItem;
    private ToolBarItem _grabItem;
    private boolean _isHorizontal;
    private ListenerManager _mouseListeners;
    private ListenerManager _actionListeners;
    private BorderPainter _buttonBorder;
    private boolean _areImagesDisplayed = true;
    private boolean _areLabelsDisplayed = true;

    public ToolBar() {
        this(4);
    }

    public ToolBar(int n) {
        this._items = new ToolBarItem[n];
        this.setLayout(null);
        this._isHorizontal = true;
        this.enableEvents(48L);
        this.setToolTipValue(new ToolBarToolTip(this));
    }

    public void setLabelsDisplayed(boolean bl) {
        if (this._areLabelsDisplayed != bl) {
            this._areLabelsDisplayed = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean getLabelsDisplayed() {
        return this._areLabelsDisplayed;
    }

    public void setImagesDisplayed(boolean bl) {
        if (this._areImagesDisplayed != bl) {
            this._areImagesDisplayed = bl;
            this.invalidate();
            this.repaint();
        }
    }

    public boolean getImagesDisplayed() {
        return this._areImagesDisplayed;
    }

    public Object getUIClassID() {
        return "ToolBarUI";
    }

    public final void addItem(ToolBarItem toolBarItem) {
        this.addItem(toolBarItem, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(ToolBarItem toolBarItem, ToolBarItem toolBarItem2) {
        Object object;
        if (toolBarItem.getParent() != null) {
            toolBarItem.getParent().removeItem(toolBarItem);
        }
        Component component = this;
        synchronized (component) {
            int n = toolBarItem2 != null ? this.getItemIndex(toolBarItem2) : -1;
            if (this._nitems == this._items.length) {
                object = new ToolBarItem[this._nitems * 2];
                System.arraycopy(this._items, 0, object, 0, this._nitems);
                this._items = object;
            }
            if (n == -1) {
                this._items[this._nitems] = toolBarItem;
            } else {
                System.arraycopy(this._items, n, this._items, n + 1, this._nitems - n);
                this._items[n] = toolBarItem;
            }
            ++this._nitems;
            toolBarItem.setParent(this);
        }
        component = toolBarItem.getComponent();
        if (component != null) {
            super.add(component, -1);
        }
        this.invalidateCanvas();
        object = this.accessAccessibleContext();
        if (object != null && component == null) {
            ((AccessibleContext)object).firePropertyChange("AccessibleChild", null, toolBarItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(ToolBarItem toolBarItem) {
        Component component = toolBarItem.getComponent();
        if (component != null) {
            super.remove(component);
        }
        Object object = this;
        synchronized (object) {
            toolBarItem.setParent(null);
            int n = this.getItemIndex(toolBarItem);
            this._items[n] = null;
            --this._nitems;
            if (n < this._nitems) {
                System.arraycopy(this._items, n + 1, this._items, n, this._nitems - n);
            }
            this._items[this._nitems] = null;
        }
        if (toolBarItem.isVisible()) {
            this.invalidateCanvas();
        }
        if ((object = this.accessAccessibleContext()) != null && component == null) {
            ((AccessibleContext)object).firePropertyChange("AccessibleChild", toolBarItem, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ToolBar toolBar = this;
        synchronized (toolBar) {
            for (int i = 0; i < this._nitems; ++i) {
                this._items[i].setParent(null);
                this._items[i] = null;
            }
            this._nitems = 0;
        }
        super.removeAll();
        this.invalidateCanvas();
    }

    public Component add(Component component) {
        return this.add(component, -1);
    }

    public Component add(Component component, int n) {
        ToolBarItem toolBarItem = n == -1 ? null : this._items[n];
        this.addItem(new ToolBarComponentWrapper(component), toolBarItem);
        return component;
    }

    public Component add(String string, Component component) {
        return this.add(component, -1);
    }

    public void remove(Component component) {
        this.removeItem(this.findComponent(component));
    }

    public ToolBarItem findComponent(Component component) {
        if (component == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this._nitems; ++i) {
            if (this._items[i].getComponent() != component) continue;
            return this._items[i];
        }
        return null;
    }

    protected void paintCanvasInterior(Graphics graphics) {
        Dimension dimension = this.getInnerSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getForeground());
        for (int i = 0; i < this._nitems; ++i) {
            ToolBarItem toolBarItem = this._items[i];
            if (!toolBarItem.isVisible()) continue;
            toolBarItem.paint(graphics);
        }
    }

    public Dimension layoutCanvas() {
        int n;
        int n2;
        int n3;
        Dimension dimension = this.getInnerSize();
        Point point = new Point(0, 0);
        boolean bl = this.isHorizontal();
        int n4 = n3 = bl ? dimension.height / 2 : dimension.width / 2;
        if (bl && (n2 = this.getActualAlignment()) != 1) {
            Dimension dimension2 = this.getPreferredSize();
            ImmInsets immInsets = this.getBorderInsets();
            dimension2.width -= immInsets.left + immInsets.right;
            point.x = dimension.width - dimension2.width;
            if (n2 == 3) {
                point.x /= 2;
            }
        }
        boolean bl2 = (n2 = this.getActualReadingDirection()) == 1 || !bl;
        int n5 = n = bl2 ? 0 : this._nitems - 1;
        while (n >= 0 && n < this._nitems) {
            ToolBarItem toolBarItem = this._items[n];
            if (toolBarItem.isVisible()) {
                Dimension dimension3 = toolBarItem.getSize();
                Dimension dimension4 = toolBarItem.getPreferredSize();
                if (dimension3.width != dimension4.width || dimension3.height != dimension4.height) {
                    toolBarItem.setSize(dimension4.width, dimension4.height);
                    dimension3 = toolBarItem.getSize();
                }
                if (bl) {
                    point.y = n3 - dimension3.height / 2;
                    toolBarItem.setLocation(point.x, point.y);
                    point.x += dimension3.width;
                } else {
                    point.x = n3 - dimension3.width / 2;
                    toolBarItem.setLocation(point.x, point.y);
                    point.y += dimension3.height;
                }
            }
            if (bl2) {
                ++n;
                continue;
            }
            --n;
        }
        if (bl) {
            return new Dimension(point.x, dimension.height);
        }
        return new Dimension(dimension.width, point.y);
    }

    public ToolBarItem getItemAt(int n, int n2) {
        Point point = this.convertOuterToCanvas(n, n2);
        for (int i = 0; i < this._nitems; ++i) {
            if (!this._items[i].inside(point.x, point.y)) continue;
            return this._items[i];
        }
        return null;
    }

    public int getItemCount() {
        return this._nitems;
    }

    public synchronized ToolBarItem[] getItems() {
        ToolBarItem[] toolBarItemArray = new ToolBarItem[this._nitems];
        System.arraycopy(this._items, 0, toolBarItemArray, 0, this._nitems);
        return toolBarItemArray;
    }

    public ToolBarItem getItemById(int n) {
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this._nitems; ++i) {
            if (this._items[i].getID() != n) continue;
            return this._items[i];
        }
        return null;
    }

    public ToolBarItem getItem(int n) {
        return this._items[n];
    }

    public int getItemIndex(ToolBarItem toolBarItem) {
        for (int i = 0; i < this._nitems; ++i) {
            if (toolBarItem != this._items[i]) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean isHorizontal() {
        return this._isHorizontal;
    }

    public void setHorizontal(boolean bl) {
        if (this._isHorizontal != bl) {
            this._isHorizontal = bl;
            this.invalidateCanvas();
        }
    }

    public BorderPainter getButtonBorderPainter() {
        if (this._buttonBorder != null) {
            return this._buttonBorder;
        }
        return this.getToolBarUI().getButtonBorderPainter(this);
    }

    public void setButtonBorderPainter(BorderPainter borderPainter) {
        if (this._buttonBorder != borderPainter) {
            this._buttonBorder = borderPainter;
            this.invalidate();
            this.repaintCanvas();
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public synchronized Dimension getMinimumSize() {
        BorderPainter borderPainter = this.getBorderPainter();
        PaintContext paintContext = this.getPaintContext();
        Dimension dimension = borderPainter != null ? borderPainter.getMinimumSize(paintContext) : new Dimension(0, 0);
        int n = 0;
        int n2 = 0;
        boolean bl = this.isHorizontal();
        for (int i = 0; i < this._nitems; ++i) {
            Dimension dimension2 = this._items[i].getPreferredSize();
            if (bl) {
                n2 = dimension2.height > n2 ? dimension2.height : n2;
                n += dimension2.width;
                continue;
            }
            n = dimension2.width > n ? dimension2.width : n;
            n2 += dimension2.height;
        }
        if (n > dimension.width) {
            dimension.width = n;
        }
        if (n2 > dimension.height) {
            dimension.height = n2;
        }
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public void addToolBarActionListener(ToolBarActionListener toolBarActionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener(toolBarActionListener);
    }

    public void removeToolBarActionListener(ToolBarActionListener toolBarActionListener) {
        this._actionListeners.removeListener(toolBarActionListener);
    }

    public void addToolBarMouseListener(ToolBarMouseListener toolBarMouseListener) {
        if (this._mouseListeners == null) {
            this._mouseListeners = new ListenerManager();
        }
        this._mouseListeners.addListener(toolBarMouseListener);
    }

    public void removeToolBarMouseListener(ToolBarMouseListener toolBarMouseListener) {
        this._mouseListeners.removeListener(toolBarMouseListener);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (mouseEvent.getID()) {
            case 504: {
                this.processMouseEntered(mouseEvent, n, n2);
                break;
            }
            case 505: {
                this.processMouseExited(mouseEvent, n, n2);
                break;
            }
            case 501: {
                this.processMousePressed(mouseEvent, n, n2);
                break;
            }
            case 502: {
                this.processMouseReleased(mouseEvent, n, n2);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (mouseEvent.getID()) {
            case 503: {
                this.processMouseMoved(mouseEvent, n, n2);
                break;
            }
            case 506: {
                this.processMouseDragged(mouseEvent, n, n2);
            }
        }
    }

    protected boolean processMouseMoved(MouseEvent mouseEvent, int n, int n2) {
        ToolBarItem toolBarItem = this.getItemAt(n, n2);
        Point point = this.convertOuterToCanvas(n, n2);
        ToolBarItem toolBarItem2 = this._motionItem;
        if (toolBarItem != toolBarItem2) {
            if (toolBarItem2 != null) {
                toolBarItem2.mouseExited(mouseEvent, point.x, point.y);
                this.processEvent(new ToolBarEvent(this, 2002, toolBarItem2));
            }
            if (toolBarItem != null) {
                toolBarItem.mouseEntered(mouseEvent, point.x, point.y);
                this.processEvent(new ToolBarEvent(this, 2001, toolBarItem));
            }
        }
        if (this._motionItem != null) {
            this._motionItem.mouseMoved(mouseEvent, point.x, point.y);
        }
        return true;
    }

    protected boolean processMouseEntered(MouseEvent mouseEvent, int n, int n2) {
        ToolBarItem toolBarItem = this.getItemAt(n, n2);
        if (toolBarItem != null) {
            this.processEvent(new ToolBarEvent(this, 2001, toolBarItem));
            Point point = this.convertOuterToCanvas(n, n2);
            return toolBarItem.mouseEntered(mouseEvent, point.x, point.y);
        }
        return false;
    }

    protected boolean processMouseExited(MouseEvent mouseEvent, int n, int n2) {
        ToolBarItem toolBarItem = this._motionItem;
        if (toolBarItem != null) {
            this.processEvent(new ToolBarEvent(this, 2002, toolBarItem));
            Point point = this.convertOuterToCanvas(n, n2);
            return toolBarItem.mouseExited(mouseEvent, point.x, point.y);
        }
        return false;
    }

    protected boolean processMousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this._grabItem == null) {
            this._grabItem = this.getItemAt(n, n2);
            if (this._grabItem != null) {
                Point point = this.convertOuterToCanvas(n, n2);
                return this._grabItem.mousePressed(mouseEvent, point.x, point.y);
            }
        }
        return false;
    }

    public boolean processMouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this._grabItem != null) {
            Point point = this.convertOuterToCanvas(n, n2);
            return this._grabItem.mouseDragged(mouseEvent, point.x, point.y);
        }
        return false;
    }

    protected boolean processMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        ToolBarItem toolBarItem = this._grabItem;
        if (toolBarItem != null) {
            this._grabItem = null;
            Point point = this.convertOuterToCanvas(n, n2);
            return toolBarItem.mouseReleased(mouseEvent, point.x, point.y);
        }
        return false;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ToolBarEvent) {
            this.processToolBarEvent((ToolBarEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processToolBarEvent(ToolBarEvent toolBarEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager;
        int n = toolBarEvent.getID();
        if (n == 2000) {
            listenerManager = this._actionListeners;
        } else {
            listenerManager = this._mouseListeners;
            ToolBarItem toolBarItem = this._motionItem = n == 2001 ? toolBarEvent.getItem() : null;
        }
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                switch (toolBarEvent.getID()) {
                    case 2001: {
                        ((ToolBarMouseListener)e).toolBarItemMouseEntered(toolBarEvent);
                        break;
                    }
                    case 2002: {
                        ((ToolBarMouseListener)e).toolBarItemMouseExited(toolBarEvent);
                        break;
                    }
                    case 2000: {
                        ((ToolBarActionListener)e).toolBarItemActionPerformed(toolBarEvent);
                        break;
                    }
                }
            }
        }
    }

    public synchronized void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaintCanvas();
        }
    }

    public synchronized void disable() {
        if (this.isEnabled()) {
            super.disable();
            this.repaintCanvas();
        }
    }

    protected final ToolBarUI getToolBarUI() {
        return (ToolBarUI)this.getUI();
    }

    protected int getInvalidateFlags() {
        int n = super.getInvalidateFlags();
        if (this.isHorizontal()) {
            n |= 0x4800;
        }
        return n;
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(ToolBar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }

        public int getAccessibleChildrenCount() {
            return ToolBar.this.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n > this.getAccessibleChildrenCount()) {
                return null;
            }
            ToolBarItem toolBarItem = ToolBar.this.getItem(n);
            Component component = toolBarItem.getComponent();
            if (component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return toolBarItem;
        }

        public Accessible getAccessibleAt(Point point) {
            Component component;
            ToolBarItem toolBarItem = ToolBar.this.getItemAt(point.x, point.y);
            if (toolBarItem != null && (component = toolBarItem.getComponent()) instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return toolBarItem;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (ToolBar.this.isHorizontal()) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }
    }
}

