/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.ewt.dnd.DropTarget;
import oracle.ewt.dnd.DropTargetDragEvent;
import oracle.ewt.dnd.DropTargetDropEvent;
import oracle.ewt.dnd.DropTargetEvent;
import oracle.ewt.dnd.DropTargetListener;
import oracle.ewt.lwAWT.AbstractPainterComponent;
import oracle.ewt.painter.Painter;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.pivot.PivotTransfer;
import oracle.ewt.plaf.PivotTableUI;

class PivotCorner
extends AbstractPainterComponent
implements DropTargetListener {
    private PivotTable _pivotTable;
    private PivotHeader _pivotHeader;

    public PivotCorner(PivotTable pivotTable) {
        this._pivotTable = pivotTable;
        DropTarget dropTarget = new DropTarget(this, this);
    }

    protected Painter getPainter() {
        PivotTableUI pivotTableUI = this._pivotTable.getPivotTableUI();
        return pivotTableUI.getCornerPainter(this._pivotTable);
    }

    public Object getPaintData(Object object) {
        return this._pivotTable.getPaintData(object);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        this._updateFeedback(dropTargetDragEvent.getDropTargetContext().getComponent(), dropTargetDragEvent.getLocation());
    }

    public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this._updatePivotHeader(null, null);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        this._updatePivotHeader(null, null);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        try {
            Object object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
            if (object instanceof PivotTransfer) {
                PivotTransfer pivotTransfer = (PivotTransfer)object;
                Object object2 = pivotTransfer.getSource();
                int n = pivotTransfer.getIndex();
                Point point = dropTargetDropEvent.getLocation();
                PivotHeader pivotHeader = this._getPivotHeader(dropTargetDropEvent.getDropTargetContext().getComponent(), point);
                int n2 = this._getIndex(pivotHeader, point);
                PivotTable pivotTable = this._pivotTable;
                boolean bl = true;
                if (object2 == pivotHeader) {
                    if (n < n2) {
                        --n2;
                    }
                    if (n == n2) {
                        bl = false;
                    }
                }
                if (bl) {
                    pivotTable.firePivotEvent(object2, n, pivotHeader, n2);
                    pivotTable.deselectAll();
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.getDropTargetContext().dropComplete(false);
        }
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._pivotTable.isEnabled()) {
            return false;
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    private PivotHeader _getPivotHeader(Component component, Point point) {
        boolean bl;
        PivotHeader pivotHeader = null;
        boolean bl2 = bl = this._pivotTable.getActualReadingDirection() == 1;
        pivotHeader = bl ? (point.x >= point.y ? this._getHorizontalHeader() : this._getVerticalHeader()) : (component.getSize().width - point.x >= point.y ? this._getHorizontalHeader() : this._getVerticalHeader());
        return pivotHeader;
    }

    private void _updateFeedback(Component component, Point point) {
        PivotHeader pivotHeader = this._getPivotHeader(component, point);
        this._updatePivotHeader(pivotHeader, point);
    }

    private void _updatePivotHeader(PivotHeader pivotHeader, Point point) {
        if (this._pivotHeader != pivotHeader && this._pivotHeader != null) {
            this._pivotHeader.setDropLocation(-1, false);
        }
        this._pivotHeader = pivotHeader;
        if (this._pivotHeader != null) {
            int n = this._getIndex(pivotHeader, point);
            this._pivotHeader.setDropLocation(n, false);
        }
    }

    private int _getIndex(PivotHeader pivotHeader, Point point) {
        int n = -1;
        n = pivotHeader.isHorizontal() ? pivotHeader.getRowHeader().getItemAt(1, point.y) : pivotHeader.getColumnHeader().getItemAt(point.x, 1);
        return n;
    }

    private PivotHeader _getHorizontalHeader() {
        return this._pivotTable.getColumnPivotHeader();
    }

    private PivotHeader _getVerticalHeader() {
        return this._pivotTable.getRowPivotHeader();
    }
}

