/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import oracle.ewt.painter.AbstractWrappingPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class PainterTiler
extends AbstractWrappingPainter {
    private int _preferredWidthTiles;
    private int _preferredHeightTiles;

    public PainterTiler(Painter painter) {
        this(painter, 1, 1);
    }

    public PainterTiler(Painter painter, int n, int n2) {
        super(painter);
        this._preferredWidthTiles = n;
        this._preferredHeightTiles = n2;
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        Dimension dimension = super.getPreferredSize(paintContext);
        int n3 = n / dimension.width;
        int n4 = n2 / dimension.height;
        if (n3 > this._preferredWidthTiles) {
            n3 = this._preferredWidthTiles;
        }
        if (n4 > this._preferredHeightTiles) {
            n4 = this._preferredHeightTiles;
        }
        dimension.width *= n3;
        dimension.height *= n4;
        return dimension;
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        Dimension dimension = super.getPreferredSize(paintContext);
        dimension.width *= this._preferredWidthTiles;
        dimension.height *= this._preferredHeightTiles;
        return dimension;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Painter painter = this.getWrappedPainter(paintContext);
        Dimension dimension = painter.getPreferredSize(paintContext);
        int n5 = dimension.width;
        int n6 = dimension.height;
        Rectangle rectangle = graphics.getClipBounds();
        int n7 = rectangle.x / n5 * n5;
        int n8 = rectangle.y / n6 * n6;
        int n9 = rectangle.x + rectangle.width;
        int n10 = rectangle.y + rectangle.height;
        if (n7 < n) {
            n7 = n;
        }
        if (n8 < n2) {
            n8 = n2;
        }
        if (n9 > n + n3) {
            n9 = n + n3;
        }
        if (n10 > n2 + n4) {
            n10 = n2 + n4;
        }
        Shape shape = graphics.getClip();
        graphics.clipRect(n7, n8, n9 - n7, n10 - n8);
        for (int i = n8; i < n10; i += n6) {
            for (int j = n7; j < n9; j += n5) {
                painter.paint(paintContext, graphics, j, i, n5, n6);
            }
        }
        graphics.setClip(shape);
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        if (n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
            Painter painter2 = this.getWrappedPainter(paintContext);
            Dimension dimension = painter2.getPreferredSize(paintContext);
            return super.getPainterAt(paintContext, dimension.width, dimension.height, n3 % dimension.width, n4 % dimension.height, painter);
        }
        return null;
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return super.getRepaintFlags(paintContext) | 0x80;
    }
}

