/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowManager;
import oracle.ewt.lwAWT.lwWindow.laf.TitleBar;
import oracle.ewt.util.WindowUtils;

abstract class BaseWindowReshaper
implements KeyListener,
WindowListener {
    private boolean _reshaping;
    private LWWindow _window;
    private Component _focusComp;
    private MouseGrabProvider _mouseGrabProvider;
    private Window _hwWindow;

    public BaseWindowReshaper(LWWindow lWWindow) {
        this._window = lWWindow;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            this.endReshaping(false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.endReshaping(false);
        } else if (n == 10) {
            this.endReshaping(true);
        }
        keyEvent.consume();
    }

    protected boolean beginReshaping() {
        MouseListener mouseListener;
        if (this.isReshaping() || !this.isWindowReshapable()) {
            return false;
        }
        this._focusComp = this.getWindow().getFocusOwner();
        if (this._focusComp != null) {
            this._focusComp.addKeyListener(this);
        }
        if ((mouseListener = this.getMouseGrab()) != null) {
            this._mouseGrabProvider = TrackingUtils.getMouseGrabProvider(this.getWindow());
            if (this._mouseGrabProvider != null) {
                this._mouseGrabProvider.addMouseGrab(mouseListener);
            }
        }
        this._hwWindow = WindowUtils.getWindow(this.getWindow());
        if (this._hwWindow != null) {
            this._hwWindow.addWindowListener(this);
        }
        this._reshaping = true;
        return true;
    }

    protected void endReshaping(boolean bl) {
        if (this.isReshaping()) {
            if (this._focusComp != null) {
                this._focusComp.removeKeyListener(this);
                this._focusComp = null;
            }
            if (this._mouseGrabProvider != null) {
                this._mouseGrabProvider.removeMouseGrab(this.getMouseGrab());
                this._mouseGrabProvider = null;
            }
            if (this._hwWindow != null) {
                this._hwWindow.removeWindowListener(this);
                this._hwWindow = null;
            }
            this._reshaping = false;
        }
    }

    protected MouseListener getMouseGrab() {
        return null;
    }

    protected LWWindow getWindow() {
        if (this._window != null) {
            return this._window;
        }
        return TitleBar.__getSystemPopupOwner();
    }

    protected WindowManager getWindowManager() {
        Desktop desktop = this.getWindow().getDesktop();
        return desktop == null ? null : desktop.getWindowManager();
    }

    protected boolean isReshaping() {
        return this._reshaping;
    }

    protected abstract boolean isWindowReshapable();

    public void windowDeactivated(WindowEvent windowEvent) {
        this.endReshaping(false);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.endReshaping(false);
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.endReshaping(false);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }
}

