/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu.laf;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.MenuUtils;
import oracle.ewt.lwAWT.lwMenu.laf.HorzMenuController;

public class MenuBarController
extends KeyAdapter {
    private LWMenuBar _menuBar;

    public MenuBarController(LWMenuBar lWMenuBar) {
        this._menuBar = lWMenuBar;
    }

    public void keyPressed(KeyEvent keyEvent) {
        LWMenuItem lWMenuItem = this._menuBar.getSelectedItem();
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (this._isLeftToRight()) {
                    this._selectPreviousItem(lWMenuItem);
                } else {
                    this._selectNextItem(lWMenuItem);
                }
                keyEvent.consume();
                break;
            }
            case 39: {
                if (this._isLeftToRight()) {
                    this._selectNextItem(lWMenuItem);
                } else {
                    this._selectPreviousItem(lWMenuItem);
                }
                keyEvent.consume();
                break;
            }
            case 18: 
            case 27: {
                lWMenuItem.setSelected(false);
                keyEvent.consume();
            }
        }
    }

    private boolean _displaySubmenu() {
        return this._menuBar.getClientProperty(HorzMenuController._CLIENTPROP_DISPLAY_SUBMENU) != null;
    }

    private LWMenuItem _getNextItem(LWMenuItem lWMenuItem) {
        LWMenuItem lWMenuItem2;
        LWMenuBar lWMenuBar;
        LWMenuItem lWMenuItem3 = MenuUtils.getNextItem(this._menuBar, lWMenuItem);
        if (lWMenuItem != null && (lWMenuItem3 == null || MenuBarController._getIndex(lWMenuItem) >= MenuBarController._getIndex(lWMenuItem3)) && (lWMenuBar = (LWMenuBar)this._menuBar.getClientProperty("_ewtNextMenuBar")) != null && (lWMenuItem2 = MenuUtils.getNextItem(lWMenuBar, null)) != null) {
            lWMenuItem3 = lWMenuItem2;
        }
        return lWMenuItem3;
    }

    private LWMenuItem _getPreviousItem(LWMenuItem lWMenuItem) {
        LWMenuItem lWMenuItem2;
        LWMenuBar lWMenuBar;
        LWMenuItem lWMenuItem3 = MenuUtils.getPreviousItem(this._menuBar, lWMenuItem);
        if (lWMenuItem != null && (lWMenuItem3 == null || MenuBarController._getIndex(lWMenuItem) <= MenuBarController._getIndex(lWMenuItem3)) && (lWMenuBar = (LWMenuBar)this._menuBar.getClientProperty("_ewtNextMenuBar")) != null && (lWMenuItem2 = MenuUtils.getPreviousItem(lWMenuBar, null)) != null) {
            lWMenuItem3 = lWMenuItem2;
        }
        return lWMenuItem3;
    }

    private boolean _isLeftToRight() {
        return this._menuBar.getActualReadingDirection() == 1;
    }

    private void _selectNextItem(LWMenuItem lWMenuItem) {
        LWMenuItem lWMenuItem2 = this._getNextItem(lWMenuItem);
        if (lWMenuItem2 != null && lWMenuItem2.getParent().isShowing()) {
            boolean bl;
            boolean bl2 = bl = this._displaySubmenu() && lWMenuItem2.isEnabled() && lWMenuItem2 instanceof LWMenu;
            if (lWMenuItem != null && lWMenuItem2.getParent() != lWMenuItem.getParent()) {
                lWMenuItem.setSelected(false);
            }
            if (bl) {
                ((LWMenu)lWMenuItem2).setSubMenuDisplayed(true);
            } else {
                lWMenuItem2.setSelected(true);
            }
        }
    }

    private void _selectPreviousItem(LWMenuItem lWMenuItem) {
        LWMenuItem lWMenuItem2 = this._getPreviousItem(lWMenuItem);
        if (lWMenuItem2 != null && lWMenuItem2.getParent().isShowing()) {
            boolean bl;
            boolean bl2 = bl = this._displaySubmenu() && lWMenuItem2.isEnabled() && lWMenuItem2 instanceof LWMenu;
            if (lWMenuItem != null && lWMenuItem2.getParent() != lWMenuItem.getParent()) {
                lWMenuItem.setSelected(false);
            }
            if (bl) {
                ((LWMenu)lWMenuItem2).setSubMenuDisplayed(true);
            } else {
                lWMenuItem2.setSelected(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _getIndex(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            Container container = component.getParent();
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (component != container.getComponent(i)) continue;
                return i;
            }
            return -1;
        }
    }
}

