/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.laf.oracle.OracleComponentUI;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwWindow.MDIRootPane;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.MDIRootPaneUI;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.ImmInsets;

public class OracleMDIRootPaneUI
extends OracleComponentUI
implements MDIRootPaneUI {
    private static BorderPainter _sStatusBarBorder;
    private static BorderPainter _sHorzToolBarBorder;
    private static BorderPainter _sVertToolBarBorder;

    public OracleMDIRootPaneUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public BorderPainter getStatusBarBorder(LWComponent lWComponent) {
        if (_sStatusBarBorder == null) {
            _sStatusBarBorder = new FixedBorderPainter(4, 4, 4, 4);
        }
        return _sStatusBarBorder;
    }

    public BorderPainter getHorizontalToolBarBorder(LWComponent lWComponent) {
        if (_sHorzToolBarBorder == null) {
            _sHorzToolBarBorder = new FixedBorderPainter(0, 4, 4, 4);
        }
        return _sHorzToolBarBorder;
    }

    public BorderPainter getVerticalToolBarBorder(LWComponent lWComponent) {
        if (_sVertToolBarBorder == null) {
            _sVertToolBarBorder = new FixedBorderPainter(4, 1, 4, 1);
        }
        return _sVertToolBarBorder;
    }

    public BorderPainter getDesktopBorder(LWComponent lWComponent) {
        return DesktopBorder.getInstance();
    }

    public Painter getDefaultLogoPainter(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getPainter("MDIRootPane.LogoPainter");
    }

    public void installUI(LWComponent lWComponent) {
        super.installUI(lWComponent);
        MDIRootPane mDIRootPane = (MDIRootPane)lWComponent;
        ScrollBox scrollBox = mDIRootPane.getScrollBox();
        scrollBox.setBorderPainter(null);
    }

    public void uninstallUI(LWComponent lWComponent) {
        super.uninstallUI(lWComponent);
        MDIRootPane mDIRootPane = (MDIRootPane)lWComponent;
        ScrollBox scrollBox = mDIRootPane.getScrollBox();
        scrollBox.setBorderPainter(LWComponent.DEFAULT_BORDERPAINTER);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals("MDIRootPane.LogoPainter")) {
            return new FixedBorderPainter(new ImageSetPainter(new SynthesizingImageSet(uIDefaults.getImage("MDIRootPane.Logo"))), 4, 4, 4, 4);
        }
        return null;
    }

    private static final class DesktopBorder
    extends AbstractBorderPainter {
        private static DesktopBorder _sInstance;
        private static final ImmInsets _BORDER_INSETS;

        public static DesktopBorder getInstance() {
            if (_sInstance == null) {
                _sInstance = new DesktopBorder();
            }
            return _sInstance;
        }

        private DesktopBorder() {
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            return _BORDER_INSETS;
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n + n3 - 1;
            int n6 = n2 + n4 - 1;
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            graphics.setColor(uIDefaults.getColor("MDIRootPane.topBorder"));
            graphics.drawLine(n, n2, n5, n2);
            graphics.setColor(uIDefaults.getColor("MDIRootPane.bottomBorder"));
            graphics.drawLine(n, n6, n5, n6);
            graphics.setColor(color);
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return false;
        }

        static {
            _BORDER_INSETS = new ImmInsets(1, 0, 1, 0);
        }
    }
}

