/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.basic.DisablingPainter;
import oracle.ewt.laf.generic.GenericInsetBorderPainter;
import oracle.ewt.laf.generic.GenericLookAndFeel;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.FixedSizePainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TextPainter;
import oracle.ewt.plaf.StatusBarUI;

public class GenericStatusBarUI
extends BasicComponentUI
implements StatusBarUI {
    private static final Painter _MINIMUM_PAINTER = new DisablingPainter(new TextPainter("MinimumText"));
    private static Painter _sImageSetPainter;
    private static final Painter _CORE_SPLITTER_PAINTER;
    private static final Painter _LEFT_SPLITTER_PAINTER;
    private static final Painter _CENTER_SPLITTER_PAINTER;
    private static final Painter _RIGHT_SPLITTER_PAINTER;
    private static BorderPainter _sItemBorderPainter;

    public GenericStatusBarUI(LWComponent lWComponent) {
        super(lWComponent);
        if (_sItemBorderPainter == null) {
            _sItemBorderPainter = this.getUIDefaults(lWComponent).getBorderPainter(STATUSBAR_ITEM_BORDER);
        }
    }

    public Painter getTextPainter(LWComponent lWComponent) {
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        return uIDefaults.getPainter(GenericLookAndFeel.DEFAULT_TEXT_PAINTER);
    }

    public Painter getMinimumSizeTextPainter(LWComponent lWComponent) {
        return _MINIMUM_PAINTER;
    }

    public Painter getImageSetPainter(LWComponent lWComponent) {
        if (_sImageSetPainter == null) {
            UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
            _sImageSetPainter = new AlignmentPainter(uIDefaults.getPainter(LookAndFeel.IMAGE_SET_PAINTER));
        }
        return _sImageSetPainter;
    }

    public Painter getLeftSplitterPainter(LWComponent lWComponent) {
        return _LEFT_SPLITTER_PAINTER;
    }

    public Painter getCenterSplitterPainter(LWComponent lWComponent) {
        return _CENTER_SPLITTER_PAINTER;
    }

    public Painter getRightSplitterPainter(LWComponent lWComponent) {
        return _RIGHT_SPLITTER_PAINTER;
    }

    public BorderPainter getItemBorderPainter(LWComponent lWComponent) {
        return _sItemBorderPainter;
    }

    public Painter getStaticSplitterPainter(LWComponent lWComponent) {
        return null;
    }

    public int getItemSpacing(LWComponent lWComponent) {
        return 1;
    }

    static {
        _CORE_SPLITTER_PAINTER = new GenericInsetBorderPainter(new FixedSizePainter(null, 1, -1), true, true);
        _LEFT_SPLITTER_PAINTER = new FixedBorderPainter(_CORE_SPLITTER_PAINTER, 0, 1, 0, 3);
        _CENTER_SPLITTER_PAINTER = new FixedBorderPainter(_CORE_SPLITTER_PAINTER, 0, 2, 0, 2);
        _RIGHT_SPLITTER_PAINTER = new FixedBorderPainter(_CORE_SPLITTER_PAINTER, 0, 3, 0, 1);
    }
}

