/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.Grid;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FormatPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.popup.MLLabelToolTip;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipSite;
import oracle.ewt.util.ImmInsets;

public class GridToolTipClient
implements ToolTipClient {
    private static ToolTipClient _sToolTipClient = new GridToolTipClient();
    private static final int[] _ALIGNMENTS = new int[]{17, 16, 5, 6, 7, 10, 11, 12};

    public static ToolTipClient getToolTipClient() {
        return _sToolTipClient;
    }

    public ToolTipSite getToolTipSite(Component component, int n, int n2) {
        Grid grid = (Grid)component;
        Point point = grid.convertOuterToCanvas(n, n2);
        int n3 = grid.getColumnAt(point.x);
        int n4 = grid.getRowAt(point.y);
        if (n3 < 0 || n4 < 0) {
            return null;
        }
        if (!this.shouldDisplay(grid, n3, n4)) {
            return null;
        }
        Object object = this.getCellToolTipValue(grid, n3, n4);
        Point point2 = new Point(grid.getColumnPosition(n3), grid.getRowPosition(n4));
        point2 = grid.convertCanvasToOuter(point2.x, point2.y);
        Rectangle rectangle = new Rectangle(point2.x, point2.y, grid.getColumnWidth(n3), grid.getRowHeight(n4));
        return new ToolTipSite(object, rectangle, _ALIGNMENTS, MLLabelToolTip.getToolTip());
    }

    protected Object getCellToolTipValue(Grid grid, int n, int n2) {
        Object object = grid.getDataSource().getData(n, n2);
        Painter painter = grid.getColumnPainter(n);
        if (painter instanceof FormatPainter && object != null) {
            object = ((FormatPainter)painter).getFormat().format(object);
        }
        return object;
    }

    protected boolean shouldDisplay(Grid grid, int n, int n2) {
        BorderPainter borderPainter;
        Object object = this.getCellToolTipValue(grid, n, n2);
        if (!(object instanceof String)) {
            return false;
        }
        int n3 = grid.getColumnPosition(n);
        int n4 = grid.getRowPosition(n2);
        int n5 = grid.getColumnWidth(n);
        int n6 = grid.getRowHeight(n2);
        Point point = grid.getCanvasOrigin();
        Dimension dimension = grid.getInnerSize();
        Painter painter = grid.getColumnPainter(n);
        PaintContext paintContext = grid.getCellPaintContext(n, n2);
        Dimension dimension2 = painter.getPreferredSize(paintContext);
        Appearance appearance = grid.getAppearanceManager().getCellPaintingAppearance(n, n2);
        ImmInsets immInsets = appearance.getInsets();
        if (immInsets != null) {
            dimension2.width += immInsets.left + immInsets.right;
        }
        if ((borderPainter = appearance.getBorderPainter()) != null && (immInsets = borderPainter.getInsets(paintContext)) != null) {
            dimension2.width += immInsets.left + immInsets.right;
        }
        return dimension2.width > n5 || dimension2.height > n6 || -point.x > n3 || -point.y > n4 || -point.x + dimension.width < n3 + n5 || -point.y + dimension.height < n4 + n6;
    }

    protected GridToolTipClient() {
    }
}

