/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.util.EventObject;
import oracle.ewt.dnd.DragGestureRecognizer;
import oracle.ewt.dnd.DragSource;
import oracle.ewt.dnd.DragSourceListener;
import oracle.ewt.dnd.InvalidDnDOperationException;

public class DragGestureEvent
extends EventObject {
    private InputEvent _first;
    private InputEvent _last;
    private DragSource _dragSource;
    private Component _component;
    private Point _origin;
    private int _action;

    DragGestureEvent(DragGestureRecognizer dragGestureRecognizer, int n, Point point, InputEvent inputEvent, InputEvent inputEvent2) {
        super(dragGestureRecognizer);
        this._component = dragGestureRecognizer.getComponent();
        if (this._component == null) {
            throw new IllegalArgumentException("null component");
        }
        this._dragSource = dragGestureRecognizer.getDragSource();
        if (this._dragSource == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        if (inputEvent == null) {
            throw new IllegalArgumentException("null or empty list of events");
        }
        if (n != 1 && n != 2 && n != 0x40000000) {
            throw new IllegalArgumentException("bad action");
        }
        if (point == null) {
            throw new IllegalArgumentException("null origin");
        }
        this._first = inputEvent;
        this._last = inputEvent2;
        this._action = n;
        this._origin = point;
    }

    public DragGestureRecognizer getSourceAsDragGestureRecognizer() {
        return (DragGestureRecognizer)this.getSource();
    }

    public Component getComponent() {
        return this._component;
    }

    public DragSource getDragSource() {
        return this._dragSource;
    }

    public Point getDragOrigin() {
        return this._origin;
    }

    public Object[] toArray() {
        if (this._last == null) {
            return new Object[]{this._first};
        }
        return new Object[]{this._first, this._last};
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray != null && (this._last == null && objectArray.length >= 1 || objectArray.length >= 2)) {
            int n;
            objectArray[0] = this._first;
            if (this._last == null) {
                n = 1;
            } else {
                objectArray[1] = this._last;
                n = 2;
            }
            while (n < objectArray.length) {
                objectArray[n++] = null;
            }
            return objectArray;
        }
        return this.toArray();
    }

    public int getDragAction() {
        return this._action;
    }

    public InputEvent getTriggerEvent() {
        return this.getSourceAsDragGestureRecognizer().getTriggerEvent();
    }

    public void startDrag(Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this._dragSource.startDrag(this, cursor, transferable, dragSourceListener);
    }

    public void startDrag(Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this._dragSource.startDrag(this, cursor, image, point, transferable, dragSourceListener);
    }
}

