/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Locale;
import oracle.ewt.color.BaseColorEditor;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.util.ImmInsets;

class ColorComponent
extends BaseColorEditor {
    private static final Dimension _SIZE = new Dimension(30, 20);
    private static final String _KEY_LABEL = "COLORCHOOSER.SELECTED_COLOR";
    private static final String _KEY_LABEL2 = "COLORCHOOSER.ORIGINAL_COLOR";
    private LWLabel _selectedLabel = new LWLabel("");
    private ColorPanel _selectedColorPanel = new ColorPanel(false);
    private LWLabel _originalColorLabel;
    private ColorPanel _originalColorPanel;
    private Color _originalColor;

    public ColorComponent() {
        this._selectedColorPanel.setBackground(Color.black);
        this._originalColorLabel = new LWLabel("");
        this._originalColorPanel = new ColorPanel(true);
        this.setOriginalColor(null);
        this.setLayout(new BorderLayout(7, 0));
        LWContainer lWContainer = new LWContainer(new BorderLayout(0, 0));
        lWContainer.add("North", this._originalColorLabel);
        lWContainer.add("South", this._selectedLabel);
        LWContainer lWContainer2 = new LWContainer(new BorderLayout());
        lWContainer2.add("North", this._originalColorPanel);
        lWContainer2.add("South", this._selectedColorPanel);
        this.add("West", lWContainer);
        this.add("Center", lWContainer2);
    }

    public void setOriginalColor(Color color) {
        this._originalColor = color;
        this._originalColorPanel.setBackground(this._originalColor);
        boolean bl = this._originalColor != null;
        this._originalColorPanel.setVisible(bl);
        this._originalColorLabel.setVisible(bl);
    }

    public Color getOriginalColor() {
        return this._originalColor;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._selectedLabel.setEnabled(bl);
        this._selectedColorPanel.setEnabled(bl);
        this._originalColorLabel.setEnabled(bl);
        this._originalColorPanel.setEnabled(bl);
    }

    protected void colorChanged(Color color) {
        this._selectedColorPanel.setBackground(color);
    }

    protected void updateLabels(Locale locale) {
        String string = ColorComponent.__getTranslatedString(locale, _KEY_LABEL);
        this._selectedLabel.setText(string);
        string = ColorComponent.__getTranslatedString(locale, _KEY_LABEL2);
        this._originalColorLabel.setText(string);
    }

    private class ColorPanel
    extends LWComponent {
        private boolean _changeOnClick;

        public ColorPanel(boolean bl) {
            if (bl) {
                this.enableEvents(16L);
            }
            this._changeOnClick = true;
        }

        protected void paintComponent(Graphics graphics) {
            ImmInsets immInsets = this.getBorderInsets();
            graphics.setColor(this.getBackground());
            graphics.fillRect(immInsets.left, immInsets.top, this.getInnerWidth() - (immInsets.left + immInsets.right), this.getInnerHeight() - (immInsets.top + immInsets.bottom));
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.isConsumed() || !this.isEnabled() || !this._changeOnClick || mouseEvent.getID() != 501) {
                return;
            }
            ColorComponent.this.storeColor(this.getBackground());
            ColorComponent.this.colorChanged(this.getBackground());
        }

        public Dimension getMinimumSize() {
            return _SIZE;
        }

        public Dimension getPreferredSize() {
            return _SIZE;
        }
    }
}

