/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.alert;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.alert.BaseAlertPane;
import oracle.ewt.button.PushButton;
import oracle.ewt.event.HelpEvent;
import oracle.ewt.event.HelpListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;

public class AlertPane
extends BaseAlertPane
implements ActionListener {
    public static final int BUTTON_YES = 1;
    public static final int BUTTON_NO = 2;
    public static final int BUTTON_CANCEL = 4;
    public static final int BUTTON_HELP = 8;
    public static final int BUTTON_USER = 0;
    private PushButton _yes;
    private PushButton _no;
    private PushButton _cancel;
    private PushButton _help;
    private int _labelsSet;
    private ListenerManager _helpListeners;
    private ListenerManager _actionListeners;
    private static final int _ALL_BUTTONS_MASK = 15;
    private static final String _YES_KEY = "YES";
    private static final String _OK_KEY = "OK";
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _NO_KEY = "NO";
    private static final String _HELP_KEY = "HELP";

    public AlertPane(String string, int n) {
        super(string, n);
    }

    public AlertPane(String string, int n, int n2) {
        this(string, n);
        this.createButtons(n2);
    }

    public void createButtons(int n) {
        if ((n & 0xF) == 0 || (n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("Illegal button bitmask");
        }
        if ((n & 1) != 0) {
            this._yes = this.createButton(1, n);
            this._yes.addActionListener(this);
            this.addUserButton("Yes", this._yes);
            this.setDefaultComponent(this._yes);
            this._yes.setDefault(true);
            if ((n & 6) == 0) {
                this.setCancelComponent(this._yes);
            }
        }
        if ((n & 2) != 0) {
            this._no = this.createButton(2, n);
            this._no.addActionListener(this);
            this.addUserButton("No", this._no);
            if ((n & 4) == 0) {
                this.setCancelComponent(this._no);
            }
        }
        if ((n & 4) != 0) {
            this._cancel = this.createButton(4, n);
            this._cancel.addActionListener(this);
            this.addUserButton("Cancel", this._cancel);
            if ((n & 1) == 0) {
                this.setDefaultComponent(this._cancel);
                this._cancel.setDefault(true);
            }
            this.setCancelComponent(this._cancel);
        }
        if ((n & 8) != 0) {
            this._help = this.createButton(8, n);
            this._help.addActionListener(this);
            this.addUserButton("Help", this._help);
            this.setHelpComponent(this._help);
        }
    }

    public String getButtonLabel(int n) {
        return this._whichComponent(n).getLabel();
    }

    public void setButtonMnemonicIndex(int n, int n2) {
        this._whichComponent(n).setMnemonicIndex(n2);
    }

    public int getButtonMnemonicIndex(int n) {
        return this._whichComponent(n).getMnemonicIndex();
    }

    public void setButtonMnemonicChar(int n, char c) {
        this._whichComponent(n).setMnemonicChar(c);
    }

    public char getButtonMnemonicChar(int n) {
        return this._whichComponent(n).getMnemonicChar();
    }

    public void setButtonLabel(int n, String string) {
        this._labelsSet |= n;
        this._whichComponent(n).setLabel(string);
    }

    public int getDefaultButton() {
        return this.whichButton(this.getDefaultComponent());
    }

    public void setDefaultButton(int n) {
        this.setDefaultComponent(this._whichComponent(n));
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this._actionListeners.removeListener(actionListener);
    }

    public synchronized void addHelpListener(HelpListener helpListener) {
        if (this._helpListeners == null) {
            this._helpListeners = new ListenerManager();
        }
        this._helpListeners.addListener(helpListener);
    }

    public synchronized void removeHelpListener(HelpListener helpListener) {
        this._helpListeners.removeListener(helpListener);
    }

    public int whichButton(Component component) {
        if (component == this._yes) {
            return 1;
        }
        if (component == this._no) {
            return 2;
        }
        if (component == this._cancel) {
            return 4;
        }
        if (component == this._help) {
            return 8;
        }
        return 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._help) {
            this.processEvent(new HelpEvent(this, 2000));
        } else {
            this.processEvent(actionEvent);
        }
    }

    protected void doComponentKey(Component component) {
        if (component instanceof PushButton) {
            ((PushButton)component).simulatePush();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof HelpEvent) {
            this.processHelpEvent((HelpEvent)aWTEvent);
        } else if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this._actionListeners == null) {
            return;
        }
        Enumeration enumeration = this._actionListeners.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
            }
        }
    }

    protected void processHelpEvent(HelpEvent helpEvent) {
        if (this._helpListeners != null) {
            Enumeration enumeration = this._helpListeners.getListeners();
            if (enumeration == null) {
                return;
            }
            switch (helpEvent.getID()) {
                case 2000: {
                    while (enumeration.hasMoreElements()) {
                        ((HelpListener)enumeration.nextElement()).helpRequested(helpEvent);
                    }
                    break;
                }
            }
        } else {
            this.showHelp();
        }
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        String string;
        super.updateLocale(locale, locale2);
        ResourceBundle resourceBundle = null;
        int n = this._labelsSet;
        if (this._yes != null && (n & 1) == 0) {
            resourceBundle = this._getBundle(resourceBundle, locale);
            String string2 = this._no != null ? _YES_KEY : _OK_KEY;
            string = resourceBundle.getString(string2);
            this._yes.setLabel(StringUtils.stripMnemonic(string));
            this._yes.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        }
        if (this._no != null && (n & 2) == 0) {
            resourceBundle = this._getBundle(resourceBundle, locale);
            string = resourceBundle.getString(_NO_KEY);
            this._no.setLabel(StringUtils.stripMnemonic(string));
            this._no.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        }
        if (this._cancel != null && (n & 4) == 0) {
            resourceBundle = this._getBundle(resourceBundle, locale);
            string = resourceBundle.getString(_CANCEL_KEY);
            this._cancel.setLabel(StringUtils.stripMnemonic(string));
            this._cancel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        }
        if (this._help != null && (n & 8) == 0) {
            resourceBundle = this._getBundle(resourceBundle, locale);
            string = resourceBundle.getString(_HELP_KEY);
            this._help.setLabel(StringUtils.stripMnemonic(string));
            this._help.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        }
    }

    protected PushButton createButton(int n, int n2) {
        return new PushButton("");
    }

    private ResourceBundle _getBundle(ResourceBundle resourceBundle, Locale locale) {
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle("oracle.ewt.alert.resource.AlertBundle", LocaleUtils.getTranslationLocale(locale));
        }
        return resourceBundle;
    }

    private PushButton _whichComponent(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this._yes;
            }
            case 2: {
                return this._no;
            }
            case 4: {
                return this._cancel;
            }
            case 8: {
                return this._help;
            }
        }
        throw new IllegalArgumentException();
    }
}

