/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Dictionary;
import oracle.ewt.border.Border;
import oracle.ewt.border.BorderManager;
import oracle.ewt.dnd.Autoscroll;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.scrolling.Scrollable;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.util.ImmInsets;

public class EwtComponent
extends LWComponent
implements Scrollable,
Autoscroll {
    private static final int _CURRENT_SCROLL_INSET = -1;
    private static Class _sEventDispatchThreadClass = null;
    private BorderPainter _borderPainter;
    private ImmInsets _scrollInsets = ImmInsets.getEmptyInsets();
    private transient Rectangle _canvasRect;
    private Painter _canvasFill;
    private transient BorderAdaptor _borderAdaptor;
    private transient boolean _needsRevalidate;

    public EwtComponent() {
        if (this.isHScrollable() || this.isVScrollable()) {
            this._canvasRect = new Rectangle();
        }
        this.setBorderPainter(DEFAULT_BORDERPAINTER);
    }

    public void setBorderPainter(BorderPainter borderPainter) {
        if (borderPainter != this._borderPainter) {
            this._borderPainter = borderPainter;
            BorderAdaptor borderAdaptor = this._borderAdaptor;
            if (borderPainter != borderAdaptor) {
                if (borderAdaptor != null) {
                    borderAdaptor.setBorder(null);
                }
                this.invalidate();
                this.repaint();
            }
        }
    }

    public final void setBorder(Border border) {
        BorderAdaptor borderAdaptor = this._getBorderAdaptor();
        borderAdaptor.setBorder(border);
        this.setBorderPainter(border != null ? borderAdaptor : null);
    }

    public BorderPainter getBorderPainter() {
        if (this.getHAdjustable() == null && this.getVAdjustable() == null) {
            if (this._borderPainter == DEFAULT_BORDERPAINTER) {
                return super.getBorderPainter();
            }
            return this._borderPainter;
        }
        return null;
    }

    public final Border getBorder() {
        return this._getBorderAdaptor().getBorder();
    }

    public void setCanvasFill(Painter painter) {
        this._canvasFill = painter;
        this.repaint();
    }

    public Painter getCanvasFill() {
        return this._canvasFill;
    }

    public final void invalidateCanvas() {
        boolean bl = this.isValid();
        if (!bl && !this.isShowing()) {
            return;
        }
        this._needsRevalidate = true;
        this.repaint();
    }

    public final void repaintCanvas() {
        this.repaintInterior();
    }

    public final void repaintCanvas(int n, int n2, int n3, int n4) {
        this.repaintInterior(n + this.getCanvasOriginX(), n2 + this.getCanvasOriginY(), n3, n4);
    }

    public final void paintImmediateCanvas() {
        this.paintImmediateInterior();
    }

    public final void paintImmediateCanvas(int n, int n2, int n3, int n4) {
        this.paintImmediateInterior(n + this.getCanvasOriginX(), n2 + this.getCanvasOriginY(), n3, n4);
    }

    public final Point convertOuterToCanvas(int n, int n2) {
        Point point = this.getCanvasOrigin();
        ImmInsets immInsets = this.getBorderInsets();
        point.x = n - point.x - immInsets.left;
        point.y = n2 - point.y - immInsets.top;
        return point;
    }

    public final Point convertCanvasToOuter(int n, int n2) {
        Point point = this.getCanvasOrigin();
        ImmInsets immInsets = this.getBorderInsets();
        point.x += n + immInsets.left;
        point.y += n2 + immInsets.top;
        return point;
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        throw new ScrollableException();
    }

    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        throw new ScrollableException();
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        throw new ScrollableException();
    }

    public final Rectangle getCanvasBounds() {
        Rectangle rectangle = this.getInnerBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (this._canvasRect != null) {
            if (this.isHScrollable()) {
                rectangle.x = this._canvasRect.x;
                rectangle.width = this._canvasRect.width;
            }
            if (this.isVScrollable()) {
                rectangle.y = this._canvasRect.y;
                rectangle.height = this._canvasRect.height;
            }
        }
        return rectangle;
    }

    public final Point getCanvasOrigin() {
        return new Point(this.getCanvasOriginX(), this.getCanvasOriginY());
    }

    public final int getCanvasOriginX() {
        if (this._canvasRect != null && this.isHScrollable()) {
            return this._canvasRect.x;
        }
        return 0;
    }

    public final int getCanvasOriginY() {
        if (this._canvasRect != null && this.isVScrollable()) {
            return this._canvasRect.y;
        }
        return 0;
    }

    public final int getCanvasWidth() {
        if (this._canvasRect != null && this.isHScrollable()) {
            return this._canvasRect.width;
        }
        return this.getInnerWidth();
    }

    public final int getCanvasHeight() {
        if (this._canvasRect != null && this.isVScrollable()) {
            return this._canvasRect.height;
        }
        return this.getInnerHeight();
    }

    public final Dimension getCanvasSize() {
        Dimension dimension = this.getInnerSize();
        if (this._canvasRect != null) {
            if (this.isHScrollable()) {
                dimension.width = this._canvasRect.width;
            }
            if (this.isVScrollable()) {
                dimension.height = this._canvasRect.height;
            }
        }
        return dimension;
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        this.paintCanvasInterior(graphics);
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        return this.getCanvasSize();
    }

    public Adjustable getHAdjustable() {
        return null;
    }

    public Adjustable getVAdjustable() {
        return null;
    }

    public void handleHScroll(int n, int n2) throws ScrollableException {
        if (!this.isHScrollable()) {
            throw new ScrollableException();
        }
        this._shiftCanvasX(this.getHOffsetOfValue(n));
    }

    public void handleVScroll(int n, int n2) throws ScrollableException {
        if (!this.isVScrollable()) {
            throw new ScrollableException();
        }
        this._shiftCanvasY(this.getVOffsetOfValue(n));
    }

    public boolean isHScrollable() {
        return false;
    }

    public boolean isVScrollable() {
        return false;
    }

    public void setCanvasOrigin(int n, int n2) throws ScrollableException {
        Adjustable adjustable;
        if (n != this.getCanvasOriginX()) {
            if (!this.isHScrollable()) {
                throw new ScrollableException();
            }
            this._shiftCanvasX(n);
            adjustable = this.getHAdjustable();
            if (adjustable != null && this.getProxyConfigurer() == null) {
                adjustable.setValue(this.getHValueOfOffset(n));
            }
        }
        if (n2 != this.getCanvasOriginY()) {
            if (!this.isVScrollable()) {
                throw new ScrollableException();
            }
            this._shiftCanvasY(n2);
            adjustable = this.getVAdjustable();
            if (adjustable != null && this.getProxyConfigurer() == null) {
                adjustable.setValue(this.getVValueOfOffset(n2));
            }
        }
    }

    public void setHScrollInsets(int n, int n2) {
        this._setScrollInsets(-1, n, -1, n2);
    }

    public void setVScrollInsets(int n, int n2) {
        this._setScrollInsets(n, -1, n2, -1);
    }

    public ImmInsets getScrollInsets() {
        return this._scrollInsets;
    }

    public final void clipCanvasToParents(Rectangle rectangle) {
        int n;
        ImmInsets immInsets = this.getBorderInsets();
        int n2 = this.getCanvasOriginX();
        int n3 = this.getCanvasOriginY();
        rectangle.x += n2 + immInsets.left;
        rectangle.y += n3 + immInsets.top;
        this.clipToParents(rectangle);
        if (rectangle.x < immInsets.left) {
            rectangle.width -= immInsets.left - rectangle.x;
            rectangle.x = immInsets.left;
        }
        if (rectangle.y < immInsets.top) {
            rectangle.height -= immInsets.top - rectangle.y;
            rectangle.y = immInsets.top;
        }
        Dimension dimension = this.getInnerSize();
        int n4 = dimension.width - (rectangle.x - immInsets.left);
        if (rectangle.width > n4) {
            rectangle.width = n4;
        }
        if (rectangle.height > (n = dimension.height - (rectangle.y - immInsets.top))) {
            rectangle.height = n;
        }
        rectangle.x -= n2 + immInsets.left;
        rectangle.y -= n3 + immInsets.top;
    }

    public void validate() {
        if (this._needsRevalidate) {
            this.invalidate();
        }
        super.validate();
    }

    public final synchronized void layout() {
        this._needsRevalidate = false;
        super.layout();
        Dimension dimension = this.layoutCanvas();
        this.setCanvasSize(dimension.width, dimension.height);
    }

    public boolean isInteriorTransparent() {
        if (!super.isInteriorTransparent()) {
            return false;
        }
        Painter painter = this.getCanvasFill();
        if (painter != null) {
            return painter.isTransparent(this.getPaintContext());
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this._needsRevalidate && EwtComponent._isEventDispatchThread()) {
            this._needsRevalidate = false;
            this.invalidate();
            this.validate();
        }
        super.paint(graphics);
    }

    public void paintInterior(Graphics graphics) {
        Painter painter;
        int n = this.getCanvasOriginX();
        int n2 = this.getCanvasOriginY();
        if (n != 0 || n2 != 0) {
            graphics.translate(n, n2);
        }
        if ((painter = this.getCanvasFill()) != null) {
            Dimension dimension = this.getInnerSize();
            Dimension dimension2 = this.getCanvasSize();
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
            painter.paint(this.getPaintContext(), graphics, 0, 0, dimension.width, dimension.height);
        }
        this.paintCanvasInterior(graphics);
        if (n != 0 || n2 != 0) {
            graphics.translate(-n, -n2);
        }
    }

    public Insets getAutoscrollInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.isHScrollable()) {
            insets.left = 8;
            insets.right = 8;
        }
        if (this.isVScrollable()) {
            insets.top = 8;
            insets.bottom = 8;
        }
        return insets;
    }

    public void autoscroll(Point point) {
        int n;
        Adjustable adjustable;
        Insets insets = this.getAutoscrollInsets();
        Dimension dimension = this.getSize();
        int n2 = point.x < insets.left ? -1 : (point.x >= dimension.width - insets.right ? 1 : 0);
        if (n2 != 0 && (adjustable = this.getHAdjustable()) != null) {
            adjustable.setValue(adjustable.getValue() + n2 * adjustable.getUnitIncrement());
            this.handleHScroll(adjustable.getValue(), n2 < 0 ? 0 : 1);
        }
        if ((n = point.y < insets.top ? -1 : (point.y >= dimension.height - insets.bottom ? 1 : 0)) != 0 && (adjustable = this.getVAdjustable()) != null) {
            adjustable.setValue(adjustable.getValue() + n * adjustable.getUnitIncrement());
            this.handleVScroll(adjustable.getValue(), n < 0 ? 0 : 1);
        }
    }

    protected EwtComponent getProxyConfigurer() {
        return null;
    }

    protected void paintCanvasInterior(Graphics graphics) {
    }

    protected int getHMaximum() {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getHMaximum();
        }
        return this.getCanvasSize().width;
    }

    protected int getHValueOfOffset(int n) {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getHValueOfOffset(n);
        }
        return -n;
    }

    protected int getHOffsetOfValue(int n) {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getHOffsetOfValue(n);
        }
        return -n;
    }

    protected int getVMaximum() {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getVMaximum();
        }
        return this.getCanvasSize().height;
    }

    protected int getVOffsetOfValue(int n) {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getVOffsetOfValue(n);
        }
        return -n;
    }

    protected int getVValueOfOffset(int n) {
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent.getVValueOfOffset(n);
        }
        return -n;
    }

    protected Dimension layoutCanvas() {
        return new Dimension(0, 0);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.isHScrollable() && this._canvasRect.width != n3 || this.isVScrollable() && this._canvasRect.height != n4) {
            ImmInsets immInsets = this.getBorderInsets();
            int n5 = n3 - immInsets.left - immInsets.right;
            int n6 = n4 - immInsets.top - immInsets.bottom;
            this._adjustCanvasOrigin(this.getCanvasWidth(), this.getCanvasHeight(), n5, n6);
        }
        super.reshape(n, n2, n3, n4);
    }

    protected void setCanvasSize(int n, int n2) {
        Object object;
        boolean bl = false;
        if (this.isHScrollable() && this._canvasRect.width != n || this.isVScrollable() && this._canvasRect.height != n2) {
            object = this.getBorderInsets();
            int n3 = this.getSize().width - ((ImmInsets)object).left - ((ImmInsets)object).right;
            int n4 = this.getSize().height - ((ImmInsets)object).top - ((ImmInsets)object).bottom;
            this._adjustCanvasOrigin(n, n2, n3, n4);
        }
        if (this.isHScrollable()) {
            if (this._canvasRect.width != n) {
                this._canvasRect.width = n;
                bl = true;
            }
            this._configureHAdjustable();
        }
        if (this.isVScrollable()) {
            if (this._canvasRect.height != n2) {
                this._canvasRect.height = n2;
                bl = true;
            }
            this._configureVAdjustable();
        }
        if (bl && (object = this.getCanvasFill()) != null && (object.getRepaintFlags(this.getPaintContext()) & 0x80) != 0) {
            this.repaintCanvas();
        }
    }

    protected final void makeCanvasGraphics(Graphics graphics) {
        if (graphics != null) {
            Rectangle rectangle = this.getInnerBounds();
            this.clipToParents(rectangle);
            int n = this.getCanvasOriginX();
            int n2 = this.getCanvasOriginY();
            graphics.translate(rectangle.x + n, rectangle.y + n2);
            graphics.clipRect(-n, -n2, rectangle.width, rectangle.height);
        }
    }

    public final Graphics getCanvasGraphics() {
        Graphics graphics = this.getGraphics();
        this.makeCanvasGraphics(graphics);
        return graphics;
    }

    protected final void storeCanvasOrigin(int n, int n2) {
        this._canvasRect.x = n;
        this._canvasRect.y = n2;
    }

    private boolean _isContainedBy(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.x >= rectangle2.x && rectangle.y >= rectangle2.y && rectangle.x + rectangle.width <= rectangle2.x + rectangle2.width && rectangle.y + rectangle.height <= rectangle2.y + rectangle2.height;
    }

    private boolean _isDamaged() {
        return false;
    }

    private void _adjustCanvasOrigin(int n, int n2, int n3, int n4) {
        int n5 = this.getCanvasOriginX();
        int n6 = this.getCanvasOriginY();
        int n7 = 0;
        int n8 = 0;
        if (this.isHScrollable() && n5 + n < n3) {
            n7 = Math.min(n3 - (n5 + n), -n5);
        }
        if (this.isVScrollable() && n6 + n2 < n4) {
            n8 = Math.min(n4 - (n6 + n2), -n6);
        }
        if (n7 != 0 || n8 != 0) {
            this.setCanvasOrigin(n5 + n7, n6 + n8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _shiftCanvasX(int n) {
        int n2 = this.getCanvasOriginX();
        if (n == n2) {
            return;
        }
        boolean bl = false;
        try {
            Rectangle rectangle = this._canvasRect;
            synchronized (rectangle) {
                Rectangle rectangle2 = this.getInnerBounds();
                this.clipToParents(rectangle2);
                int n3 = n - n2;
                if (this.isClippedBySibling() || this.isTransparent() || this._isDamaged() || Math.abs(n3) >= rectangle2.width) {
                    this._canvasRect.x = n;
                    if (this._isDamaged()) {
                        this.repaintCanvas();
                    } else {
                        this.paintImmediateCanvas();
                    }
                } else {
                    this.freezeRepaints();
                    bl = true;
                    this.getToolkit().sync();
                    Graphics graphics = this.getGraphics();
                    if (graphics == null) {
                        this._canvasRect.x = n;
                        this.repaintCanvas();
                    } else {
                        int n4 = this._scrollInsets.left;
                        int n5 = this._scrollInsets.right;
                        int n6 = rectangle2.x + n4;
                        int n7 = rectangle2.y;
                        int n8 = rectangle2.width - (n4 + n5);
                        int n9 = rectangle2.height;
                        graphics.clipRect(n6, n7, n8, n9);
                        graphics.copyArea(n6, n7, n8, n9, n3, 0);
                        graphics.dispose();
                        Rectangle rectangle3 = new Rectangle();
                        rectangle3.y = rectangle2.y;
                        rectangle3.height = rectangle2.height;
                        if (n3 < 0) {
                            rectangle3.x = rectangle2.x + rectangle2.width + n3 - n5;
                            rectangle3.width = -n3 + n5 + n4;
                        } else {
                            rectangle3.x = rectangle2.x + n4;
                            rectangle3.width = n3 + n4 + n5;
                        }
                        this._canvasRect.x = n;
                        this.shiftFrozenDamage(0, n3);
                        this.paintImmediate(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    }
                }
            }
        }
        finally {
            if (bl) {
                this.unfreezeRepaints();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _shiftCanvasY(int n) {
        int n2 = this.getCanvasOriginY();
        if (n == n2) {
            return;
        }
        boolean bl = false;
        try {
            Rectangle rectangle = this._canvasRect;
            synchronized (rectangle) {
                Rectangle rectangle2 = this.getInnerBounds();
                this.clipToParents(rectangle2);
                int n3 = n - n2;
                if (this.isClippedBySibling() || this.isTransparent() || this._isDamaged() || Math.abs(n3) >= rectangle2.height) {
                    this._canvasRect.y = n;
                    this.repaintCanvas();
                } else {
                    this.freezeRepaints();
                    bl = true;
                    this.getToolkit().sync();
                    Graphics graphics = this.getGraphics();
                    if (graphics == null) {
                        this._canvasRect.y = n;
                        this.repaintCanvas();
                    } else {
                        int n4 = this._scrollInsets.top;
                        int n5 = this._scrollInsets.bottom;
                        int n6 = rectangle2.x;
                        int n7 = rectangle2.y + n4;
                        int n8 = rectangle2.width;
                        int n9 = rectangle2.height - (n4 + n5);
                        graphics.clipRect(n6, n7, n8, n9);
                        graphics.copyArea(n6, n7, n8, n9, 0, n3);
                        graphics.dispose();
                        Rectangle rectangle3 = new Rectangle();
                        rectangle3.x = rectangle2.x;
                        rectangle3.width = rectangle2.width;
                        if (n3 < 0) {
                            rectangle3.y = rectangle2.y + rectangle2.height + n3 - n5;
                            rectangle3.height = -n3 + n5 + n4;
                        } else {
                            rectangle3.y = rectangle2.y + n4;
                            rectangle3.height = n3 + n4 + n5;
                        }
                        this._canvasRect.y = n;
                        this.shiftFrozenDamage(0, n3);
                        this.paintImmediate(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    }
                }
            }
        }
        finally {
            if (bl) {
                this.unfreezeRepaints();
            }
        }
    }

    private void _configureAdjustable(Adjustable adjustable, int n, int n2, int n3) {
        int n4 = adjustable.getValue();
        adjustable.setMinimum(0);
        adjustable.setMaximum(n2);
        adjustable.setVisibleAmount(n3);
        if (n4 != n) {
            adjustable.setValue(n);
        }
        adjustable.setBlockIncrement(n3 > 1 ? n3 - 1 : 1);
    }

    private void _configureHAdjustable() {
        int n;
        Dimension dimension;
        int n2;
        EwtComponent ewtComponent = this.getProxyConfigurer();
        Adjustable adjustable = this.getHAdjustable();
        if (adjustable == null) {
            return;
        }
        int n3 = this.getHMaximum();
        if (n3 < (n2 = this._getColumnsPerPage(n3))) {
            n3 = n2;
        }
        Rectangle rectangle = ewtComponent != null ? ewtComponent.getCanvasBounds() : this.getCanvasBounds();
        Dimension dimension2 = dimension = ewtComponent != null ? ewtComponent.getInnerSize() : this.getInnerSize();
        if (rectangle.x < 0 && rectangle.x + rectangle.width < dimension.width) {
            int n4 = dimension.width - rectangle.width;
            if (n4 > 0) {
                n4 = 0;
            }
            this._shiftCanvasX(n4);
            n = this.getActualReadingDirection() == 2 ? n3 - n2 : this.getHValueOfOffset(n4);
        } else {
            n = this.getActualReadingDirection() == 2 ? adjustable.getValue() + (n3 - adjustable.getMaximum()) + (adjustable.getVisibleAmount() - n2) : adjustable.getValue();
        }
        this._configureAdjustable(adjustable, n, n3, n2);
    }

    private void _configureVAdjustable() {
        int n;
        Dimension dimension;
        int n2;
        EwtComponent ewtComponent = this.getProxyConfigurer();
        Adjustable adjustable = this.getVAdjustable();
        if (adjustable == null) {
            return;
        }
        int n3 = this.getVMaximum();
        if (n3 < (n2 = this._getRowsPerPage(n3))) {
            n3 = n2;
        }
        Rectangle rectangle = ewtComponent != null ? ewtComponent.getCanvasBounds() : this.getCanvasBounds();
        Dimension dimension2 = dimension = ewtComponent != null ? ewtComponent.getInnerSize() : this.getInnerSize();
        if (rectangle.y < 0 && rectangle.y + rectangle.height < dimension.height) {
            int n4 = dimension.height - rectangle.height;
            if (n4 > 0) {
                n4 = 0;
            }
            this._shiftCanvasY(n4);
            n = this.getVValueOfOffset(n4);
        } else {
            n = adjustable.getValue();
        }
        this._configureAdjustable(adjustable, n, n3, n2);
    }

    private int _getColumnsPerPage(int n) {
        int n2;
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent._getColumnsPerPage(n);
        }
        int n3 = this.getCanvasSize().width;
        int n4 = this.getInnerSize().width;
        if (n3 <= n4) {
            return n;
        }
        if (n4 <= 0) {
            return 1;
        }
        int n5 = n4 - n3;
        int n6 = this.getHValueOfOffset(n5);
        int n7 = n - n6;
        if (n6 >= 0 && n6 < n && (n2 = this.getHOffsetOfValue(n6)) > n5) {
            --n7;
        }
        if (n7 == 0) {
            n7 = 1;
        }
        return n7;
    }

    private int _getRowsPerPage(int n) {
        int n2;
        EwtComponent ewtComponent = this.getProxyConfigurer();
        if (ewtComponent != null) {
            return ewtComponent._getRowsPerPage(n);
        }
        int n3 = this.getCanvasSize().height;
        int n4 = this.getInnerSize().height;
        if (n3 <= n4) {
            return n;
        }
        if (n4 <= 0) {
            return 1;
        }
        int n5 = n4 - n3;
        int n6 = this.getVValueOfOffset(n5);
        int n7 = n - n6;
        if (n6 >= 0 && n6 < n && (n2 = this.getVOffsetOfValue(n6)) > n5) {
            --n7;
        }
        if (n7 == 0) {
            n7 = 1;
        }
        return n7;
    }

    private BorderAdaptor _getBorderAdaptor() {
        if (this._borderAdaptor == null) {
            this._borderAdaptor = new BorderAdaptor();
        }
        return this._borderAdaptor;
    }

    private void _setScrollInsets(int n, int n2, int n3, int n4) {
        if (n == -1) {
            n = this._scrollInsets.top;
        }
        if (n2 == -1) {
            n2 = this._scrollInsets.left;
        }
        if (n3 == -1) {
            n3 = this._scrollInsets.bottom;
        }
        if (n4 == -1) {
            n4 = this._scrollInsets.right;
        }
        this._scrollInsets = new ImmInsets(n, n2, n3, n4);
    }

    private static boolean _isEventDispatchThread() {
        Thread thread = Thread.currentThread();
        if (_sEventDispatchThreadClass == null) {
            Class<?> clazz = thread.getClass();
            if (clazz.getName().indexOf("EventDispatchThread") >= 0 || clazz.getName().indexOf("JMEventQueue") >= 0) {
                _sEventDispatchThreadClass = clazz;
                return true;
            }
            return false;
        }
        return _sEventDispatchThreadClass.isInstance(thread);
    }

    private class BorderAdaptor
    extends AbstractBorderPainter
    implements BorderManager {
        private transient Border _border;

        public void setBorder(Border border) {
            if (this._border != border) {
                if (this._border != null) {
                    this._border.unmanageNotify();
                }
                this._border = border;
                if (border != null) {
                    border.manageNotify(this);
                }
                EwtComponent.this.invalidate();
                EwtComponent.this.repaint();
            }
        }

        public Border getBorder() {
            return this._border;
        }

        public void borderRepaintNotify() {
            EwtComponent.this.repaint();
        }

        public void borderResizeNotify() {
            EwtComponent.this.invalidate();
            EwtComponent.this.repaint();
        }

        public Font getFont() {
            return EwtComponent.this.getPaintContext().getPaintFont();
        }

        public Color getBorderBackground() {
            return EwtComponent.this.getPaintContext().getPaintBackground();
        }

        public Color getBorderForeground() {
            return EwtComponent.this.getPaintContext().getPaintForeground();
        }

        public FontMetrics getFontMetrics(Font font) {
            return EwtComponent.this.getPaintContext().getFontMetrics(font);
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            return new ImmInsets(this.getBorder().getInsets());
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            this.getBorder().paint(graphics, n, n2, n3, n4, this);
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return false;
        }
    }
}

