/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.extension.Required;
import oracle.jdeveloper.audit.transform.TextTransformContext;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.xml.XmlTextTransformAdapter;
import oracle.jdevimpl.audit.xml.XmlAuditHelper;
import org.w3c.dom.Node;

public class RemoveAttributeTransform
extends Transform {
    private QualifiedName name;
    private String except;

    public RemoveAttributeTransform() {
        super((TransformAdapter)new XmlTextTransformAdapter());
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Required
    public void setName(QualifiedName name) {
        this.name = name;
    }

    public String getExcept() {
        return this.except;
    }

    public void setExcept(String except) {
        this.except = except;
    }

    public boolean isApplicable(TextTransformContext context, Node construct) {
        if (this.name == null) {
            return false;
        }
        DocumentScannerFactory scannerFactory = ((XMLSourceNode)context.getNode()).getDocumentScannerFactory(context.getIdeContext(), null);
        Map<QualifiedName, MultiMap<String, AttributeLocator>> names = XmlAuditHelper.getAttributeDeclarations(scannerFactory, context.getBuffer(), context.getLocation().getOffset(), false);
        return !names.isEmpty();
    }

    public void apply(TextTransformContext context, Node construct) {
        XMLSourceNode cfr_ignored_0 = (XMLSourceNode)context.getNode();
        GrammarResolver resolver = XMLSourceNode.getXmlContext(context.getIdeContext()).getGrammarResolver();
        boolean isCaseSensitive = GrammarUtils.areNamesCaseSensitive((GrammarResolver)resolver, (String)this.name.getNamespace());
        DocumentScannerFactory scannerFactory = ((XMLSourceNode)context.getNode()).getDocumentScannerFactory(context.getIdeContext(), null);
        Map<QualifiedName, MultiMap<String, AttributeLocator>> names = XmlAuditHelper.getAttributeDeclarations(scannerFactory, context.getBuffer(), context.getLocation().getOffset(), isCaseSensitive);
        QualifiedName attributeName = isCaseSensitive ? this.name : QualifiedName.getQualifiedName((String)this.name.getNamespace(), (String)this.name.getName().toLowerCase());
        MultiMap<String, AttributeLocator> values = names.get(attributeName);
        AttributeLocator exception = null;
        boolean valueMissing = false;
        if (this.except != null) {
            Collection locators = values.get((Object)this.except);
            if (locators == null && "".equals(this.except)) {
                locators = values.get(null);
                boolean bl = valueMissing = locators != null;
            }
            if (locators != null) {
                exception = (AttributeLocator)locators.iterator().next();
            }
        }
        ArrayList duplicates = new ArrayList(values.valuesSize());
        for (Collection locators : values.values()) {
            duplicates.addAll(locators);
        }
        Collections.sort(duplicates, new ReverseLocatorComparator());
        TextBuffer buffer = context.getBuffer();
        for (AttributeLocator locator : duplicates) {
            TextLocator value;
            if (locator != exception) {
                int offset = locator.getStartOffset();
                int i = offset - 1;
                while (i >= 0 && WhitespaceUtils.isXmlWhitespaceChar((char)buffer.getChar(i))) {
                    offset = i--;
                }
                UndoableEdit edit = buffer.remove(offset, locator.getEndOffset() - offset);
                context.addEdit(edit);
                continue;
            }
            if (!valueMissing) continue;
            SimpleLocator name = locator.getNameLocator();
            SimpleLocator equals = locator.getEqualsLocator();
            int insertionOffset = name.getEndOffset();
            String insertionPrefix = "";
            if (equals != null) {
                insertionOffset = equals.getEndOffset();
                if (WhitespaceUtils.isXmlWhitespaceChar((char)buffer.getChar(equals.getStartOffset() - 1))) {
                    insertionPrefix = " ";
                }
            } else {
                insertionPrefix = "=";
            }
            if ((value = locator.getValueLocator()) != null) {
                int offset = value.getStartOffset();
                int i = offset - 1;
                while (i >= 0 && WhitespaceUtils.isXmlWhitespaceChar((char)buffer.getChar(i))) {
                    offset = i--;
                }
                UndoableEdit edit = buffer.remove(offset, value.getEndOffset() - offset);
                context.addEdit(edit);
            }
            int prefixSize = insertionPrefix.length();
            int valueSize = this.except.length();
            char[] insertionText = new char[prefixSize + valueSize + 2];
            insertionPrefix.getChars(0, prefixSize, insertionText, 0);
            insertionText[prefixSize] = 34;
            this.except.getChars(0, valueSize, insertionText, prefixSize + 1);
            insertionText[prefixSize + 1 + valueSize] = 34;
            UndoableEdit edit = buffer.insert(insertionOffset, insertionText);
            context.addEdit(edit);
            context.setSelection(insertionOffset + insertionText.length - 1);
        }
    }

    private static class ReverseLocatorComparator
    implements Comparator<AttributeLocator> {
        private ReverseLocatorComparator() {
        }

        @Override
        public int compare(AttributeLocator o1, AttributeLocator o2) {
            return o2.getStartOffset() - o1.getStartOffset();
        }
    }
}

