/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent.propertyEditors;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import oracle.bali.xml.gui.base.inspector.editors.URIEditor;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserAdapter;
import oracle.ide.net.URLChooserEvent;
import oracle.ide.net.URLChooserListener;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;

public class XmlURLPropertyEditor
extends URIEditor
implements ContextualPropertyEditor {
    private URLFilter _URLFilter;
    private boolean _absoluteURL = false;
    private URL _baseURL = null;
    private URLListener _urlListener = new URLListener();
    private URLChooser _urlChooser;
    private JDevXmlContext _xmlContext;

    public Component getCustomEditor() {
        URL selectedURL = this.getValueAsURL();
        if (this._xmlContext != null) {
            if (selectedURL == null || !"file".equals(selectedURL.getProtocol())) {
                selectedURL = this.getBaseURL() != null ? this.getBaseURL() : this.getProject().getURL();
            }
            this._urlChooser = this.createURLChooser(selectedURL);
            this._urlChooser.addURLChooserListener((URLChooserListener)this._urlListener);
            return this._urlChooser;
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        return this._xmlContext != null;
    }

    public URL getValueAsURL() {
        Object value = super.getValue();
        if (this._xmlContext != null && value != null) {
            URI uri = (URI)value;
            if (uri.isAbsolute()) {
                return URLFactory.newURL((String)uri.toString());
            }
            if (this.getBaseURL() == null) {
                return this._xmlContext.getURLForRelativePath(value.toString());
            }
            URL URLForRelativePath = this.getURLForRelativePath(value.toString(), this.getBaseURL());
            return URLForRelativePath;
        }
        return null;
    }

    public void setContext(PropertyEditorContext context) {
        if (context.getXmlContext() instanceof JDevXmlContext) {
            this._xmlContext = (JDevXmlContext)context.getXmlContext();
        } else {
            this.clearContext();
        }
    }

    public void clearContext() {
        this._xmlContext = null;
    }

    public URLChooser getURLChooser() {
        return this._urlChooser;
    }

    protected JDevXmlContext getContext() {
        return this._xmlContext;
    }

    protected Project getProject() {
        return this._xmlContext.getProject();
    }

    protected URLChooser createURLChooser(URL selectedURL) {
        URLChooser urlChooser = DialogUtil.newURLChooser((URL)selectedURL);
        urlChooser.setSelectionMode(0);
        if (this._URLFilter != null) {
            urlChooser.setURLFilter(this._URLFilter);
        }
        return urlChooser;
    }

    public void setAsURL(URL url) {
        if (this.getContext() != null) {
            if ("file".equals(url.getProtocol()) && !this._absoluteURL) {
                if (this.getBaseURL() == null) {
                    this.setAsText(this.getContext().getRelativePathForURL(url));
                } else {
                    String relativePathForURL = this.getRelativePathForURL(url, this.getBaseURL());
                    this.setAsText(relativePathForURL);
                }
            } else {
                this.setAsText(url.toString());
            }
        }
    }

    public URL getBaseURL() {
        return this._baseURL;
    }

    public XmlURLPropertyEditor setBaseURL(URL baseURL) {
        this._baseURL = baseURL;
        return this;
    }

    public String getRelativePathForURL(URL absoluteURL, URL baseURL) {
        return URLFileSystem.toRelativeSpec((URL)absoluteURL, (URL)baseURL);
    }

    public URL getURLForRelativePath(String relativePath, URL baseURL) {
        URL resolvedURL = null;
        if (relativePath != null) {
            URL context = baseURL;
            try {
                resolvedURL = new URL(context, relativePath);
                resolvedURL = URLFactory.copyURL((URL)resolvedURL);
            }
            catch (MalformedURLException e) {
                resolvedURL = null;
            }
        }
        return resolvedURL;
    }

    public XmlURLPropertyEditor setURLFilter(URLFilter URLFilter2) {
        this._URLFilter = URLFilter2;
        return this;
    }

    public XmlURLPropertyEditor setAbsoluteURL(boolean absoluteURL) {
        this._absoluteURL = absoluteURL;
        return this;
    }

    private class URLListener
    extends URLChooserAdapter {
        private URLListener() {
        }

        public void listSelectionChanged(URLChooserEvent event) {
            try {
                XmlURLPropertyEditor.this.setAsURL(XmlURLPropertyEditor.this._urlChooser.getSelectedURL());
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
        }
    }
}

