/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.awt.Component;
import java.util.logging.Level;
import oracle.bali.xml.addin.palette.XMLPaletteItemHandler;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreationContext;
import oracle.bali.xml.model.creatable.XmlCreationResult;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.javatools.dialogs.MessageDialog;
import org.w3c.dom.Node;

public class VisualEditorItemHandler
implements XMLPaletteItemHandler {
    private static final XMLPaletteItemHandler _sInstance = new VisualEditorItemHandler();

    public static XMLPaletteItemHandler getInstance() {
        return _sInstance;
    }

    @Override
    public boolean insertItem(Context ideContext, XmlCreatable creatable, Editor editor) {
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(ideContext);
        XmlModel xmlModel = xmlContext.getModel();
        if (xmlContext != null) {
            XmlView activeView = xmlContext.getActiveView();
            if (activeView == null) {
                this._showMessage("NoActiveView", "CannotInsertActiveView", (AbstractModel)xmlModel, creatable, null);
                return false;
            }
            DomPosition insertionPosition = this.getInsertionPosition(ideContext, editor, (XmlContext)xmlContext, xmlModel, activeView, creatable);
            return this.doInsertion(activeView, creatable, insertionPosition);
        }
        return false;
    }

    public boolean doInsertion(XmlView activeView, final XmlCreatable creatable, final DomPosition insertionPosition) {
        if (insertionPosition == null) {
            this._showMessage("NoInsertionPosition", "CannotInsertNoPos", (AbstractModel)activeView, creatable, null);
            return false;
        }
        final XmlCreationContext creationContext = XmlCreationContext.create((AbstractModel)activeView, (String)"xmlef-palette", (DomPosition)insertionPosition);
        final Node[] ret = new Node[1];
        final boolean[] positionInvalid = new boolean[]{false};
        try {
            new StandardTransactionTask(){

                protected String computeTransactionName(AbstractModel model) {
                    return model.getTranslatedString("INSERT_NODE_DESCRIPTION_FORMAT", creatable.getShortDisplayName(creationContext));
                }

                protected void performTask(AbstractModel model) throws XmlCommitException {
                    XmlMetadataResolver resolver = model.getXmlMetadataResolver();
                    if (resolver.canAddChild(insertionPosition) && creatable.isValidPosition(creationContext, insertionPosition)) {
                        XmlCreationResult result = creatable.createAtPosition(creationContext, insertionPosition, null);
                        ret[0] = result.getFirstCreatedNode();
                    } else {
                        positionInvalid[0] = true;
                    }
                }
            }.runThrowingXCE((AbstractModel)activeView);
        }
        catch (XmlCommitException e) {
            ret[0] = null;
            activeView.getLogger().log(Level.FINER, "VisualEditorItemHandler insert failed", e);
            this._showMessage("ErrorDuringInsertionTitle", "ErrorDuringInsertion", (AbstractModel)activeView, creatable, (Exception)((Object)e));
        }
        if (positionInvalid[0]) {
            this._showMessage("PALETTE.INVALID_INSERTION", "CannotInsertInvalidPos", (AbstractModel)activeView, creatable, null);
        }
        return ret[0] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DomPosition getInsertionPosition(Context ideContext, Editor editor, XmlContext xmlContext, XmlModel xmlModel, XmlView activeView, XmlCreatable xmlCreatable) {
        DomPosition insertionPosition = null;
        if (activeView != null) {
            activeView.acquireReadLock();
            try {
                insertionPosition = activeView.getSelection().getCursorLocation();
            }
            finally {
                activeView.releaseReadLock();
            }
        }
        return insertionPosition;
    }

    private void _showMessage(String titleKey, String messageKey, AbstractModel model, final XmlCreatable creatable, Exception exception) {
        String title = model.getTranslatedString(titleKey);
        String messageFormat = model.getTranslatedString(messageKey);
        final XmlCreationContext creationContext = XmlCreationContext.create((AbstractModel)model, (String)"xmlef-palette");
        String shortDisplayName = (String)new ReadOnlyTask<String>(){

            protected String runImpl(AbstractModel model) {
                return creatable.getShortDisplayName(creationContext);
            }
        }.run(model);
        String message = FastMessageFormat.formatMessage((String)messageFormat, (String)shortDisplayName);
        if (exception != null) {
            model.getContext().showErrorMessage(message, title, (Throwable)exception);
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
        }
    }

    protected VisualEditorItemHandler() {
    }
}

