/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.overviewEditor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.overviewEditor.OverviewEditorPanel;
import oracle.bali.xml.gui.jdev.overviewEditor.XmlPanelWrapperFactory;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelWrapper;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.ide.controls.WaitCursor;
import oracle.ide.view.View;
import org.w3c.dom.Node;

public abstract class AbstractOverviewEditorXmlGui
extends XmlGui
implements JDevViewHostedGui,
ComponentXmlGui<Component> {
    private OverviewEditorPanel _overviewEditorPanel;
    private List<XmlPanelWrapper> _xmlPanelWrapperList;
    private View _view;

    public AbstractOverviewEditorXmlGui(XmlView view) {
        super(view);
    }

    public Component getComponent() {
        if (this._overviewEditorPanel == null) {
            Map<Component, XmlPanelWrapper> xmlPanelWrapperMap = this.createXmlPanelWrapperMap();
            this._xmlPanelWrapperList = new ArrayList<XmlPanelWrapper>();
            for (Map.Entry<Component, XmlPanelWrapper> entries : xmlPanelWrapperMap.entrySet()) {
                entries.getValue().setParentXmlGui(this);
                this._xmlPanelWrapperList.add(entries.getValue());
            }
            Collections.sort(this._xmlPanelWrapperList, new Comparator<XmlPanelWrapper>(){

                @Override
                public int compare(XmlPanelWrapper pw1, XmlPanelWrapper pw2) {
                    return pw1.getDisplayOrder() <= pw2.getDisplayOrder() ? -1 : 1;
                }
            });
            this._overviewEditorPanel = new OverviewEditorPanel(xmlPanelWrapperMap, this);
        }
        return this._overviewEditorPanel;
    }

    protected abstract List<XmlPanelWrapperFactory> getPanelWrapperFactoryList();

    public Map<Component, XmlPanelWrapper> createXmlPanelWrapperMap() {
        HashMap<Component, XmlPanelWrapper> xmlPanelWrapperMap = new HashMap<Component, XmlPanelWrapper>();
        for (XmlPanelWrapperFactory factory : this.getPanelWrapperFactoryList()) {
            factory.createXmlPanelWrappers(this, xmlPanelWrapperMap);
        }
        return xmlPanelWrapperMap;
    }

    @Override
    public void setOwningJDevView(View view) {
        this._view = view;
    }

    @Override
    public View getOwningJDevView() {
        return this._view;
    }

    public void dispose() {
        super.dispose();
        if (this._overviewEditorPanel != null) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    AbstractOverviewEditorXmlGui.this._overviewEditorPanel.dispose();
                    AbstractOverviewEditorXmlGui.this._overviewEditorPanel = null;
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runner.run();
            } else {
                SwingUtilities.invokeLater(runner);
            }
        }
        this._view = null;
    }

    protected void handleModelChangeEvent(final XmlModelEvent event) {
        XmlGui activeGui;
        super.handleModelChangeEvent(event);
        if (this.syncEditorWithSelectionChange() && event.isSelectionChanged() && (activeGui = this.getGuiContext().getActiveGui()) != null && activeGui != this) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Set selectionsAdded = event.getSelectionsAdded();
                    if (!selectionsAdded.isEmpty()) {
                        Node selectedNode = (Node)selectionsAdded.iterator().next();
                        AbstractOverviewEditorXmlGui.this.handleSelectionChanged(selectedNode);
                    }
                }
            });
        }
    }

    protected boolean syncEditorWithSelectionChange() {
        return false;
    }

    protected void handleShown() {
        super.handleShown();
        this._overviewEditorPanel.handleShown();
    }

    protected void handleHidden() {
        super.handleHidden();
        this._overviewEditorPanel.handleHidden();
    }

    public void handleSelectionChanged(Object selectedObject) {
        WaitCursor waitCursor = new WaitCursor((Component)this._overviewEditorPanel);
        waitCursor.show();
        int selectedTabIdx = 0;
        for (XmlPanelWrapper xmlPanelWrapper : this._xmlPanelWrapperList) {
            if (xmlPanelWrapper.handleSelectionChanged(selectedObject)) {
                if (this._overviewEditorPanel.getTabbedPane() != null) {
                    this._overviewEditorPanel.setSelectedIndex(selectedTabIdx, false);
                }
                waitCursor.hide();
                return;
            }
            ++selectedTabIdx;
        }
        waitCursor.hide();
    }

    public List<XmlPanelWrapper> getPanelWrapperList() {
        return this._xmlPanelWrapperList;
    }
}

