/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.Customizer;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.GuiXmlContextUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.BaseContextualActionsGui;
import oracle.bali.xml.gui.base.inspector.PISelectionModel;
import oracle.bali.xml.gui.base.inspector.PropertyModelUtils;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.inspector.JDevInspectorGui;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlContextLifecycleListener;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.CollectionUtils;
import oracle.bali.xml.util.XmlCustomizeAction;
import oracle.ide.Context;
import oracle.ide.inspector.ComponentLevelActions;
import oracle.ide.inspector.Inspectable2;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.util.Filter;
import org.w3c.dom.Node;

public class XmlInspectable
extends XmlContextLifecycleListener
implements Inspectable2,
ViewListener,
ComponentLevelActions {
    private static final Action[] _EMPTY_ACTIONS = new Action[0];
    private static Icon _sCustomizerIcon;
    private JDevXmlContext _xmlContext;
    private JDevInspectorGui _currentGui;
    private PropertyModel _propertyModel;
    private static final Logger _LOGGER;

    public void setContext(Context newIdeContext) {
        boolean updateGui;
        JDevInspectorGui newGui;
        JDevXmlContext newXmlContext;
        JDevXmlContext oldXmlContext = this._xmlContext;
        this._xmlContext = newXmlContext = JDevXmlContext.getXmlContext(newIdeContext);
        JDevInspectorGui oldGui = this._currentGui;
        this._currentGui = newGui = this._getGui(newXmlContext);
        boolean bl = updateGui = oldGui != newGui;
        if (oldXmlContext != newXmlContext) {
            updateGui = true;
            if (oldXmlContext != null) {
                if (_LOGGER.isLoggable(Level.FINER)) {
                    _LOGGER.log(Level.FINER, "DETACH: Inspectable {0} detached from context {1}", new Object[]{this, oldXmlContext});
                }
                oldXmlContext.removeLifecycleListener(this);
                _LOGGER.finer("DETACH complete.");
            }
            if (newXmlContext != null) {
                if (_LOGGER.isLoggable(Level.FINER)) {
                    _LOGGER.log(Level.FINER, "ATTACH: Inspectable {0} attached to context {1}", new Object[]{this, newXmlContext});
                }
                newXmlContext.addLifecycleListener(this);
                _LOGGER.finer("ATTACH complete.");
            }
        }
        if (updateGui && oldGui != null) {
            oldGui.hidden();
            if (this._propertyModel != null) {
                SelectionModel sm;
                if (this._propertyModel instanceof MultiObjectModel && (sm = ((MultiObjectModel)this._propertyModel).getSelectionModel()) instanceof PISelectionModel) {
                    ((PISelectionModel)sm).dispose();
                }
                this._propertyModel = null;
            }
        }
        if (newGui != null) {
            this._propertyModel = newGui.createPropertyModel(false);
            newGui.shown();
        }
    }

    public Object getTarget() {
        return this._xmlContext == null ? null : this._xmlContext.getIdeDocument();
    }

    public PropertyModel getPropertyModel() {
        JDevInspectorGui gui;
        if (this._propertyModel == null && (gui = this._getCurrentGui()) != null) {
            this._propertyModel = gui.createPropertyModel(false);
        }
        return this._propertyModel;
    }

    public Customizer getCustomizer() {
        return null;
    }

    public Component[] getAdditionalTabPages() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCustomDialog() {
        Node n = this._getOnlySelectedNode();
        JDevInspectorGui gui = this._getCurrentGui();
        if (n != null && gui != null) {
            XmlView view = gui.getView();
            view.acquireReadLock();
            try {
                boolean enabled = XmlCustomizeAction.isNodeCustomizable((AbstractModel)view, (Node)n);
                Action a = gui.getGuiContext().getAction("customizeNode");
                a.setEnabled(enabled);
                boolean bl = enabled;
                return bl;
            }
            finally {
                view.releaseReadLock();
            }
        }
        return false;
    }

    public Icon getCustomDialogIcon() {
        if (_sCustomizerIcon == null) {
            Image i = ImageUtils.getImageResource(XmlInspectable.class, (String)"images/customizer.gif");
            _sCustomizerIcon = new ImageIcon(i);
        }
        return _sCustomizerIcon;
    }

    public String getCustomDialogToolTipText() {
        Node n = this._getOnlySelectedNode();
        if (n == null) {
            return "";
        }
        String format = this._getCurrentGui().getTranslatedString("INSPECTOR.CUSTOM_DIALOG_TOOLTIP_FORMAT");
        return FastMessageFormat.formatMessage((String)format, (String)n.getNodeName());
    }

    public void showCustomDialog(Component parent) {
        JDevInspectorGui gui;
        Node n = this._getOnlySelectedNode();
        if (n != null && (gui = this._getCurrentGui()) != null) {
            Action a = gui.getGuiContext().getAction("customizeNode");
            a.actionPerformed(new ActionEvent(n, 0, "customizeNode"));
        }
    }

    public void dispose() {
        this.setContext(null);
    }

    public Action[] getLinkActions() {
        return null;
    }

    public void viewActivated(ViewEvent e) {
        JDevInspectorGui gui = this._getCurrentGui();
        if (gui != null) {
            gui.shown();
            gui.activate();
        }
    }

    public void viewDeactivated(ViewEvent e) {
        JDevInspectorGui gui = this._getCurrentGui();
        if (gui != null) {
            gui.deactivate();
        }
    }

    public void viewClosed(ViewEvent e) {
        JDevInspectorGui gui = this._getCurrentGui();
        if (gui != null) {
            gui.hidden();
        }
    }

    public void preContextDisposal(XmlContext context) {
        this.setContext(null);
    }

    public Action[] getToolbarActions() {
        return this._getActions(new Filter<Action>(){

            public boolean matches(Action a) {
                return Boolean.TRUE.equals(a.getValue("show-in-pi-toolbar"));
            }
        });
    }

    public Action[] getDropdownActions() {
        return this._getActions(new Filter<Action>(){

            public boolean matches(Action a) {
                return !Boolean.FALSE.equals(a.getValue("show-in-pi"));
            }
        });
    }

    private Action[] _getActions(Filter<Action> f) {
        List contextualActions;
        BaseContextualActionsGui contextualActionsGui = (BaseContextualActionsGui)GuiXmlContextUtils.getGui((GuiXmlContext)this._xmlContext, (XmlUsage)XmlUsage.CONTEXTUAL_ACTIONS);
        if (contextualActionsGui != null && !(contextualActions = contextualActionsGui.getContextualActions()).isEmpty()) {
            return (Action[])CollectionUtils.toArray(Action.class, (Collection)contextualActions, f);
        }
        return _EMPTY_ACTIONS;
    }

    private Node _getOnlySelectedNode() {
        return (Node)PropertyModelUtils.getGlobalDataIfSingleModel((PropertyModel)this.getPropertyModel(), Node.class, (Object)XmlDomPropertyModel.COLUMN_ANCESTOR_NODE);
    }

    private JDevInspectorGui _getGui(JDevXmlContext xmlContext) {
        XmlGui gui;
        if (xmlContext != null && (gui = xmlContext.getGui(XmlUsage.PROPERTY_INSPECTOR)) instanceof JDevInspectorGui) {
            return (JDevInspectorGui)gui;
        }
        return null;
    }

    private JDevInspectorGui _getCurrentGui() {
        if (this._currentGui == null) {
            this._currentGui = this._getGui(this._xmlContext);
        }
        return this._currentGui;
    }

    static {
        _LOGGER = Logger.getLogger(XmlInspectable.class.getName());
    }
}

