/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.inspector.JDevDomPropertyModel;
import oracle.bali.xml.gui.jdev.inspector.JDevInspectorWindow;
import oracle.bali.xml.gui.jdev.inspector.JDevPropertyInspector;
import oracle.bali.xml.gui.swing.inspector.SwingInspectorGui;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.dependency.ReferenceFactory;
import oracle.bali.xml.util.SimpleTypePropertyEditorManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import org.w3c.dom.Node;

public class JDevInspectorGui
extends SwingInspectorGui {
    private static final Object _BOGUS_INSPECTOR_WINDOW = JDevInspectorGui.class.getName() + " bogus inspector window";

    public JDevInspectorGui(XmlView view) {
        super(view);
    }

    public XmlDomPropertyModel createPropertyModel(Node node, XmlKey key) {
        return new JDevDomPropertyModel(node, key, (BaseInspectorGui)this);
    }

    public XmlDomPropertyModel createPropertyModel(Node node, List<XmlKey> keys) {
        return new JDevDomPropertyModel(node, keys, (BaseInspectorGui)this);
    }

    public void registerPropertyEditors() {
        super.registerPropertyEditors();
        String uriClassName = "oracle.bali.xml.gui.jdev.inspector.editors.JDevURIEditor";
        try {
            SimpleTypeConverter converter = JavaTypeManager.getInstance().getSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASS);
            Class uriClass = (Class)converter.convertToJavaType("oracle.bali.xml.gui.jdev.inspector.editors.JDevURIEditor", null);
            SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "anyURI", uriClass);
            this.registerDefaultIdentifier(DEFAULT_EDITOR_URI, "oracle.bali.xml.gui.jdev.inspector.editors.JDevURIEditor");
        }
        catch (GrammarException grammarException) {
            // empty catch block
        }
        this.registerDefaultIdentifier(DEFAULT_EDITOR_IMAGE, "oracle.bali.xml.gui.jdev.inspector.editors.JDevImageEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_JAVACLASS, "oracle.bali.xml.gui.jdev.inspector.editors.JDevClassPickerEditor");
    }

    public Component getInspectorContainer(PropertyInspector pi) {
        if (pi instanceof JDevPropertyInspector) {
            return ((JDevPropertyInspector)pi).getOwner().getGUI();
        }
        return super.getInspectorContainer(pi);
    }

    public List<? extends Issue> getNodeMessageList(Node node) {
        if (node == null) {
            return Collections.emptyList();
        }
        JDevXmlContext context = (JDevXmlContext)this.getView().getContext();
        IssueList issueList = context.getIssueList();
        ArrayList<Issue> issues = new ArrayList<Issue>(issueList.size());
        for (Issue i : issueList) {
            if (!this._isValidProperty(i.getConstruct(), node)) continue;
            issues.add(i);
        }
        return issues;
    }

    protected PropertyEditor createPropertyEditor(Node node, XmlKey nodeKey, Object value) {
        ReferenceFactory factory;
        PropertyEditor pe = null;
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        String s = resolver.getPropertyEditor(nodeKey);
        if ((s == null || DEFAULT_EDITOR_JAVACLASS.equals(s) || "oracle.bali.xml.gui.jdev.inspector.editors.JDevClassPickerEditor".equals(s)) && (factory = resolver.getReferenceFactory(nodeKey)) != null && factory.hasProperty("JAVA_CLASS")) {
            String baseClass = (String)factory.getProperty("JAVA_CLASS");
            pe = this.__loadClassPickerEditor(baseClass);
        }
        if (pe == null) {
            pe = super.createPropertyEditor(node, nodeKey, value);
        }
        return pe;
    }

    protected PropertyInspector createPropertyInspectorInstance() {
        JDevInspectorWindow window = new JDevInspectorWindow(this);
        PropertyInspector inspector = window.getPropertyInspector();
        inspector.putClientProperty(_BOGUS_INSPECTOR_WINDOW, (Object)window);
        return inspector;
    }

    public void disposePropertyInspector(PropertyInspector inspector) {
        super.disposePropertyInspector(inspector);
        JDevInspectorWindow window = (JDevInspectorWindow)((Object)inspector.getClientProperty(_BOGUS_INSPECTOR_WINDOW));
        if (window != null) {
            window.stateChange(3);
            inspector.putClientProperty(_BOGUS_INSPECTOR_WINDOW, null);
        }
    }

    protected Container getInspectorToolbar(PropertyInspector pi) {
        if (pi instanceof JDevPropertyInspector) {
            return ((JDevPropertyInspector)pi).getOwner().getToolbar();
        }
        return super.getInspectorToolbar(pi);
    }

    protected JButton createResetButton() {
        return new ToolButton(null);
    }

    protected JToggleButton createDatabindingButton() {
        final ToggleAction ta = new ToggleAction(this.getTranslatedString("INSPECTOR.ADD_DATABINDING"), this.getDatabindingToolbarIcon()){

            public void actionPerformed(ActionEvent e) {
            }
        };
        ToggleToolButton ttb = new ToggleToolButton(ta);
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String tooltipKey = e.getStateChange() == 1 ? "INSPECTOR.REMOVE_DATABINDING" : "INSPECTOR.ADD_DATABINDING";
                String tooltip = JDevInspectorGui.this.getTranslatedString(tooltipKey);
                ta.putValue("ShortDescription", (Object)tooltip);
            }
        };
        ttb.addItemListener(il);
        return ttb;
    }

    protected JToggleButton createSelectTextResourceButton() {
        Image image = ImageUtils.getImageResource(SwingInspectorGui.class, (String)"image/selectTextResource.png");
        ImageIcon icon = new ImageIcon(image);
        final ToggleAction ta = new ToggleAction(this.getTranslatedString("INSPECTOR.ADD_TEXT_RESOURCE"), icon){

            public void actionPerformed(ActionEvent e) {
            }
        };
        ToggleToolButton ttb = new ToggleToolButton(ta);
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String tooltipKey = "INSPECTOR.ADD_TEXT_RESOURCE";
                String tooltip = JDevInspectorGui.this.getTranslatedString(tooltipKey);
                ta.putValue("ShortDescription", (Object)tooltip);
            }
        };
        ttb.addItemListener(il);
        return ttb;
    }

    PropertyEditor __loadClassPickerEditor(String baseClass) {
        try {
            SimpleTypeConverter converter = JavaTypeManager.getInstance().getSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASS);
            Class c = (Class)converter.convertToJavaType("oracle.bali.xml.gui.jdev.inspector.editors.JDevClassPickerEditor", null);
            if (PropertyEditor.class.isAssignableFrom(c)) {
                Constructor constructor = c.getConstructor(String.class);
                return (PropertyEditor)constructor.newInstance(baseClass);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (GrammarException grammarException) {
            // empty catch block
        }
        return null;
    }

    private boolean _isValidProperty(Object o, Node node) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        return node == o;
    }
}

