/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.extension;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.gui.jdev.extension.HookDataListener;
import oracle.bali.xml.share.WeakListenerManager;

public class BaseHookSupport<T> {
    private final Object _hookDataLock = new Object();
    private final Manager _listenerMgr = new Manager();
    private List<T> _hookDataList = new ArrayList<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHookDataListener(HookDataListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("addHookDataListener called with null argument");
        }
        Object object = this._hookDataLock;
        synchronized (object) {
            this._listenerMgr.addListener(listener);
            for (T hookData : this._hookDataList) {
                this.fireHookDataAdded(listener, hookData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHookData(T hookData) {
        Object object = this._hookDataLock;
        synchronized (object) {
            this._hookDataList.add(hookData);
            this._listenerMgr.notifyListeners(hookData);
        }
    }

    private void fireHookDataAdded(HookDataListener<T> listener, T hookData) {
        listener.hookDataAdded(hookData);
    }

    private class Manager
    extends WeakListenerManager {
        public Manager() {
            super(BaseHookSupport.this.toString());
        }

        protected void notifyListenerImpl(Object listener, Object event, Object deliveryHint) {
            ((HookDataListener)listener).hookDataAdded(event);
        }
    }
}

