/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor.breadcrumbs;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.UIManager;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.ceditor.breadcrumbs.XmlBreadcrumb;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class XmlBreadcrumbsModel
implements BreadcrumbsModel {
    private static final int FAVORITE_PROP_MAX_LENGTH = 20;
    public static final String ID_ATTR_NAME = "id";
    private LinkedList<BreadcrumbsModelListener> _mListeners = new LinkedList();
    private NodeFilter _mFilter;
    private ArrayList<Breadcrumb> _mCrumbs = new ArrayList();
    private XmlView _mXmlView;
    private static StyledTextAttribute _mNormalAttr;
    private static StyledTextAttribute _mBoldAttr;
    private XmlBreadcrumb _mEmptyBreadcrumb;

    public XmlBreadcrumbsModel(XmlView view) {
        this(view, null);
    }

    public XmlBreadcrumbsModel(XmlView view, NodeFilter filter) {
        this._mFilter = filter;
        Font font = UIManager.getFont("Label.font");
        _mNormalAttr = new StyledTextAttribute(font, null);
        _mBoldAttr = new StyledTextAttribute(font.deriveFont(1), null);
        this._mXmlView = view;
        String emptyText = " ";
        StyledTextModel emptyModel = new StyledTextModel(emptyText, _mNormalAttr);
        this._mEmptyBreadcrumb = new XmlBreadcrumb(null, emptyModel, emptyModel, emptyText, null);
    }

    void updateModel() {
        this._mCrumbs.clear();
        this._populateCrumbs();
        this._fireBreadcrumbsUpdated();
    }

    void dispose() {
        this._mCrumbs.clear();
        this._mXmlView = null;
        this._mFilter = null;
        this._mListeners.clear();
        this._mEmptyBreadcrumb = null;
    }

    boolean isEmptyCrumb(Breadcrumb crumb) {
        return crumb == this._mEmptyBreadcrumb;
    }

    private XmlView _getXmlView() {
        return this._mXmlView;
    }

    private TreeWalker _getTreeWalker() {
        return this._mXmlView.createTreeWalker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _populateCrumbs() {
        block15: {
            this._mXmlView.acquireReadLock();
            try {
                Selection selection = this._mXmlView.getSelection();
                Node curNode = null;
                int cnt = selection.getSelectedNodesCount();
                if (cnt > 0) {
                    if (cnt == 1) {
                        curNode = (Node)selection.getSelectedNodes().next();
                    } else {
                        Iterator it = selection.getSelectedNodes();
                        Node n1 = (Node)it.next();
                        while (it.hasNext()) {
                            Node n2 = (Node)it.next();
                            n1 = DomUtils.lowestCommonAncestor((Node)n1, (Node)n2);
                        }
                        curNode = n1;
                    }
                } else {
                    DomPosition cursor = selection.getCursorLocation();
                    if (cursor != null) {
                        curNode = cursor.getContainerNode();
                    }
                }
                if (curNode != null) {
                    XmlMetadataResolver resolver = this._mXmlView.getXmlMetadataResolver();
                    TreeWalker treeWalker = this._mXmlView.createTreeWalker();
                    treeWalker.setCurrentNode(curNode);
                    Node cNode = curNode;
                    while (cNode != null) {
                        Node parent;
                        StyledTextModel shortModel;
                        if (this._mFilter != null && this._mFilter.acceptNode(cNode) == 2) {
                            break block15;
                        }
                        String sn = this.getDisplayName(resolver, cNode, true);
                        String ln = this.getDisplayName(resolver, cNode, false);
                        StyledTextModel longModel = null;
                        if (cNode == curNode) {
                            shortModel = new StyledTextModel(sn, _mBoldAttr);
                            longModel = new StyledTextModel(ln, _mBoldAttr);
                        } else {
                            shortModel = new StyledTextModel(sn, _mNormalAttr);
                            longModel = new StyledTextModel(ln, _mNormalAttr);
                        }
                        String peekText = this.getPeekText(resolver, cNode);
                        XmlBreadcrumb crum = new XmlBreadcrumb(cNode, shortModel, longModel, peekText, new XmlBreadcrumbsChildProvider(cNode));
                        this._mCrumbs.add(0, crum);
                        Node treeWalkerCurrentNode = treeWalker.getCurrentNode();
                        if (treeWalkerCurrentNode != null && (treeWalkerCurrentNode.getNodeType() == 8 || treeWalkerCurrentNode.getNodeType() == 7) && (parent = treeWalkerCurrentNode.getParentNode()) != null && parent.getNodeType() == 9) {
                            break block15;
                        }
                        cNode = treeWalker.parentNode();
                    }
                    break block15;
                }
                this._mCrumbs.add(0, this._mEmptyBreadcrumb);
            }
            finally {
                this._mXmlView.releaseReadLock();
            }
        }
    }

    protected boolean isTextDisplayable(String text) {
        return true;
    }

    private String getPeekText(XmlMetadataResolver res, Node node) {
        StringBuffer sb = new StringBuffer();
        switch (node.getNodeType()) {
            case 3: {
                String text = ((Text)node).getData();
                if (text == null || text.trim().length() <= 0 || !this.isTextDisplayable(text)) break;
                sb.append(text);
                break;
            }
            default: {
                String text;
                Node n;
                NamedNodeMap attrs = node.getAttributes();
                if (attrs == null) break;
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    Node attr = attrs.item(i);
                    if (attr.getNodeType() != 2) continue;
                    if (i != 0 && i % 2 == 0) {
                        sb.append("\n");
                    }
                    if (attr.getLocalName() != null) {
                        sb.append(" " + attr.getLocalName() + "=");
                    } else {
                        sb.append(" " + attr.getNodeName() + "=");
                    }
                    String v = attr.getNodeValue();
                    if (v == null || v.trim().length() <= 0) continue;
                    sb.append("\"" + v + "\"");
                }
                if (len != 0 || (n = node.getFirstChild()) == null || n.getNodeType() != 3 || (text = n.getNodeValue()) == null || text.trim().length() <= 0 || !this.isTextDisplayable(text)) break;
                sb.append(text);
            }
        }
        return sb.toString();
    }

    private String getDisplayName(XmlMetadataResolver res, Node node, boolean shortName) {
        String txt = null;
        if (node != null) {
            short type = node.getNodeType();
            switch (type) {
                case 3: {
                    String text = ((Text)node).getData();
                    if (text == null || text.trim().length() == 0 || !this.isTextDisplayable(text)) {
                        text = node.getNodeName();
                    }
                    int len = text.length();
                    StringBuffer sb = new StringBuffer(6);
                    if (len > 8 && shortName) {
                        sb.append(text.substring(0, 8));
                        sb.append("...");
                    } else if (len > 40) {
                        sb.append(text.substring(0, 40));
                        sb.append("...");
                    } else {
                        sb.append(text);
                    }
                    txt = sb.toString();
                    break;
                }
                default: {
                    txt = node.getLocalName();
                    if (!(txt != null && txt.trim().length() != 0 || (txt = res.getShortDisplayName(node)) != null && txt.trim().length() != 0 || (txt = res.getMediumDisplayName(node)) != null && txt.trim().length() != 0 || (txt = res.getLongDisplayName(node)) != null && txt.trim().length() != 0)) {
                        txt = "";
                    }
                    if (type != 1) break;
                    StringBuffer s = new StringBuffer();
                    String prefix = node.getPrefix();
                    if (prefix != null) {
                        s.append(prefix);
                        s.append(":");
                    }
                    s.append(txt);
                    String id = ((Element)node).getAttributeNS(null, ID_ATTR_NAME);
                    if (id != null && id.trim().length() > 0) {
                        s.append("#");
                        s.append(id);
                    }
                    txt = s.toString();
                }
            }
        }
        return txt != null ? txt.toLowerCase() : txt;
    }

    public int getBreadcrumbCount() {
        return this._mCrumbs != null ? this._mCrumbs.size() : 0;
    }

    public Breadcrumb getBreadcrumb(int crumb) {
        return this._mCrumbs.get(crumb);
    }

    public boolean hasChildren(Breadcrumb breadcrumb) {
        XmlBreadcrumb bc = (XmlBreadcrumb)breadcrumb;
        return bc.hasChildren();
    }

    public void addBreadcrumbsModelListener(BreadcrumbsModelListener l) {
        if (!this._mListeners.contains(l)) {
            this._mListeners.add(l);
        }
    }

    public void removeBreadcrumbsModelListener(BreadcrumbsModelListener l) {
        if (this._mListeners.contains(l)) {
            this._mListeners.remove(l);
        }
    }

    private void _fireBreadcrumbsUpdated() {
        for (BreadcrumbsModelListener l : this._mListeners) {
            l.breadcrumbsUpdated();
        }
    }

    private class XmlBreadcrumbsChildProvider
    implements XmlBreadcrumb.BreadCrumbsChildProvider {
        private Node _mNode;
        private List<PopupItem<Node>> _mChildren;

        private XmlBreadcrumbsChildProvider(Node node) {
            this._mNode = node;
        }

        @Override
        public boolean hasChildren() {
            return this._mNode.getNodeType() == 1 && this._mNode.getFirstChild() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PopupItem<Node>> getChildren() {
            XmlView view;
            if (this._mChildren == null && (view = XmlBreadcrumbsModel.this._getXmlView()) != null) {
                view.acquireReadLock();
                try {
                    XmlMetadataResolver resolver = view.getXmlMetadataResolver();
                    this._mChildren = new ArrayList<PopupItem<Node>>();
                    for (Node ch = this._mNode.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(XmlBreadcrumbsModel.this.getDisplayName(resolver, ch, true));
                        String fp = resolver.getFavoritePropertyValue(ch);
                        if (fp != null && fp.trim().length() > 0) {
                            sb.append(" - ");
                            if (fp.length() > 20) {
                                sb.append(fp.substring(0, 20));
                                sb.append("...");
                            } else {
                                sb.append(fp);
                            }
                        }
                        PopupItem pItem = new PopupItem();
                        pItem.setName(sb.toString());
                        pItem.setIcon(resolver.getSmallIcon(ch));
                        pItem.setUserObject((Object)ch);
                        this._mChildren.add((PopupItem<Node>)pItem);
                    }
                }
                finally {
                    view.releaseReadLock();
                }
            }
            return this._mChildren;
        }
    }
}

