/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.builder;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.addin.builder.DocTypeInfo;
import oracle.bali.xml.addin.builder.XMLSourceNodeBuilderException;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;

public abstract class XMLSourceNodeBuilder<T extends XMLSourceNode> {
    private Class<T> _clazz;
    private static final Logger _LOGGER = Logger.getLogger(XMLSourceNodeBuilder.class.getName());

    public XMLSourceNodeBuilder(Class<T> clazz) {
        this._clazz = clazz;
    }

    public T findOrCreateIn(Workspace workspace, Project project, URL url, boolean addToProject) throws XMLSourceNodeBuilderException, IllegalArgumentException {
        return this.findOrCreateIn(workspace, project, url, addToProject, null);
    }

    public T findOrCreateIn(Workspace workspace, Project project, URL url, boolean addToProject, Enum version) throws XMLSourceNodeBuilderException, IllegalArgumentException {
        if (workspace == null) {
            throw new IllegalArgumentException("The workspace cannot be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("The URL cannot be null.");
        }
        try {
            Node node = NodeFactory.find((URL)url);
            if (node == null) {
                Node node2 = node = URLFileSystem.exists((URL)url) ? NodeFactory.findOrCreate((URL)url) : NodeFactory.findOrCreate(this._clazz, (URL)url);
            }
            if (!this._clazz.isInstance(node)) {
                _LOGGER.log(Level.INFO, "Expected node class: " + this._clazz.getName() + ", but found: " + node.getClass().getName() + ".  The node has been replaced in the NodeFactory cache.");
                NodeFactory.uncache((URL)url);
                node = NodeFactory.findOrCreate(this._clazz, (URL)url);
            }
            if (node != null) {
                XMLSourceNode tNode = (XMLSourceNode)node;
                boolean nodeWasEmpty = tNode.hasEmptyTextBuffer();
                if (nodeWasEmpty) {
                    JDevXmlContext context = XMLSourceNode.getXmlContext(new Context(null, workspace, project, (Node)tNode));
                    XmlModel model = context.getModel();
                    model.getDomModel().setXmlDeclarationInfo(XmlDeclarationInfo.SUITABLE_DEFAULT);
                    DocTypeInfo docType = this.getDocType();
                    if (docType != null) {
                        model.getDomModel().setDocType(docType.getQualifiedName(), docType.getPublicId(), docType.getSystemId());
                    }
                    this.createAndInitRoot(model, version);
                    tNode.save();
                    if (addToProject && project != null) {
                        project.add(node, this.getContentSet());
                    }
                }
                return (T)((Object)tNode);
            }
        }
        catch (XmlCommitException xce) {
            throw new XMLSourceNodeBuilderException("An error occurred during findOrCreateIn.", xce);
        }
        catch (IOException ioe) {
            throw new XMLSourceNodeBuilderException("An error occurred during findOrCreateIn.", ioe);
        }
        catch (IllegalAccessException iae) {
            throw new XMLSourceNodeBuilderException("An error occurred during findOrCreateIn.", iae);
        }
        catch (InstantiationException ie) {
            throw new XMLSourceNodeBuilderException("An error occurred during findOrCreateIn.", ie);
        }
        return null;
    }

    protected XmlDeclarationInfo getXmlDeclarationInfo() {
        return XmlDeclarationInfo.SUITABLE_DEFAULT;
    }

    protected DocTypeInfo getDocType() {
        return null;
    }

    protected String getContentSet() {
        return null;
    }

    protected abstract void createAndInitRoot(XmlModel var1, Enum var2) throws XmlCommitException;
}

