/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.addin.schema.MapSchema;
import oracle.bali.xml.addin.schema.SchemaMap;
import oracle.bali.xml.addin.schema.SchemaOptionsPrefs;
import oracle.bali.xml.addin.schema.SchemaUtils;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class SchemaRegistryAddin
implements Addin,
EditorListener {
    private static LinkedHashMap _grammarProviderMap = new LinkedHashMap();
    private static HashMap _processedLocationMap = new HashMap();
    private static Logger _logger = null;
    private static SchemaMap _schemaMap = null;

    public static void registerSchema(URL schema, String extension) {
        SchemaRegistryAddin.getSchemaMap().put(schema, SchemaRegistryAddin._canonicalize(extension), false);
    }

    public static void loadSchema(Editor editor) {
        SchemaRegistryAddin._loadSchema(editor, SchemaRegistryAddin.getSchemaMap());
    }

    public static void loadSchema(Element e) {
        SchemaRegistryAddin._loadSchema(e, SchemaRegistryAddin.getSchemaMap());
    }

    public static void loadSchema(String extension) {
        SchemaRegistryAddin._loadSchema(extension, SchemaRegistryAddin.getSchemaMap());
    }

    public static synchronized void clearAndReloadOnDemand() {
        Collection existingProviders = _grammarProviderMap.values();
        for (SchemaGrammarProvider gp : existingProviders) {
            gp.clearSchemas();
        }
        _processedLocationMap.clear();
    }

    public static synchronized void clearAndReloadOnDemand(String extension) {
        HashSet processedSet;
        SchemaGrammarProvider gp = (SchemaGrammarProvider)_grammarProviderMap.get(extension = SchemaRegistryAddin._canonicalize(extension));
        if (gp != null) {
            gp.clearSchemas();
        }
        if ((processedSet = (HashSet)_processedLocationMap.get(extension)) != null) {
            processedSet.clear();
        }
    }

    public static void loadSchemasForOpenEditors(SchemaMap map) {
        List editors = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : editors) {
            Node node = editor.getContext().getNode();
            if (node == null || XMLEditorAddin.getExtension(node.getClass()) == null) continue;
            SchemaRegistryAddin._loadSchema(editor, map);
        }
    }

    public static GrammarProvider getGrammarProvider(String extension) {
        return SchemaRegistryAddin._getGrammarProvider(SchemaRegistryAddin._canonicalize(extension));
    }

    public void initialize() {
        this._registerSettings();
        File oraclehome = new File(Ide.getOracleHomeDirectory());
        File jlib = new File(oraclehome, "jlib");
        String zipFile = "schemas.zip";
        File f = new File(jlib, zipFile);
        URL url = URLFactory.newJarURL((File)f, (String)"xsd/XMLSchema.xsd");
        SchemaRegistryAddin.registerSchema(url, ".xsd");
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null) {
            editorManager.addEditorListener((EditorListener)this);
        }
        this._initUserExtensions();
        this._setLoadRemoteSchemasProperty();
    }

    public void editorOpened(Editor editor) {
        SchemaRegistryAddin.loadSchema(editor);
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
    }

    public static String getTranslatedString(String key) {
        try {
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.xml.addin.resource.SchemaBundle", Locale.getDefault());
            return b.getString(key);
        }
        catch (Exception e) {
            return "???" + key + "???";
        }
    }

    public static SchemaMap getSchemaMap() {
        if (_schemaMap == null) {
            _schemaMap = new SchemaMap();
            SchemaOptionsPrefs schemaPrefs = SchemaOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
            List<List> schemaMapList = schemaPrefs.getSchemaMapList();
            for (int i = 0; i < schemaMapList.size(); ++i) {
                List schemaMapEntry = schemaMapList.get(i);
                URL url = (URL)schemaMapEntry.get(0);
                String extension = (String)schemaMapEntry.get(1);
                _schemaMap.put(url, extension, true);
            }
        }
        return _schemaMap;
    }

    public static void setSchemaMap(SchemaMap map, SchemaOptionsPrefs schemaPrefs) {
        MapSchema[] schemaMap = map.getSchemas();
        ListStructure schemaMapList = ListStructure.newInstance();
        for (int i = 0; i < schemaMap.length; ++i) {
            if (!schemaMap[i].isUserDefined()) continue;
            ListStructure schemaMapEntry = ListStructure.newInstance();
            schemaMapEntry.add((Object)schemaMap[i].getURL());
            schemaMapEntry.add((Object)schemaMap[i].getExtension());
            schemaMapList.add(schemaMapEntry);
        }
        schemaPrefs.setSchemaMapList(schemaMapList);
        _schemaMap = map;
    }

    private static void _loadSchema(Editor editor, SchemaMap map) {
        Node e;
        Context context = editor.getContext();
        if (context != null && (e = context.getNode()) != null) {
            SchemaRegistryAddin._loadSchema((Element)e, map);
        }
    }

    private static void _loadSchema(Element e, SchemaMap map) {
        int index;
        String label = e.getShortLabel();
        String extension = null;
        if (label != null && (index = label.lastIndexOf(".")) != -1) {
            extension = label.substring(index);
        }
        SchemaRegistryAddin._loadSchema(extension, map);
    }

    private static void _loadSchema(String extension, SchemaMap map) {
        extension = SchemaRegistryAddin._canonicalize(extension);
        List urls = map.get(extension);
        SchemaRegistryAddin._loadSchemas(extension, urls);
    }

    private static void _loadSchemas(String extension, List schemaURLs) {
        if (!schemaURLs.isEmpty()) {
            SchemaGrammarProvider gp = SchemaRegistryAddin._getGrammarProvider(extension);
            HashSet processedSet = SchemaRegistryAddin._getProcessedLocations(extension);
            for (URL url : schemaURLs) {
                String externalForm = url.toExternalForm();
                if (processedSet.contains(externalForm)) continue;
                processedSet.add(externalForm);
                Set loadedGrammars = SchemaRegistryAddin._loadSchemaHelper(gp, url);
                for (Grammar g : loadedGrammars) {
                    String gLocation = g.getGrammarIdentifier().getLocation();
                    if (gLocation == null) continue;
                    processedSet.add(gLocation);
                }
            }
        }
    }

    private static Set _loadSchemaHelper(SchemaGrammarProvider grammarProvider, URL url) {
        Set grammars = Collections.EMPTY_SET;
        Assert.startTiming((String)(SchemaRegistryAddin.class.getName() + "._loadSchema(URL)"), null, (boolean)false);
        try {
            grammars = grammarProvider.addSchema(url);
        }
        catch (GrammarException ge) {
            SchemaRegistryAddin._getLogger().log(Level.SEVERE, "Exception loading schema " + url, ge);
        }
        Assert.endTiming((String)(SchemaRegistryAddin.class.getName() + "._loadSchema(URL)"), (String)("  Loaded schemas from " + URLFileSystem.getPlatformPathName((URL)url)), null, (boolean)false);
        return grammars;
    }

    private static synchronized SchemaGrammarProvider _getGrammarProvider(String extension) {
        SchemaGrammarProvider gp = (SchemaGrammarProvider)_grammarProviderMap.get(extension);
        if (gp == null) {
            gp = new SchemaGrammarProvider();
            _grammarProviderMap.put(extension, gp);
        }
        return gp;
    }

    private static synchronized HashSet _getProcessedLocations(String extension) {
        HashSet set = (HashSet)_processedLocationMap.get(extension);
        if (set == null) {
            set = new HashSet();
            _processedLocationMap.put(extension, set);
        }
        return set;
    }

    private void _registerSettings() {
        SchemaRegistryAddin.getSchemaMap();
    }

    private void _initUserExtensions() {
        SchemaMap map = SchemaRegistryAddin.getSchemaMap();
        MapSchema[] schemas = map.getSchemas();
        int count = schemas == null ? 0 : schemas.length;
        for (int i = 0; i < count; ++i) {
            String ext;
            if (!schemas[i].isUserDefined() || XMLEditorAddin.getClass(ext = schemas[i].getExtension()) != null || Recognizer.getClassForExtension((String)ext) != null) continue;
            if (ext.indexOf(".") == -1) {
                ext = "." + ext;
            }
            Recognizer.mapExtensionToClass((String)ext, XMLSourceNode.class);
            XMLEditorAddin.register(XMLSourceNode.class, ext);
        }
    }

    private void _setLoadRemoteSchemasProperty() {
        SchemaOptionsPrefs sop = SchemaOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
        SchemaUtils.setPrivateLoadRemoteSchemasSystemProperty(sop.getLoadRemoteSchemas());
    }

    private static String _canonicalize(String extension) {
        if (extension != null && !extension.startsWith(".")) {
            extension = "." + extension;
        }
        return extension;
    }

    private static Logger _getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("oracle.bali.xml.addin");
        }
        return _logger;
    }
}

