/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.tsp;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cmp.PKIStatusInfo;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.TSTInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.tsp.MessageImprint;
import oracle.security.crypto.tsp.TSPException;
import oracle.security.crypto.tsp.TSPFormatException;
import oracle.security.crypto.tsp.TSPMessage;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class TSPTimeStampResp
extends TSPMessage {
    private PKIStatusInfo status;
    private CMSSignedDataContentInfo timeStampToken;
    private boolean includeCert;
    private TSTInfo tstInfo;
    private PrivateKey signerKey;
    private X509Certificate signerCert;
    private AlgorithmIdentifier digestAlgId;
    private AlgorithmIdentifier digestEncryptionAlgId;
    private AttributeSet authenticatedAttributes;
    private AttributeSet unauthenticatedAttributes;
    boolean useSPKI64;
    private byte[] cache;
    private MessageImprint messageImprint;

    public TSPTimeStampResp() {
    }

    public TSPTimeStampResp(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgId, AlgorithmIdentifier digestEncryptionAlgId, AttributeSet authAttr, AttributeSet unauthAttr, boolean useSPKI64, PKIStatusInfo status, TSTInfo tstInfo, boolean includeCert) throws TSPException {
        this.status = status;
        this.tstInfo = tstInfo;
        this.includeCert = includeCert;
        this.setSigningParameters(signerKey, signerCert, digestAlgId, digestEncryptionAlgId, authAttr, unauthAttr, useSPKI64);
    }

    public TSPTimeStampResp(InputStream is) throws IOException {
        this.input(is);
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public void setStatus(PKIStatusInfo status) {
        this.status = status;
        this.update();
    }

    public TSTInfo getTSTInfo() {
        return this.tstInfo;
    }

    public void setTSTInfo(TSTInfo tstInfo) throws TSPException {
        this.tstInfo = tstInfo;
        this.update();
        this.updateTimeStampToken();
    }

    public boolean getIncludeCert() {
        return this.includeCert;
    }

    public void setIncludeCert(boolean b) throws TSPException {
        this.includeCert = b;
        this.update();
        this.updateTimeStampToken();
    }

    public CMSSignerInfo getSignerInfo() throws TSPException {
        if (this.timeStampToken != null || (this.timeStampToken = this.generateTimeStampToken()) != null) {
            return (CMSSignerInfo)this.timeStampToken.signers().nextElement();
        }
        return null;
    }

    public X509Certificate getSignerCert() {
        return this.signerCert;
    }

    public void setSigningParameters(PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgId, AlgorithmIdentifier digestEncryptionAlgId, AttributeSet authenticatedAttributes, AttributeSet unauthenticatedAttributes, boolean useSPKI6) {
        this.signerKey = signerKey;
        this.signerCert = signerCert;
        this.digestAlgId = digestAlgId;
        this.digestEncryptionAlgId = digestEncryptionAlgId;
        this.authenticatedAttributes = authenticatedAttributes;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
        this.useSPKI64 = this.useSPKI64;
        this.updateTimeStampToken();
    }

    @Override
    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public CMSSignedDataContentInfo getTimeStampToken() {
        if (this.timeStampToken == null) {
            this.timeStampToken = this.generateTimeStampToken();
        }
        return this.timeStampToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TSPTimeStampResp tsr = (TSPTimeStampResp)o;
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)tsr));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("status = ");
        sb.append(this.status != null ? this.status.toString() : "null");
        sb.append(", ");
        sb.append("timeStampToken = ");
        sb.append(this.timeStampToken != null ? this.timeStampToken.toString() : "null");
        return sb.toString();
    }

    @Override
    protected void parseMessage(byte[] data) throws IOException {
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)new UnsyncByteArrayInputStream(data));
        this.status = new PKIStatusInfo((InputStream)sis);
        if (sis.available() > 0) {
            int size;
            this.timeStampToken = new CMSSignedDataContentInfo((InputStream)sis);
            this.tstInfo = new TSTInfo(Utils.toStream((Streamable)this.timeStampToken.getEnclosed()));
            try {
                this.messageImprint = new MessageImprint(this.tstInfo.getMessageImprintHashAlgID(), this.tstInfo.getMessageImprintHashMsg(), false);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new TSPFormatException(ex);
            }
            Vector certs = this.timeStampToken.getCertificates();
            if (certs != null && (size = certs.size()) > 0) {
                for (int i = 0; i < size; ++i) {
                    X509Certificate cert = (X509Certificate)certs.elementAt(i);
                    try {
                        if (this.timeStampToken.getSignerInfo(cert) == null) continue;
                        this.signerCert = cert;
                        this.includeCert = true;
                        break;
                    }
                    catch (NoSuchAlgorithmException ex) {
                        throw new TSPFormatException(ex);
                    }
                    catch (CertificateEncodingException ex) {
                        throw new TSPFormatException(ex);
                    }
                    catch (SignatureException ex) {
                        // empty catch block
                    }
                }
            }
            CMSSignerInfo si = (CMSSignerInfo)this.timeStampToken.signers().nextElement();
            this.digestAlgId = si.getDigestAlgID();
            this.digestEncryptionAlgId = si.getDigestEncryptionAlgID();
            this.authenticatedAttributes = si.getSignedAttributes();
            this.unauthenticatedAttributes = si.getUnsignedAttributes();
            this.useSPKI64 = si.isSPKI();
        }
        this.cache = (byte[])data.clone();
    }

    @Override
    protected byte[] getEncoded() throws IOException {
        if (this.cache != null) {
            return (byte[])this.cache.clone();
        }
        ASN1Sequence seq = new ASN1Sequence();
        if (this.status == null) {
            throw new TSPFormatException("status field not set");
        }
        seq.addElement((ASN1Object)this.status);
        try {
            if (this.timeStampToken != null || (this.timeStampToken = this.generateTimeStampToken()) != null) {
                seq.addElement((ASN1Object)this.timeStampToken);
            }
        }
        catch (TSPException ex) {
            throw new IOException(ex.getMessage());
        }
        this.cache = Utils.toBytes((Streamable)seq);
        return (byte[])this.cache.clone();
    }

    private void update() {
        this.cache = null;
    }

    private void updateTimeStampToken() {
        this.timeStampToken = null;
    }

    private CMSSignedDataContentInfo generateTimeStampToken() throws TSPException {
        CMSSignedDataContentInfo sdci;
        if (this.tstInfo == null) {
            this.includeCert = false;
            return null;
        }
        try {
            sdci = new CMSSignedDataContentInfo((CMSContentInfo)this.tstInfo);
            sdci.addSignature(this.authenticatedAttributes, this.signerKey, this.signerCert, this.digestAlgId, this.digestEncryptionAlgId, this.unauthenticatedAttributes, this.useSPKI64);
            if (this.includeCert) {
                sdci.addCertificate(this.signerCert);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TSPException("Digest algorithm not supported");
        }
        catch (InvalidKeyException ex) {
            throw new TSPException("Private key is not valid");
        }
        catch (SignatureException ex) {
            throw new TSPException("Signature algorithm not supported");
        }
        return sdci;
    }
}

