/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.tsp;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URLConnection;
import oracle.security.crypto.tsp.TSPTimeStampReq;
import oracle.security.crypto.tsp.TSPTimeStampResp;

public class TSPContentHandlerFactory
implements ContentHandlerFactory {
    @Override
    public ContentHandler createContentHandler(String mimetype) {
        if (mimetype.equals("application/timestamp-query")) {
            return new TSPRequestContentHandler();
        }
        if (mimetype.equals("application/timestamp-reply")) {
            return new TSPResponseContentHandler();
        }
        return null;
    }

    static class TSPRequestContentHandler
    extends ContentHandler {
        TSPRequestContentHandler() {
        }

        @Override
        public Object getContent(URLConnection urlc) throws IOException {
            return new TSPTimeStampReq(urlc.getInputStream());
        }
    }

    static class TSPResponseContentHandler
    extends ContentHandler {
        TSPResponseContentHandler() {
        }

        @Override
        public Object getContent(URLConnection urlc) throws IOException {
            return new TSPTimeStampResp(urlc.getInputStream());
        }
    }
}

