/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.tsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class TSAPolicyID
implements ASN1Object {
    private ASN1ObjectID id;

    public TSAPolicyID(InputStream is) throws IOException {
        this.input(is);
    }

    public TSAPolicyID(ASN1ObjectID id) throws IOException {
        this.id = id;
    }

    public void output(OutputStream os) throws IOException {
        this.id.output(os);
    }

    public void input(InputStream is) throws IOException {
        this.id = new ASN1ObjectID(is);
    }

    public int length() {
        try {
            return this.id.length();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public ASN1ObjectID getID() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TSAPolicyID pid = (TSAPolicyID)o;
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)pid));
    }

    public String toString() {
        return this.id.toString();
    }
}

