/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.tsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.tsp.TSPFormatException;
import oracle.security.crypto.tsp.TSPUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class MessageImprint
implements ASN1Object {
    private AlgorithmIdentifier hashAlgorithm;
    private byte[] hashedMessage;
    private ASN1Sequence cache;

    public MessageImprint(AlgorithmIdentifier alg, byte[] message, boolean hashMessage) throws NoSuchAlgorithmException {
        this.hashAlgorithm = alg;
        this.hashedMessage = hashMessage ? this.getHash(message) : (byte[])message.clone();
    }

    public MessageImprint(InputStream is) throws IOException {
        this.input(is);
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public void input(InputStream is) throws IOException {
        ASN1Sequence cache = new ASN1Sequence(is);
        if (cache.size() != 2) {
            throw new TSPFormatException("Invalid format for messageImprint field");
        }
        this.hashAlgorithm = new AlgorithmIdentifier((ASN1Sequence)cache.elementAt(0));
        this.hashedMessage = ((ASN1OctetString)cache.elementAt(1)).getValue();
    }

    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getHashedMessage() {
        return (byte[])this.hashedMessage.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MessageImprint mi = (MessageImprint)o;
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)mi));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ hashAlgorithm = ");
        sb.append(this.hashAlgorithm);
        sb.append(", hashedMessage = ");
        sb.append(Utils.toHexString((byte[])this.hashedMessage));
        sb.append(" }");
        return sb.toString();
    }

    private ASN1Sequence toASN1Sequence() throws IOException {
        if (this.cache != null) {
            return this.cache;
        }
        ASN1Sequence seq = new ASN1Sequence();
        if (this.hashAlgorithm == null) {
            throw new TSPFormatException("hashAlgorithm field not set");
        }
        seq.addElement((ASN1Object)this.hashAlgorithm);
        if (this.hashedMessage == null) {
            throw new TSPFormatException("hashedMessage field not set");
        }
        seq.addElement((ASN1Object)new ASN1OctetString(this.hashedMessage));
        this.cache = seq;
        return seq;
    }

    private byte[] getHash(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(TSPUtils.getAlgoName(this.hashAlgorithm));
        return md.digest(data);
    }

    private void update() {
        this.cache = null;
    }
}

