/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.tsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownServiceException;
import oracle.security.crypto.tsp.InvalidHttpRequestException;
import oracle.security.crypto.tsp.TSPTimeStampReq;
import oracle.security.crypto.tsp.TSPTimeStampResp;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class HttpTSPRequest {
    private TSPTimeStampReq request;
    private URL url;

    public HttpTSPRequest(TSPTimeStampReq request, URL url) {
        this.url = url;
        this.request = request;
    }

    public HttpTSPRequest(InputStream is) throws IOException {
        String str = this.readLine(is);
        if (str.startsWith("POST /")) {
            boolean contentTypeVerified = false;
            while (!str.equals("")) {
                str = this.readLine(is);
                if (!str.toLowerCase().startsWith("content-type")) continue;
                String contType = str.substring("content-type: ".length());
                if (!contType.equalsIgnoreCase("application/timestamp-query")) {
                    throw new InvalidHttpRequestException("Expected content type 'application/timestamp-query', got '" + contType + "'");
                }
                contentTypeVerified = true;
            }
            if (!contentTypeVerified) {
                throw new InvalidHttpRequestException("Content-Type missing");
            }
        } else {
            throw new InvalidHttpRequestException("HTTP request method not supported");
        }
        this.request = new TSPTimeStampReq(is);
    }

    public static TSPTimeStampResp getResponse(TSPTimeStampReq request, HttpURLConnection conn) throws IOException {
        HttpTSPRequest.sendRequest(request, conn);
        if (conn.getContentType().equalsIgnoreCase("application/timestamp-reply")) {
            Object obj = conn.getContent();
            if (obj instanceof InputStream) {
                return new TSPTimeStampResp((InputStream)obj);
            }
            if (obj instanceof TSPTimeStampResp) {
                return (TSPTimeStampResp)obj;
            }
            throw new UnknownServiceException("TSPTimeStampResp expected");
        }
        return null;
    }

    public TSPTimeStampResp getResponse() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        HttpTSPRequest.sendRequest(this.request, conn);
        if (conn.getContentType().equalsIgnoreCase("application/timestamp-reply")) {
            return (TSPTimeStampResp)conn.getContent();
        }
        return null;
    }

    public TSPTimeStampReq getRequest() {
        return this.request;
    }

    private static void sendRequest(TSPTimeStampReq request, HttpURLConnection conn) throws IOException {
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/timestamp-query");
        conn.setRequestProperty("Content-Length", String.valueOf(request.length()));
        OutputStream os = conn.getOutputStream();
        os.write(Utils.toBytes((Streamable)request));
        os.flush();
        os.close();
        conn.getInputStream();
    }

    private String readLine(InputStream is) throws IOException {
        byte[] buf = new byte[1];
        String s = new String();
        while (is.read(buf) != -1) {
            if (!(s = s + new String(buf)).endsWith("\r\n")) continue;
            return s.substring(0, s.length() - 2);
        }
        return s;
    }
}

