/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy.driver.oracle;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.raptor.proxy.AbstractProxy;
import oracle.dbtools.raptor.proxy.ProxyContext;
import oracle.dbtools.raptor.proxy.driver.RaptorProxyJDBCBase;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

@ProxyFor(value={ResultSet.class, oracle.jdbc.OracleResultSet.class, OracleResultSet.class})
public abstract class RaptorProxyOJDBCResultSet
extends RaptorProxyJDBCBase {
    private static AbstractProxy.DelegateCloser closer = new ResultSetCloser();

    protected RaptorProxyOJDBCResultSet() {
        this(new ProxyContext("r"));
    }

    @Override
    protected AbstractProxy.DelegateCloser getDelegateCloser() {
        return closer;
    }

    protected RaptorProxyOJDBCResultSet(ProxyContext proxyContext) {
        super(proxyContext);
        this.thisProxyNameInLog = "RSET" + this.thisProxyNameInLog;
    }

    @Pre
    @Methods(signatures={@Signature(name="close", args={})})
    protected void preFor_close(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postFor_close(Method method) {
        this.getProxyContext().explicitCloseCalled();
        this.postForAll(method);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onSQLException_close(Method method, SQLException sQLException) throws SQLException {
        this.onSQLExceptionVoidForAll(method, sQLException);
    }

    @OnError(value=RuntimeException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onRuntimeException_close(Method method, RuntimeException runtimeException) throws RuntimeException {
        this.onRuntimeExceptionVoidForAll(method, runtimeException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    protected static class ResultSetCloser
    implements AbstractProxy.DelegateCloser {
        protected ResultSetCloser() {
        }

        @Override
        public void close(ProxyContext proxyContext, Object object) {
            if (object instanceof ResultSet) {
                ResultSet resultSet = (ResultSet)object;
                try {
                    if (!resultSet.isClosed()) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

