/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.filenav.FileNavigatorResources;
import oracle.dbtools.raptor.filenav.RecentFilesTracker;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;

class RecentFilesFolder
extends DefaultElement
implements Subject {
    private static final Logger LOGGER = Logger.getLogger(RecentFilesFolder.class.getName());
    private List<Element> m_children;
    private IdeSubject m_subject = new IdeSubject();

    RecentFilesFolder() {
    }

    private void addChildren(List<URL> list) {
        this.initChildren();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (URL uRL : list) {
            Node node = this.getNode(uRL, true);
            if (node == null) continue;
            arrayList.add(node);
        }
        if (!arrayList.isEmpty()) {
            this.m_children.addAll(arrayList);
            UpdateMessage.fireChildrenAdded((Subject)this, arrayList);
        }
    }

    public void attach(Observer observer) {
        this.m_subject.attach(observer);
    }

    public void detach(Observer observer) {
        this.m_subject.detach(observer);
    }

    public Iterator<Element> getChildren() {
        this.initChildren();
        return this.m_children.iterator();
    }

    public Icon getIcon() {
        return RaptorImagesArb.getIcon((String)"FILES");
    }

    private Node getNode(URL uRL, boolean bl) {
        Node node = null;
        try {
            node = bl ? NodeFactory.findOrCreate((URL)uRL) : NodeFactory.find((URL)uRL);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.SEVERE, illegalAccessException.getLocalizedMessage());
        }
        catch (InstantiationException instantiationException) {
            LOGGER.log(Level.SEVERE, instantiationException.getLocalizedMessage());
        }
        return node;
    }

    public String getShortLabel() {
        return FileNavigatorResources.getString("RECENT_FILES_LABEL");
    }

    private void initChildren() {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Element>();
            RecentFilesTracker recentFilesTracker = RecentFilesTracker.getInstance();
            for (URL uRL : recentFilesTracker.getRecentFiles()) {
                Node node;
                if (!URLFileSystem.exists((URL)uRL) || (node = this.getNode(uRL, true)) == null) continue;
                this.m_children.add((Element)node);
            }
            recentFilesTracker.attach(new O());
        }
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.m_subject.notifyObservers(object, updateMessage);
    }

    private void removeChildren(List<URL> list) {
        this.initChildren();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (URL uRL : list) {
            Node node = this.getNode(uRL, false);
            if (node == null || !this.m_children.remove(node)) continue;
            arrayList.add(node);
        }
        if (!arrayList.isEmpty()) {
            UpdateMessage.fireChildrenRemoved((Subject)this, arrayList);
        }
    }

    boolean hasChildren() {
        this.initChildren();
        return !this.m_children.isEmpty();
    }

    private class O
    implements Observer {
        private O() {
        }

        public void update(Object object, UpdateMessage updateMessage) {
            int n = updateMessage.getMessageID();
            if (n == RecentFilesTracker.URL_ADDED) {
                List list = updateMessage.getAddObjects();
                RecentFilesFolder.this.addChildren(list);
            } else if (n == RecentFilesTracker.URL_REMOVED) {
                List list = updateMessage.getRemoveObjects();
                RecentFilesFolder.this.removeChildren(list);
            }
        }
    }
}

