/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import oracle.dbtools.raptor.filenav.FileNavigatorManager;
import oracle.dbtools.raptor.filenav.FileNavigatorResources;
import oracle.dbtools.raptor.filenav.FileNavigatorWindow;
import oracle.dbtools.raptor.filenav.RecentFilesFolder;
import oracle.dbtools.raptor.filenav.RecentFilesTracker;
import oracle.dbtools.raptor.filenav.dialogs.FileSelectionPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;

public final class FileNavigatorContextMenuListener
implements ContextMenuListener {
    private static final String CLEAR_RFL = "FileNavigator.CLEAR_RFL";
    public static final int CLEAR_RFL_ID = Ide.findCmdID((String)"FileNavigator.CLEAR_RFL");
    private static final String REMOVE_FROM_RFL = "FileNavigator.REMOVE_FROM_RFL";
    public static final int REMOVE_FROM_RFL_ID = Ide.findCmdID((String)"FileNavigator.REMOVE_FROM_RFL");
    private static final String STAMP_SQL = "FileNavigator.StampSQL";
    public static final int STAMP_SQL_ID = Ide.findOrCreateCmdID((String)"FileNavigator.StampSQL");
    private static final String OBFUSCATE = "FileNavigator.Obfuscate";
    public static final int OBFUSCATE_ID = Ide.findOrCreateCmdID((String)"FileNavigator.Obfuscate");
    private static final String SQL_PATROLLER = "FileNavigator.SQLPatroller";
    public static final int SQL_PATROLLER_ID = Ide.findOrCreateCmdID((String)"FileNavigator.SQLPatroller");

    public boolean handleDefaultAction(Context context) {
        for (ContextMenuListener contextMenuListener : FileNavigatorContextMenuListener.getVCSContextMenuListeners()) {
            if (!contextMenuListener.handleDefaultAction(context)) continue;
            return true;
        }
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
        for (ContextMenuListener contextMenuListener : FileNavigatorContextMenuListener.getVCSContextMenuListeners()) {
            contextMenuListener.menuWillHide(contextMenu);
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (FileNavigatorManager.isFileNavigatorContext(context)) {
            for (ContextMenuListener contextMenuListener : FileNavigatorContextMenuListener.getVCSContextMenuListeners()) {
                contextMenuListener.menuWillShow(contextMenu);
            }
            ContextMenuListener[] contextMenuListenerArray = context.getSelection();
            if (contextMenuListenerArray != null) {
                if (contextMenuListenerArray.length == 1 && contextMenuListenerArray[0] instanceof RecentFilesFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)CLEAR_RFL_ID), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT));
                } else {
                    TNode tNode = ExplorerContext.getFirstTNode((Context)context);
                    if (tNode != null && tNode.getAncestor(RecentFilesFolder.class) != null) {
                        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)REMOVE_FROM_RFL_ID), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT));
                    }
                }
            }
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)STAMP_SQL_ID), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT));
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)OBFUSCATE_ID), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT));
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)SQL_PATROLLER_ID), JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT));
        }
    }

    private static ContextMenuListener[] getVCSContextMenuListeners() {
        return VCSManager.getVCSManager().getContextMenuListeners();
    }

    public static class Controller
    implements oracle.ide.controller.Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            boolean bl = false;
            int n = ideAction.getCommandId();
            if (n == CLEAR_RFL_ID) {
                bl = true;
                if (MessageDialog.confirm((Component)context.getView().getGUI(), (Object)FileNavigatorResources.getString("CLEAR_RECENT_FILES_TEXT"), (String)FileNavigatorResources.getString("CLEAR_RECENT_FILES"), null)) {
                    RecentFilesTracker.RecentFilesCache.getCache().clearList();
                }
            } else if (n == REMOVE_FROM_RFL_ID) {
                bl = true;
                Element[] elementArray = context.getSelection();
                if (elementArray != null && elementArray.length > 0) {
                    URL[] uRLArray = new URL[elementArray.length];
                    for (int i = elementArray.length - 1; i >= 0; --i) {
                        uRLArray[i] = ((Locatable)elementArray[i]).getURL();
                    }
                    RecentFilesTracker.RecentFilesCache.getCache().removeFiles(uRLArray);
                }
            } else if (n == STAMP_SQL_ID || n == OBFUSCATE_ID || n == SQL_PATROLLER_ID) {
                bl = true;
                Element element = context.getElement();
                URL uRL = ((Locatable)element).getURL();
                File file = new File(uRL.getFile());
                if (!file.exists()) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Specified directory does not exist.", (String)"Something Wrong", null);
                } else {
                    new FileSelectionPanel(file, n).showDialog();
                }
            }
            return bl;
        }

        public boolean update(IdeAction ideAction, Context context) {
            View view = context.getView();
            if (view instanceof FileNavigatorWindow) {
                int n = ideAction.getCommandId();
                if (n == 51) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 20) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (n == CLEAR_RFL_ID) {
                    Element element = context.getElement();
                    ideAction.setEnabled(element instanceof RecentFilesFolder && ((RecentFilesFolder)element).hasChildren());
                    return true;
                }
                if (n == STAMP_SQL_ID) {
                    Element element = context.getElement();
                    ideAction.setEnabled(element instanceof Locatable);
                    return true;
                }
                if (n == OBFUSCATE_ID) {
                    Element element = context.getElement();
                    ideAction.setEnabled(element instanceof Locatable);
                    return true;
                }
                if (n == SQL_PATROLLER_ID) {
                    Element element = context.getElement();
                    ideAction.setEnabled(element instanceof Locatable);
                    return true;
                }
            }
            return false;
        }
    }
}

