/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.filenav.DirectoryFolder;
import oracle.dbtools.raptor.filenav.FileNavigatorResources;
import oracle.dbtools.raptor.filenav.Messages;
import oracle.dbtools.raptor.filenav.NavRoot;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.javatools.icons.OracleIcons;

public class DirectoryFilter
extends BaseRaptorFilter {
    private static final Element LOADING_ELEMENT = new DefaultElement(){

        public String getShortLabel() {
            return FileNavigatorResources.getString("LOADING_LABEL");
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"folder.png");
        }
    };
    private List<Element> m_children;

    public void closeChildren() {
        this.m_children = null;
    }

    public Iterator getChildren() {
        if (this.m_children == null) {
            this.m_children = this.loadChildren();
        }
        return this.m_children.iterator();
    }

    protected Object getKey(Object object) {
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        if (object == LOADING_ELEMENT) {
            return LOADING_ELEMENT.getShortLabel();
        }
        return null;
    }

    private List<Element> loadChildren() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        TNode tNode = this.getOwner();
        final Workspace workspace = DirectoryFilter.getOwningProject(tNode);
        final DirectoryFolder directoryFolder = (DirectoryFolder)tNode.getData();
        DirectoryFolder.NodeState nodeState = directoryFolder.getState();
        if (nodeState == DirectoryFolder.NodeState.OPEN) {
            Iterator iterator = directoryFolder.getChildren();
            while (iterator.hasNext()) {
                arrayList.add((Element)iterator.next());
            }
        } else {
            arrayList.add(LOADING_ELEMENT);
            if (nodeState == DirectoryFolder.NodeState.CLOSED) {
                RaptorTask<List<Element>> raptorTask = new RaptorTask<List<Element>>(Messages.getString("DirectoryFilter.0"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

                    protected List<Element> doWork() {
                        ArrayList<Element> arrayList = null;
                        if (workspace != null && directoryFolder.open(workspace)) {
                            arrayList = new ArrayList<Element>();
                            Iterator iterator = directoryFolder.getChildren();
                            while (iterator.hasNext()) {
                                arrayList.add((Element)iterator.next());
                            }
                        }
                        return arrayList;
                    }
                };
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask, directoryFolder){
                    final /* synthetic */ RaptorTask val$task;
                    final /* synthetic */ DirectoryFolder val$df;
                    {
                        this.val$task = raptorTask;
                        this.val$df = directoryFolder;
                    }

                    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                        super.taskCancelled(raptorTaskEvent);
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        super.taskFailed(raptorTaskEvent);
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        try {
                            List list = (List)this.val$task.getResult();
                            if (list != null) {
                                UpdateMessage.fireChildRemoved((Subject)this.val$df, (Element)LOADING_ELEMENT);
                                UpdateMessage.fireChildrenAdded((Subject)this.val$df, (Collection)list);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                        }
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            }
        }
        return arrayList;
    }

    private static Workspace getOwningProject(TNode tNode) {
        NavRoot navRoot = (NavRoot)tNode.getAncestor(NavRoot.class);
        return navRoot != null ? navRoot.getWorkspace() : null;
    }

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
            if (this.m_children == null) continue;
            this.m_children.add(element);
        }
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            TNode tNode2 = this.lookup(element);
            if (tNode2 != null) {
                treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
                this.uncache(tNode2);
            }
            if (this.m_children == null) continue;
            this.m_children.remove(element);
        }
        return tNode;
    }
}

