/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDListModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.AssociativeLink;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MnemonicUtils;

public class ALinkPopup
extends JDialog
implements ActionListener,
MouseListener {
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String ALINK_POPUP_TITLE = "topicDisplay.aLinkPopup.title";
    private static String ALINK_POPUP_PROMPT = "topicDisplay.aLinkPopup.prompt";
    private static String ALINK_POPUP_DISPLAY = "topicDisplay.aLinkPopup.display";
    private static String ALINK_POPUP_CANCEL = "topicDisplay.aLinkPopup.cancel";
    private static String ALINK_POPUP_NOTOPICS = "topicDisplay.aLinkPopup.notopics";
    private Topic _selectedTopic;
    private String _noTopicsString;
    private JButton _cancelButton;
    private JButton _displayButton;
    private JList _list;
    private ArrayOneDModel _dataModel;

    public ALinkPopup(AssociativeLink link, Point location, Component over) {
        super(WindowUtils.parentFrame((Component)over), true);
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this.setTitle(bundle.getString(ALINK_POPUP_TITLE));
        this._noTopicsString = bundle.getString(ALINK_POPUP_NOTOPICS);
        this._selectedTopic = null;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel dialogContents = new JPanel();
        dialogContents.setBorder(new EmptyBorder(8, 8, 8, 8));
        dialogContents.setLayout(new BorderLayout(10, 10));
        this._createDataSource(link);
        this._list = new JList(new OneDListModel((OneDModel)this._dataModel));
        this._list.setVisibleRowCount(4);
        this._list.addMouseListener(this);
        this._list.setSelectedIndex(0);
        JScrollPane scrollingList = new JScrollPane(this._list);
        dialogContents.add((Component)scrollingList, "Center");
        JLabel promptLabel = MnemonicUtils.createLabel(bundle.getString(ALINK_POPUP_PROMPT), this._list);
        dialogContents.add((Component)promptLabel, "North");
        DialogButtonBar south = new DialogButtonBar();
        this._displayButton = MnemonicUtils.createButton(bundle.getString(ALINK_POPUP_DISPLAY));
        this._displayButton.addActionListener(this);
        south.add((Component)this._displayButton);
        this._cancelButton = MnemonicUtils.createButton(bundle.getString(ALINK_POPUP_CANCEL));
        this._cancelButton.addActionListener(this);
        south.add((Component)this._cancelButton);
        dialogContents.add((Component)south, "South");
        this.getContentPane().add((Component)dialogContents, "Center");
        this.addWindowListener(WindowUtils.getWindowCloser());
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)over);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            this.setVisible(false);
            if (e.getSource() == this._displayButton || e.getSource() == this._list) {
                ALinkListItem anItem = null;
                int selectedIndex = this._list.getSelectedIndex();
                if (selectedIndex != -1) {
                    anItem = (ALinkListItem)this._dataModel.getData(selectedIndex);
                }
                this._selectedTopic = anItem != null ? anItem.getTopic() : null;
            } else if (e.getSource() == this._cancelButton) {
                this._selectedTopic = null;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int item;
        if (e.getSource() == this._list && e.getClickCount() == 2 && (item = this._list.locationToIndex(e.getPoint())) != -1) {
            this.actionPerformed(new ActionEvent(this._list, 1001, "LIST"));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public Topic getSelectedTopic() {
        return this._selectedTopic;
    }

    private void _createDataSource(AssociativeLink aLink) {
        Topic[] linkTopics;
        ArrayList<ALinkListItem> dataSourceItems = new ArrayList<ALinkListItem>();
        if (aLink != null && (linkTopics = aLink.getTopics()) != null) {
            for (int iter = 0; iter < linkTopics.length; ++iter) {
                Topic aTopic = linkTopics[iter];
                ALinkListItem anItem = new ALinkListItem(aTopic.getLabel(), aTopic);
                dataSourceItems.add(anItem);
            }
        }
        if (dataSourceItems.size() == 0) {
            ALinkListItem anItem = new ALinkListItem(this._noTopicsString, null);
            dataSourceItems.add(anItem);
            this._displayButton.setEnabled(false);
        }
        Object[] itemArr = new ALinkListItem[dataSourceItems.size()];
        dataSourceItems.toArray(itemArr);
        this._dataModel = new ArrayOneDModel(itemArr);
    }

    private class ALinkListItem {
        private String _label;
        private Topic _topic;

        public ALinkListItem(String label, Topic topic) {
            this._label = label;
            this._topic = topic;
        }

        public String getLabel() {
            return this._label;
        }

        public Topic getTopic() {
            return this._topic;
        }

        public String toString() {
            return this._label;
        }
    }
}

