/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.keywordNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDListModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.TopicBaseBean;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MnemonicUtils;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.keywordNavigator.KeywordIndexItemAdapter;
import oracle.help.navigator.keywordNavigator.KeywordModelAdapter;

public class KeywordNavigator
extends LazyNavigator
implements ListSelectionListener,
DocumentListener,
ActionListener {
    private static int BORDER_SIZE = 8;
    private static int SPACE_SIZE = BORDER_SIZE / 2;
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    private static String TYPE_KEYWORD_NAVIGATOR = "oracle.help.navigator.keywordNavigator.KeywordNavigator";
    private static String DEFAULT_LABEL_ID = "navigator.keywordNavigator.default_label";
    private static String LABEL_INSTRUCTION = "navigator.keywordNavigator.instruct";
    private static String LABEL_SELECT = "navigator.keywordNavigator.select";
    private static String BUTTON_OPEN = "navigator.keywordNavigator.open";
    private static String PROTOTYPE_CELL = "This is a long index item";
    private JTextField _typeField;
    private JList _topicList;
    private JButton _openButton;
    private KeywordModelAdapter _keywordAdapter;
    private int _syncingListWithText;
    private int _syncingTextWithList;
    private KeywordIndexItemAdapter _currentIndexItem = new KeywordIndexItemAdapter();
    private SpreadTable _entryTable;
    private EntryTableSelectionListener _selectionListener;
    private static String WORD_LIST_SEPARATOR = "navigator.keywordNavigator.wordListSeparator";
    private boolean _showOpenButton = true;

    public Topic getCurrentSelection() {
        if (this._selectionListener != null) {
            return this._selectionListener.getSelectedTopic();
        }
        return null;
    }

    public String getDefaultLabel() {
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String defaultLabel = bundle.getString(DEFAULT_LABEL_ID);
        return defaultLabel;
    }

    public void showOpenButton(boolean visible) {
        this._showOpenButton = visible;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this._syncingTextWithList == 0) {
            this._syncListWithTextField();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this._syncingTextWithList == 0) {
            this._syncListWithTextField();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this._syncingTextWithList == 0) {
            this._syncListWithTextField();
        }
    }

    private void _syncListWithTextField() {
        int closest;
        ++this._syncingListWithText;
        String searchLabel = this._typeField.getText();
        if (searchLabel != null && this._keywordAdapter.getItemCount() > 0 && (closest = this._keywordAdapter.findClosestKeywordIndexItem(searchLabel)) != -1) {
            int numVisible = this._topicList.getLastVisibleIndex() - this._topicList.getFirstVisibleIndex();
            this._topicList.ensureIndexIsVisible(closest + numVisible - 1);
            this._topicList.ensureIndexIsVisible(closest);
            this._topicList.setSelectedIndex(closest);
            this._currentIndexItem.setCurrentKeywordIndexItem(this._keywordAdapter.getKeywordIndexItemForIndex(closest));
        }
        --this._syncingListWithText;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._syncingListWithText == 0) {
            ++this._syncingTextWithList;
            int selIndex = this._topicList.getSelectedIndex();
            this._currentIndexItem.setCurrentKeywordIndexItem(this._keywordAdapter.getKeywordIndexItemForIndex(selIndex));
            this._typeField.setText(this._currentIndexItem.getKeywordIndexItem().getSortingText());
            --this._syncingTextWithList;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Topic selectedTopic;
        if (e != null && e.getSource() == this._openButton && (selectedTopic = this._selectionListener.getSelectedTopic()) != null) {
            this._fireTopicActivated(selectedTopic);
        }
    }

    @Override
    protected void addViewNow(View view) {
        if (view != null && view.getType().equals(TYPE_KEYWORD_NAVIGATOR)) {
            this._keywordAdapter.addView(view);
        }
    }

    @Override
    protected void removeViewNow(View view) {
        if (view != null && view.getType().equals(TYPE_KEYWORD_NAVIGATOR)) {
            this._keywordAdapter.removeView(view);
            this._currentIndexItem.setCurrentKeywordIndexItem(null);
        }
    }

    @Override
    protected void doInitializationNow() {
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String wordSeperator = bundle.getString(WORD_LIST_SEPARATOR);
        this._keywordAdapter = new KeywordModelAdapter(this.getInitialViewsArray(), wordSeperator);
        this._currentIndexItem.addModelListener((TwoDModelListener)new EntryTableDataListener());
        this.setLayout(new BorderLayout(0, 8));
        this.setBorder(new EmptyBorder(BORDER_SIZE, BORDER_SIZE, BORDER_SIZE, BORDER_SIZE));
        this._typeField = new JTextField();
        this._typeField.getDocument().addDocumentListener(this);
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new GridLayout(2, 1, 0, SPACE_SIZE));
        JLabel label = MnemonicUtils.createLabel(bundle.getString(LABEL_INSTRUCTION), this._typeField);
        northPanel.add((Component)label, (Object)this._typeField);
        northPanel.add(this._typeField);
        this.add((Component)northPanel, "North");
        this._topicList = new JList(new OneDListModel((OneDModel)this._keywordAdapter));
        this._topicList.getAccessibleContext().setAccessibleName(this.getDefaultLabel());
        this._topicList.setPrototypeCellValue(PROTOTYPE_CELL);
        this._topicList.addListSelectionListener(this);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() > 1 && (index = KeywordNavigator.this._topicList.locationToIndex(e.getPoint())) != -1) {
                    KeywordNavigator.this._topicList.setSelectedIndex(index);
                    Topic firstTopic = KeywordNavigator.this._currentIndexItem.getKeywordIndexItem().getTopic();
                    if (firstTopic != null) {
                        KeywordNavigator.this._fireTopicActivated(firstTopic);
                    }
                }
            }
        };
        this._topicList.addMouseListener(mouseListener);
        JScrollPane scrollPane = new JScrollPane(this._topicList);
        this.add((Component)scrollPane, "Center");
        JPanel southPanel = new JPanel();
        JComponent entryTableComponent = this._createEntryTableComponent(bundle);
        southPanel.setLayout(new BorderLayout(0, BORDER_SIZE));
        southPanel.add((Component)MnemonicUtils.createLabel(bundle.getString(LABEL_SELECT), (Component)this._entryTable), "North");
        southPanel.add((Component)entryTableComponent, "Center");
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BorderLayout());
        this._openButton = MnemonicUtils.createButton(bundle.getString(BUTTON_OPEN));
        this._openButton.addActionListener(this);
        this._openButton.setEnabled(false);
        if (this._showOpenButton) {
            subPanel.add((Component)this._openButton, "East");
        }
        southPanel.add((Component)subPanel, "South");
        this.add((Component)southPanel, "South");
        this._syncingListWithText = 0;
        this._syncingTextWithList = 0;
        this.validate();
    }

    private JComponent _createEntryTableComponent(ResourceBundle bundle) {
        Object[] items = new String[]{bundle.getString("navigator.keywordNavigator.topictitle"), bundle.getString("navigator.keywordNavigator.source")};
        ArrayOneDModel headerDs = new ArrayOneDModel(items);
        this._entryTable = new SpreadTable((TwoDModel)this._currentIndexItem, (OneDModel)headerDs, null);
        this._entryTable.setHorizontalSeparatorsVisible(false);
        this._entryTable.setVerticalSeparatorsVisible(false);
        this._entryTable.setScrollByRow(true);
        Header header = this._entryTable.getColumnHeader();
        header.setCanMoveItems(false);
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)this._currentIndexItem);
        Grid grid = this._entryTable.getGrid();
        grid.setGridSelectionManager(GeneralGridSelectionManager.createSingleRowSelectionManager());
        grid.setPreferredRowsOnScreen(3);
        grid.setColumnPainter(0, (Painter)new TextPainter());
        grid.setColumnPainter(1, (Painter)new TextPainter());
        grid.setDefaultInputHandler((CellInputHandler)new EntryTableInputHandler());
        TableResizer resizeListener = new TableResizer();
        this._entryTable.addResizeListener((TableResizeListener)resizeListener);
        this._entryTable.setColumnWidth(0, 250);
        this._entryTable.setColumnWidth(1, 100);
        this._selectionListener = new EntryTableSelectionListener();
        this._entryTable.addPropertyChangeListener((PropertyChangeListener)this._selectionListener);
        JScrollPane component = new JScrollPane((Component)this._entryTable, 22, 31);
        component.addComponentListener(resizeListener);
        return component;
    }

    private void _fireTopicActivated(Topic topic) {
        NavigatorEvent e = new NavigatorEvent(this, 2001, topic, 1);
        this.fireNavigatorEvent(e);
    }

    private void _fireTopicSelected(Topic topic) {
        NavigatorEvent e = new NavigatorEvent(this, 2000, topic);
        this.fireNavigatorEvent(e);
    }

    private class EntryTableInputHandler
    extends CellInputHandler {
        public void mouseClicked(MouseEvent e, Grid grid, int column, int row) {
            if (e.getClickCount() > 1) {
                ActionEvent event = new ActionEvent(KeywordNavigator.this._openButton, 1001, "");
                KeywordNavigator.this.actionPerformed(event);
            }
            super.mouseClicked(e, grid, column, row);
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int column, int row) {
            if (keyEvent != null) {
                if (keyEvent.getKeyCode() == 10) {
                    ActionEvent event = new ActionEvent(KeywordNavigator.this._openButton, 1001, "");
                    KeywordNavigator.this.actionPerformed(event);
                    keyEvent.consume();
                }
                super.keyPressed(keyEvent, grid, column, row);
            }
        }
    }

    private class EntryTableDataListener
    extends TwoDModelAdapter {
        private EntryTableDataListener() {
        }

        public void rowsRemoved(TwoDModelEvent e) {
            if (e != null) {
                int currentSel = KeywordNavigator.this._selectionListener.getSelectedRowIndex();
                int start = e.getRowStartIndex();
                int count = e.getRowCount();
                if (start <= currentSel && start + count > currentSel) {
                    KeywordNavigator.this._selectionListener.clearSelection();
                }
            }
        }
    }

    private class EntryTableSelectionListener
    implements PropertyChangeListener {
        private int _selectedRow = -1;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt != null && evt.getPropertyName() == "selection") {
                TwoDSelection newSel = KeywordNavigator.this._entryTable.getSelection();
                this._selectedRow = newSel != null ? newSel.getSingleRow() : -1;
                if (this._selectedRow != -1) {
                    KeywordNavigator.this._openButton.setEnabled(true);
                } else {
                    KeywordNavigator.this._openButton.setEnabled(false);
                }
                KeywordNavigator.this._fireTopicSelected(KeywordNavigator.this.getCurrentSelection());
            }
        }

        public Topic getSelectedTopic() {
            List topicBeans;
            if (this._selectedRow != -1 && this._selectedRow < (topicBeans = KeywordNavigator.this._currentIndexItem.getEntries()).size()) {
                return ((TopicBaseBean)topicBeans.get(this._selectedRow)).getTopic();
            }
            return null;
        }

        public int getSelectedRowIndex() {
            return this._selectedRow;
        }

        public void clearSelection() {
            KeywordNavigator.this._openButton.setEnabled(false);
            this._selectedRow = -1;
            KeywordNavigator.this._fireTopicSelected(null);
        }
    }

    private class TableResizer
    extends ComponentAdapter
    implements TableResizeListener {
        @Override
        public void componentResized(ComponentEvent event) {
            Dimension size = KeywordNavigator.this._entryTable.getParent().getSize();
            int titleWidth = (int)(0.7 * (double)size.width);
            int sourceWidth = (int)(0.3 * (double)size.width);
            KeywordNavigator.this._entryTable.setColumnWidth(0, titleWidth);
            KeywordNavigator.this._entryTable.setColumnWidth(1, sourceWidth);
        }

        public void columnResizing(TableEvent e) {
        }

        public void columnResized(TableEvent e) {
            if (e != null) {
                Dimension size = KeywordNavigator.this._entryTable.getSize();
                int titleWidth = KeywordNavigator.this._entryTable.getColumnWidth(0);
                int sourceWidth = size.width - titleWidth;
                KeywordNavigator.this._entryTable.setColumnWidth(1, sourceWidth);
            }
        }

        public void rowResizing(TableEvent e) {
        }

        public void rowResized(TableEvent e) {
        }
    }
}

