/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.favoritesNavigator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.library.Library;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;

public class DefaultFavoritesModel
extends FavoritesModel {
    private static final String _HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<favorites>";
    private static final String _FOOTER = "\n</favorites>";

    public DefaultFavoritesModel(URL location, Library library) {
        super(location, library);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restoreFavorites() {
        InputStream in = null;
        try {
            File file = new File(this.getLocation().getFile());
            if (file.exists()) {
                in = this.getLocation().openStream();
                Parser parser = ParserFactory.createParser((InputStream)in);
                this._processFavorites(parser.getRoot().getFirstChild());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected void saveFavorites() {
        try {
            OutputStream out = new FileOutputStream(this.getLocation().getFile());
            out = new BufferedOutputStream(out);
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            writer.write(_HEADER);
            this._writeFavoriteItemChildren(this.getFavoritesRoot(), writer, "  ");
            writer.write(_FOOTER);
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void _processFavorites(XMLNode xmlNode) throws XMLParseException {
        if (xmlNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xmlNode.getTokenValue().equalsIgnoreCase("favorites")) {
            throw new XMLParseException("Toplevel tag is not favorites: " + xmlNode.getTokenValue());
        }
        for (xmlNode = xmlNode.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            this._processFavoriteItem(xmlNode, this.getFavoritesRoot());
        }
    }

    private void _processFavoriteItem(XMLNode xmlNode, TopicTreeNode parent) throws XMLParseException {
        if (!xmlNode.getTokenValue().equalsIgnoreCase("favoriteitem")) {
            throw new XMLParseException("Tag is not favoriteitem: " + xmlNode.getTokenValue());
        }
        String text = xmlNode.getTokenProperty("text");
        String target = xmlNode.getTokenProperty("target");
        String hstitle = xmlNode.getTokenProperty("hstitle");
        String url = xmlNode.getTokenProperty("url");
        FavoritesModel.FavoriteItemTopicTreeNode favoriteItem = new FavoritesModel.FavoriteItemTopicTreeNode(this, text, target, hstitle, url);
        parent.addChild((TopicTreeNode)favoriteItem);
        for (xmlNode = xmlNode.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            this._processFavoriteItem(xmlNode, favoriteItem);
        }
    }

    private void _writeFavoriteItemChildren(TopicTreeNode parent, Writer writer, String indent) throws IOException {
        Iterator iter = parent.getChildren().iterator();
        while (iter.hasNext()) {
            this._writeFavoriteItem((FavoritesModel.FavoriteItemTopicTreeNode)((Object)iter.next()), writer, indent);
        }
    }

    private void _writeFavoriteItem(FavoritesModel.FavoriteItemTopicTreeNode favoriteItem, Writer writer, String indent) throws IOException {
        writer.write("\n" + indent + "<" + "favoriteitem");
        this._writeAttributeValue("text", favoriteItem.getTopic().getLabel(), writer);
        this._writeAttributeValue("target", favoriteItem.target, writer);
        this._writeAttributeValue("hstitle", favoriteItem.hstitle, writer);
        this._writeAttributeValue("url", favoriteItem.url, writer);
        if (favoriteItem.hasChildren()) {
            writer.write(">");
            this._writeFavoriteItemChildren(favoriteItem, writer, indent + "  ");
            writer.write("\n" + indent + "</" + "favoriteitem" + ">");
        } else {
            writer.write("/>");
        }
    }

    private void _writeAttributeValue(String attrName, String attrValue, Writer writer) throws IOException {
        if (attrValue != null) {
            writer.write(" " + attrName + "=\"" + attrValue + "\"");
        }
    }
}

