/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.util.java.StaticLocaleContext;

public class MenuUtils {
    public static final String SEPARATOR = "menu.separator";
    public static final String FILE = "menu.File";
    public static final String DISPLAY = "menu.Display";
    public static final String DISPLAY_NEW = "menu.Display_New";
    public static final String PRINT_TOPIC = "menu.PrintTopic";
    public static final String CLOSE = "menu.Close";
    public static final String EXIT = "menu.Exit";
    public static final String PRINT_TREE = "menu.PrintTree";
    public static final String PRINT_TOPICS = "menu.PrintTopics";
    public static final String VIEW = "menu.View";
    public static final String GO = "menu.Go";
    public static final String BACK = "menu.Back";
    public static final String FORWARD = "menu.Forward";
    public static final String TOOLS = "menu.Tools";
    public static final String FIND = "menu.Find";
    public static final String PREFERENCES = "menu.Preferences";
    public static final String DOCK = "menu.Dock";
    public static final String UNDOCK = "menu.Undock";
    public static final String NAVIGATOR = "menu.Navigator";
    public static final String HELP = "menu.Help";
    public static final String HELP_ON_HELP = "menu.HelpOnHelp";
    public static final String ABOUT = "menu.About";
    public static final String DISPLAY_TOOLTIP = "toolbar.Display.tooltip";
    public static final String DISPLAY_NEW_TOOLTIP = "toolbar.Display_New.tooltip";
    public static final String NAVIGATOR_TOOLTIP = "toolbar.Navigator.tooltip";
    public static final String BACK_TOOLTIP = "toolbar.Back.tooltip";
    public static final String FORWARD_TOOLTIP = "toolbar.Forward.tooltip";
    public static final String PRINT_TOPIC_TOOLTIP = "toolbar.PrintTopic.tooltip";
    public static final String DOCK_TOOLTIP = "toolbar.Dock.tooltip";
    public static final String UNDOCK_TOOLTIP = "toolbar.Undock.tooltip";
    public static final Map<String, KeyStroke> MENU_LABEL_KEYSTROKES = new HashMap<String, KeyStroke>();
    public static final Map<String, KeyStroke> MISC_BUNDLE_KEYSTROKES = new HashMap<String, KeyStroke>();
    private static String MENU_RESOURCE_BUNDLE;

    public static JMenuItem createItem(String labelID, boolean popup) {
        String name = MenuUtils.getDefaultMenuLabel(labelID);
        return MenuUtils.createItem(name, MENU_LABEL_KEYSTROKES.get(labelID), popup);
    }

    public static JMenuItem createItem(String labelText, KeyStroke accelerator, boolean popup) {
        JMenuItem item;
        if (labelText.charAt(0) == '+') {
            item = new JCheckBoxMenuItem();
            labelText = labelText.substring(1);
        } else {
            item = new JMenuItem();
        }
        MenuUtils.setMenuLabelAndAccelerator(item, labelText, accelerator, popup);
        return item;
    }

    public static void setMenuLabelAndAccelerator(JMenuItem item, String labelID, boolean popup) {
        MenuUtils.setMenuLabelAndAccelerator(item, MenuUtils.getDefaultMenuLabel(labelID), MENU_LABEL_KEYSTROKES.get(labelID), popup);
    }

    public static void setMenuLabelAndAccelerator(JMenuItem item, String labelText, KeyStroke accelerator, boolean popup) {
        item.setText(StringUtils.stripMnemonic((String)labelText));
        if (!popup) {
            int mnemonicCode;
            if (!(item instanceof JMenu) && accelerator != null && KeyEvent.getKeyText(accelerator.getKeyCode()).indexOf("known") == -1) {
                item.setAccelerator(accelerator);
            }
            if ((mnemonicCode = StringUtils.getMnemonicKeyCode((String)labelText)) != 0) {
                item.setMnemonic(mnemonicCode);
            }
        }
    }

    public static String getDefaultMenuLabel(String labelID) {
        ResourceBundle bundle = ResourceBundle.getBundle(MENU_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String defaultLabel = bundle.getString(labelID);
        return defaultLabel;
    }

    public static String removeSpecialMenuChars(String menuLabel) {
        String result = menuLabel;
        if (result != null) {
            if (result.charAt(0) == '+') {
                result = result.substring(1);
            }
            result = StringUtils.stripMnemonic((String)result);
        }
        return result;
    }

    public static KeyStroke getMiscBundleKeyStroke(String labelId) {
        return MISC_BUNDLE_KEYSTROKES.get(labelId);
    }

    static {
        MENU_LABEL_KEYSTROKES.put(FILE, KeyStroke.getKeyStroke(70, 2));
        MENU_LABEL_KEYSTROKES.put(DISPLAY, KeyStroke.getKeyStroke(79, 2));
        MENU_LABEL_KEYSTROKES.put(DISPLAY_NEW, KeyStroke.getKeyStroke(78, 2));
        MENU_LABEL_KEYSTROKES.put(PRINT_TOPIC, KeyStroke.getKeyStroke(80, 2));
        MENU_LABEL_KEYSTROKES.put(CLOSE, KeyStroke.getKeyStroke(87, 2));
        MENU_LABEL_KEYSTROKES.put(EXIT, KeyStroke.getKeyStroke(115, 8));
        MENU_LABEL_KEYSTROKES.put(PRINT_TREE, KeyStroke.getKeyStroke(84, 2));
        MENU_LABEL_KEYSTROKES.put(PRINT_TOPICS, KeyStroke.getKeyStroke(83, 2));
        MENU_LABEL_KEYSTROKES.put(VIEW, KeyStroke.getKeyStroke(86, 2));
        MENU_LABEL_KEYSTROKES.put(GO, KeyStroke.getKeyStroke(71, 2));
        MENU_LABEL_KEYSTROKES.put(BACK, KeyStroke.getKeyStroke(37, 8));
        MENU_LABEL_KEYSTROKES.put(FORWARD, KeyStroke.getKeyStroke(39, 8));
        MENU_LABEL_KEYSTROKES.put(FIND, KeyStroke.getKeyStroke(70, 2));
        MENU_LABEL_KEYSTROKES.put(DOCK, KeyStroke.getKeyStroke(75, 2));
        MENU_LABEL_KEYSTROKES.put(UNDOCK, KeyStroke.getKeyStroke(85, 2));
        MENU_LABEL_KEYSTROKES.put(NAVIGATOR, KeyStroke.getKeyStroke(74, 2));
        MENU_LABEL_KEYSTROKES.put(HELP, KeyStroke.getKeyStroke(72, 2));
        MISC_BUNDLE_KEYSTROKES.put("edit.copy", KeyStroke.getKeyStroke(67, 2));
        MISC_BUNDLE_KEYSTROKES.put("edit.selectAll", KeyStroke.getKeyStroke(65, 2));
        MISC_BUNDLE_KEYSTROKES.put("edit.increase", KeyStroke.getKeyStroke('+'));
        MISC_BUNDLE_KEYSTROKES.put("edit.decrease", KeyStroke.getKeyStroke('-'));
        MISC_BUNDLE_KEYSTROKES.put("addfavoriteitem.addtofavoritesdot", KeyStroke.getKeyStroke(68, 2));
        MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    }
}

