/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageFilter;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.graphics.TransparencyFilter;

public class ImageLoader {
    private static ImageLoader _defaultImageLoader = null;
    private static Hashtable _imageCache = new Hashtable();
    private static Image _frameIconImage = null;
    private static final Logger _LOGGER = Logger.getLogger(ImageLoader.class.getName(), "oracle.help.java.resource.LoggerBundle");

    public static final ImageLoader getDefaultImageLoader() {
        if (_defaultImageLoader == null) {
            _defaultImageLoader = new ImageLoader();
        }
        return _defaultImageLoader;
    }

    public static final void setDefaultImageLoader(ImageLoader imageLoader) {
        _defaultImageLoader = imageLoader;
    }

    public static final Image loadImage(Class aClass, String iconPath) {
        URL url = null;
        try {
            url = aClass.getResource(iconPath);
        }
        catch (Exception e) {
            url = null;
        }
        return ImageLoader.loadImage(url);
    }

    public static final Image loadImage(URL imageURL) {
        String key;
        Image img = null;
        if (imageURL != null && (img = (Image)_imageCache.get(key = imageURL.toExternalForm())) == null) {
            try {
                img = ImageLoader.getDefaultImageLoader().loadImageImpl(imageURL);
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "HELP-40001", key);
                _LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                img = null;
            }
            if (img != null) {
                _imageCache.put(key, img);
            }
        }
        return img;
    }

    public static final Image getIconImage() {
        return _frameIconImage;
    }

    public static final void setIconImage(Image anImage) {
        _frameIconImage = anImage;
    }

    protected Image loadImageImpl(URL imageURL) {
        Image img = null;
        if (imageURL != null) {
            try {
                img = Toolkit.getDefaultToolkit().createImage(imageURL);
                if (img != null) {
                    ImageUtils.loadImage((Image)img);
                }
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "HELP-40001", imageURL.toString());
                _LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                img = null;
            }
            if (img != null) {
                TransparencyFilter filter = new TransparencyFilter(new Color(255, 153, 0));
                img = ImageUtils.createFilteredImage((Image)img, (ImageFilter)filter);
            }
        }
        return img;
    }
}

