/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.help.DefaultWindowManager;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.WindowCoordinate;
import oracle.help.common.WindowType;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.ImageLoader;
import oracle.help.java.util.MenuUtils;
import oracle.help.navigator.favoritesNavigator.FavoritesActionUtils;
import oracle.help.topicDisplay.SimpleTopicDisplayPanel;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.help.topicDisplay.print.TopicPrintJob;

public class DefaultTopicPanel
extends JPanel
implements ActionListener,
TopicDisplay,
TopicDisplayListener {
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    private static final String MISC_RESOURCE_BUNDLE = "oracle.help.resource.MiscBundle";
    private static String TOPIC_WINDOW_TITLE = "defaultTopicWindow.title";
    private TopicWindowMenuBar _menuBar;
    private SimpleTopicDisplayPanel _topicPanel;
    private JFrame _topicFrame;
    private JDialog _topicDialog;
    private boolean _inDialogState;
    private FrameTopicPanelReclaimer _frameListener;
    private DialogTopicPanelReclaimer _dialogListener;
    private String _defaultTitle;
    private DefaultWindowManager _manager;
    private WindowType _currentWindowType;
    private boolean _currentlyDocked;
    private TopicDisplay _topicDisplay;
    private JToolBar _toolBar;
    private Component _navSeparator;
    private Component _dockToolBarSeparator;
    private JButton _navigatorButton;
    private JButton _backButton;
    private JButton _forwardButton;
    private JButton _printButton;
    private JToggleButton _dockButton;
    private ListenerManager _listeners;
    private static ImageIcon _navImage;
    private static ImageIcon _larrowImage;
    private static ImageIcon _rarrowImage;
    private static ImageIcon _printImage;
    private static ImageIcon _dockImage;
    private static ImageIcon _undockImage;
    private JMenu _fileMenu;
    private JMenu _goMenu;
    private JMenu _toolsMenu;
    private JPopupMenu _toolsSubMenu;
    private JMenuItem _printItem;
    private JMenuItem _closeItem;
    private JMenuItem _exitItem;
    private JMenuItem _backItem;
    private JMenuItem _forwardItem;
    private JMenuItem _navigatorItem;
    private JMenuItem _findItem;
    private JMenuItem _copyItem;
    private JMenuItem _selectAllItem;
    private JMenuItem _increaseItem;
    private JMenuItem _decreaseItem;
    private JPopupMenu.Separator _dockSeparator;
    private JMenuItem _dockItem;
    private JMenuItem _optionsItem;
    private JMenuItem _emptyItem;
    private JMenuItem _addFavoriteItem;

    public DefaultTopicPanel(TopicDisplay topicDisplay, DefaultWindowManager manager) {
        if (topicDisplay == null) {
            throw new IllegalArgumentException("Default Topic Window:  Null argument passed in constructor");
        }
        this._manager = manager;
        this._topicDisplay = topicDisplay;
        this._topicDisplay.addDisplayListener(this);
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this._defaultTitle = bundle.getString(TOPIC_WINDOW_TITLE);
        this._listeners = new ListenerManager();
        this.setLayout(new BorderLayout());
        this._menuBar = new TopicWindowMenuBar();
        this._toolBar = new JToolBar();
        Insets buttonInsets = new Insets(2, 2, 2, 2);
        if (_navImage == null) {
            this._loadImages();
        }
        if (this._manager != null) {
            this._navigatorButton = new JButton(_navImage);
            this._navigatorButton.setMargin(buttonInsets);
            this._toolBar.add(this._navigatorButton);
            this._navigatorButton.addActionListener(this);
            this._navigatorButton.setEnabled(true);
        }
        this._navSeparator = new JToolBar.Separator();
        this._toolBar.add(this._navSeparator);
        this._backButton = new JButton(_larrowImage);
        this._backButton.setMargin(buttonInsets);
        this._toolBar.add(this._backButton);
        this._backButton.addActionListener(this);
        this._backButton.setEnabled(false);
        this._forwardButton = new JButton(_rarrowImage);
        this._forwardButton.setMargin(buttonInsets);
        this._toolBar.add(this._forwardButton);
        this._forwardButton.addActionListener(this);
        this._forwardButton.setEnabled(false);
        this._toolBar.add(new JToolBar.Separator());
        this._printButton = new JButton(_printImage);
        this._printButton.setMargin(buttonInsets);
        this._toolBar.add(this._printButton);
        this._printButton.addActionListener(this);
        this._dockToolBarSeparator = new JToolBar.Separator();
        this._toolBar.add(this._dockToolBarSeparator);
        if (this._manager != null) {
            this._dockButton = new JToggleButton(_dockImage);
            this._dockButton.setMargin(buttonInsets);
            this._toolBar.add(this._dockButton);
            this._dockButton.addActionListener(this);
            this._dockButton.setSelected(false);
            this._dockButton.setToolTipText(MenuUtils.getDefaultMenuLabel("toolbar.Dock.tooltip"));
        }
        String navigatorHelpText = MenuUtils.getDefaultMenuLabel("toolbar.Navigator.tooltip");
        this._navigatorButton.setToolTipText(navigatorHelpText);
        String backButtonHelpText = MenuUtils.getDefaultMenuLabel("toolbar.Back.tooltip");
        this._backButton.setToolTipText(backButtonHelpText);
        String forwardButtonHelpText = MenuUtils.getDefaultMenuLabel("toolbar.Forward.tooltip");
        this._forwardButton.setToolTipText(forwardButtonHelpText);
        String printHelpText = MenuUtils.getDefaultMenuLabel("toolbar.PrintTopic.tooltip");
        this._printButton.setToolTipText(printHelpText);
        this._topicFrame = null;
        this._topicDialog = null;
        this._setDialogState(false);
        this._frameListener = new FrameTopicPanelReclaimer();
        this._dialogListener = new DialogTopicPanelReclaimer();
        this._topicPanel = new SimpleTopicDisplayPanel(this._topicDisplay, this._menuBar, this._toolBar);
        this._currentlyDocked = false;
        this.add((Component)this._topicPanel, "Center");
    }

    public JFrame createTopicWindowFrame() {
        if (this._topicDialog != null) {
            this.disposeTopicDialog();
        }
        if (this._topicFrame == null) {
            this._topicFrame = new JFrame();
            WindowUtils.registerWindow((Window)this._topicFrame);
            if (ImageLoader.getIconImage() != null) {
                this._topicFrame.setIconImage(ImageLoader.getIconImage());
            }
            this._topicFrame.getContentPane().setLayout(new BorderLayout());
            this._topicFrame.getContentPane().add((Component)this, "Center");
            this._topicFrame.addWindowListener(this._frameListener);
            this._topicFrame.setTitle(this._defaultTitle);
            ResourceBundle defaults = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
            String width = defaults.getString("topicwin.width");
            String height = defaults.getString("topicwin.height");
            this._topicFrame.setSize(Integer.parseInt(width), Integer.parseInt(height));
        }
        return this._topicFrame;
    }

    public JDialog createTopicWindowDialog(Dialog owner) {
        if (this._topicFrame != null) {
            this.disposeTopicFrame();
        }
        if (this._topicDialog != null && this._topicDialog.getParent() != owner) {
            this.disposeTopicDialog();
        }
        if (this._topicDialog == null) {
            this._topicDialog = new JDialog(owner);
            WindowUtils.registerWindow((Window)this._topicDialog);
            this._topicDialog.getContentPane().setLayout(new BorderLayout());
            this._topicDialog.getContentPane().add((Component)this, "Center");
            this._topicDialog.addComponentListener(this._dialogListener);
            this._topicDialog.setTitle(this._defaultTitle);
            ResourceBundle defaults = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
            String width = defaults.getString("topicwin.width");
            String height = defaults.getString("topicwin.height");
            this._topicDialog.setSize(Integer.parseInt(width), Integer.parseInt(height));
        }
        return this._topicDialog;
    }

    public Window getCurrentTopicWindow() {
        if (this._topicFrame != null) {
            return this._topicFrame;
        }
        if (this._topicDialog != null) {
            return this._topicDialog;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event != null) {
            if (event.getSource() == this._printButton) {
                try {
                    this.printDisplayedTopic();
                }
                catch (Exception exception) {}
            } else if (event.getSource() == this._navigatorButton) {
                if (this._manager != null) {
                    this._manager.showNavigatorWindow();
                }
            } else if (event.getSource() == this._forwardButton) {
                this._topicDisplay.goForward();
            } else if (event.getSource() == this._backButton) {
                this._topicDisplay.goBack();
            } else if (event.getSource() == this._dockButton) {
                this._switchDocking();
            }
        }
    }

    @Override
    public void topicDisplayChanged(TopicDisplayEvent e) {
        if (e.getID() == 2000) {
            Window currentTopicWindow;
            if (e.getChangeType() == 0 || e.getChangeType() == 2) {
                this._backButton.setEnabled(this._topicDisplay.canGoBack());
                this._backItem.setEnabled(this._topicDisplay.canGoBack());
                this._forwardButton.setEnabled(this._topicDisplay.canGoForward());
                this._forwardItem.setEnabled(this._topicDisplay.canGoForward());
            } else if (e.getChangeType() == 1 && (currentTopicWindow = this.getCurrentTopicWindow()) != null) {
                WindowType winType = e.getWindowType();
                Rectangle bounds = currentTopicWindow.getBounds();
                if (winType != this._currentWindowType) {
                    if (this._currentWindowType != null) {
                        this._currentWindowType.setBounds(bounds);
                    }
                    this._currentWindowType = winType;
                    if (winType != null) {
                        WindowCoordinate coord = winType.getHeight();
                        if (coord != null) {
                            bounds.height = coord.getValue(0, (Component)currentTopicWindow);
                        }
                        if ((coord = winType.getWidth()) != null) {
                            bounds.width = coord.getValue(0, (Component)currentTopicWindow);
                        }
                        if ((coord = winType.getX()) != null) {
                            bounds.x = coord.getValue(bounds.width, (Component)currentTopicWindow);
                        }
                        if ((coord = winType.getY()) != null) {
                            bounds.y = coord.getValue(bounds.height, (Component)currentTopicWindow);
                        }
                        currentTopicWindow.setBounds(bounds);
                        currentTopicWindow.validate();
                        String title = winType.getTitle();
                        if (title == null) {
                            title = this._defaultTitle;
                        }
                        if (currentTopicWindow instanceof Frame) {
                            ((Frame)currentTopicWindow).setTitle(title);
                        } else if (currentTopicWindow instanceof Dialog) {
                            ((Dialog)currentTopicWindow).setTitle(title);
                        }
                    }
                } else if (currentTopicWindow instanceof Frame) {
                    ((Frame)currentTopicWindow).setTitle(this._defaultTitle);
                } else if (currentTopicWindow instanceof Dialog) {
                    ((Dialog)currentTopicWindow).setTitle(this._defaultTitle);
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (this._topicFrame != null) {
            this.disposeTopicFrame();
        }
        if (this._topicDialog != null) {
            this.disposeTopicDialog();
        }
        this._topicDisplay.removeDisplayListener(this);
        this._listeners = null;
        this._defaultTitle = null;
        this.clearDocumentStack();
        this._menuBar.removeAll();
        this._menuBar = null;
        this._toolBar.removeAll();
        this._toolBar = null;
        this._manager = null;
        this._topicPanel.dispose();
        this._topicPanel = null;
        this._topicDisplay = null;
        this._frameListener = null;
        this._dialogListener = null;
        this.removeAll();
    }

    @Override
    public void clear() {
        this._topicDisplay.clear();
    }

    public void clearDocumentStack() {
        this.clear();
        this._backButton.setEnabled(false);
        this._backItem.setEnabled(false);
        this._forwardButton.setEnabled(false);
        this._forwardItem.setEnabled(false);
    }

    @Override
    public void displayTopic(Topic topic) throws TopicDisplayException {
        this._topicPanel.displayTopic(topic);
    }

    @Override
    public TopicPrintJob getTopicPrintJob() {
        return this._topicPanel.getTopicPrintJob();
    }

    public void printDisplayedTopic() {
        TopicPrintJob printJob = this.getTopicPrintJob();
        URL topicURL = this.getCurrentURL();
        if (topicURL != null && printJob != null) {
            SimpleURLTarget target = new SimpleURLTarget(null, topicURL.toString());
            SimpleTopic topic = new SimpleTopic("", (Target)target, null);
            printJob.printTopic((Topic)topic);
        }
    }

    @Override
    public JPanel getDisplayContainer() {
        return this._topicPanel;
    }

    @Override
    public URL getCurrentURL() {
        return this._topicPanel.getCurrentURL();
    }

    @Override
    public void addDisplayListener(TopicDisplayListener listener) {
        this._topicPanel.addDisplayListener(listener);
    }

    @Override
    public void removeDisplayListener(TopicDisplayListener listener) {
        this._topicPanel.removeDisplayListener(listener);
    }

    public void disposeTopicFrame() {
        if (this._topicFrame != null) {
            this._topicFrame.removeWindowListener(this._frameListener);
            this._topicFrame.setVisible(false);
            this._topicFrame.remove(this);
            WindowUtils.unregisterWindow((Window)this._topicFrame);
            this._topicFrame.dispose();
            this._topicFrame = null;
        }
    }

    public void disposeTopicDialog() {
        if (this._topicDialog != null) {
            this._topicDialog.removeComponentListener(this._dialogListener);
            this._topicDialog.setVisible(false);
            this._topicDialog.remove(this);
            WindowUtils.unregisterWindow((Window)this._topicDialog);
            this._topicDialog.dispose();
            this._topicDialog = null;
        }
    }

    public void dockTopicPanel() {
        if (this._manager != null && !this._currentlyDocked) {
            this._menuBar.setDockedState(true);
            this._dockButton.setSelected(true);
            this._dockButton.setToolTipText(MenuUtils.getDefaultMenuLabel("toolbar.Undock.tooltip"));
            this._dockButton.setIcon(_undockImage);
            this._toolBar.remove(this._navigatorButton);
            this._toolBar.remove(this._navSeparator);
            this._manager.dockTopicPanel(this);
            this._currentlyDocked = true;
        }
    }

    public void undockTopicPanel() {
        if (this._manager != null && this._currentlyDocked) {
            this._toolBar.add(this._navSeparator, 0);
            this._toolBar.add((Component)this._navigatorButton, 0);
            this._manager.undockTopicPanel();
            this._menuBar.setDockedState(false);
            this._dockButton.setSelected(false);
            this._dockButton.setIcon(_dockImage);
            this._dockButton.setToolTipText(MenuUtils.getDefaultMenuLabel("toolbar.Dock.tooltip"));
            this._currentlyDocked = false;
        }
    }

    public void reclaimTopicPanel() {
        Window topicWindow = this.getCurrentTopicWindow();
        if (topicWindow != null) {
            if (this._currentWindowType != null) {
                this._currentWindowType.setBounds(topicWindow.getBounds());
            }
            this._currentWindowType = null;
            if (topicWindow.isVisible()) {
                topicWindow.setVisible(false);
            }
        }
        if (this._manager != null) {
            this._manager.reclaimTopicPanel(this);
        }
    }

    JMenu _getGoMenu() {
        return this._goMenu;
    }

    private void _setDialogState(boolean dialogMode) {
        this._inDialogState = dialogMode;
        if (this._inDialogState) {
            this._dockToolBarSeparator.setVisible(false);
            this._dockButton.setVisible(false);
        } else {
            this._dockToolBarSeparator.setVisible(true);
            this._dockButton.setVisible(true);
        }
        this._menuBar.setMenuDialogState(this._inDialogState);
    }

    @Override
    public void runFindDialog() {
        this._topicDisplay.runFindDialog();
    }

    @Override
    public boolean canGoBack() {
        return this._topicPanel.canGoBack();
    }

    @Override
    public void goBack() {
        this._topicPanel.goBack();
    }

    @Override
    public boolean canGoForward() {
        return this._topicPanel.canGoForward();
    }

    @Override
    public void goForward() {
        this._topicPanel.goForward();
    }

    public void copySelectedText() {
        String selectedText = this.getSelectedText();
        if (selectedText != null && selectedText.length() > 0) {
            Clipboard cl = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection sel = new StringSelection(selectedText);
            cl.setContents(sel, sel);
        }
    }

    @Override
    public String getSelectedText() {
        return this._topicPanel.getSelectedText();
    }

    @Override
    public void increaseFontSize() {
        this._topicPanel.increaseFontSize();
    }

    @Override
    public void decreaseFontSize() {
        this._topicPanel.decreaseFontSize();
    }

    @Override
    public void selectAll() {
        this._topicPanel.selectAll();
    }

    @Override
    public String getCurrentPageTitle() {
        return this._topicPanel.getCurrentPageTitle();
    }

    public void addFavoriteItem() {
        FavoritesActionUtils.addFavoriteItem(this._manager.getFavoritesModel(), this, WindowUtils.parentFrame((Component)this));
    }

    private void _loadImages() {
        try {
            _navImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/navigator.gif"));
            _larrowImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/leftarrow.gif"));
            _rarrowImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/rightarrow.gif"));
            _printImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/print.gif"));
            _dockImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/dock.gif"));
            _undockImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/undock.gif"));
        }
        catch (Exception e) {
            System.err.println("DefaultTopicPanel:: Could not load toolbar images.");
        }
    }

    private void _switchDocking() {
        if (this._currentlyDocked) {
            this.undockTopicPanel();
        } else {
            this.dockTopicPanel();
        }
    }

    private class FrameTopicPanelReclaimer
    extends WindowAdapter {
        private FrameTopicPanelReclaimer() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DefaultTopicPanel.this.reclaimTopicPanel();
        }
    }

    private class DialogTopicPanelReclaimer
    extends ComponentAdapter {
        private DialogTopicPanelReclaimer() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (e.getComponent() == DefaultTopicPanel.this.getCurrentTopicWindow()) {
                DefaultTopicPanel.this.reclaimTopicPanel();
            }
        }
    }

    private class TopicWindowMenuBar
    extends JMenuBar
    implements ActionListener,
    PopupMenuListener {
        public TopicWindowMenuBar() {
            this._initMenuBar();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DefaultTopicPanel.this._printItem) {
                try {
                    DefaultTopicPanel.this.printDisplayedTopic();
                }
                catch (Exception exception) {}
            } else if (e.getSource() == DefaultTopicPanel.this._closeItem) {
                DefaultTopicPanel.this.reclaimTopicPanel();
            } else if (e.getSource() == DefaultTopicPanel.this._exitItem) {
                if (DefaultTopicPanel.this._manager != null) {
                    DefaultTopicPanel.this._manager.hideAllWindows();
                } else {
                    DefaultTopicPanel.this.reclaimTopicPanel();
                }
            } else if (e.getSource() == DefaultTopicPanel.this._backItem) {
                DefaultTopicPanel.this._topicDisplay.goBack();
            } else if (e.getSource() == DefaultTopicPanel.this._forwardItem) {
                DefaultTopicPanel.this._topicDisplay.goForward();
            } else if (e.getSource() == DefaultTopicPanel.this._navigatorItem) {
                if (DefaultTopicPanel.this._manager != null) {
                    DefaultTopicPanel.this._manager.showNavigatorWindow();
                }
            } else if (e.getSource() == DefaultTopicPanel.this._findItem) {
                DefaultTopicPanel.this.runFindDialog();
            } else if (e.getSource() == DefaultTopicPanel.this._dockItem) {
                DefaultTopicPanel.this.dockTopicPanel();
            } else if (e.getSource() == DefaultTopicPanel.this._copyItem) {
                DefaultTopicPanel.this.copySelectedText();
            } else if (e.getSource() == DefaultTopicPanel.this._increaseItem) {
                DefaultTopicPanel.this.increaseFontSize();
            } else if (e.getSource() == DefaultTopicPanel.this._decreaseItem) {
                DefaultTopicPanel.this.decreaseFontSize();
            } else if (e.getSource() == DefaultTopicPanel.this._selectAllItem) {
                DefaultTopicPanel.this._topicDisplay.selectAll();
            } else if (e.getSource() == DefaultTopicPanel.this._addFavoriteItem) {
                DefaultTopicPanel.this.addFavoriteItem();
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            if (e.getSource() == DefaultTopicPanel.this._toolsSubMenu) {
                String selectedText = DefaultTopicPanel.this.getSelectedText();
                DefaultTopicPanel.this._copyItem.setEnabled(selectedText != null && !"".equals(selectedText));
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void setDockedState(boolean docked) {
            if (docked) {
                DefaultTopicPanel.this._fileMenu.setVisible(false);
                DefaultTopicPanel.this._toolsMenu.setVisible(false);
                this.remove(DefaultTopicPanel.this._goMenu);
                this.add(DefaultTopicPanel.this._emptyItem);
            } else {
                this.remove(DefaultTopicPanel.this._emptyItem);
                this.remove(DefaultTopicPanel.this._toolsMenu);
                this.add(DefaultTopicPanel.this._goMenu);
                this.add(DefaultTopicPanel.this._toolsMenu);
                DefaultTopicPanel.this._fileMenu.setVisible(true);
                DefaultTopicPanel.this._toolsMenu.setVisible(true);
            }
            this.validate();
        }

        public void setMenuDialogState(boolean dialogMode) {
            if (dialogMode) {
                DefaultTopicPanel.this._toolsMenu.remove(DefaultTopicPanel.this._dockSeparator);
                DefaultTopicPanel.this._toolsMenu.remove(DefaultTopicPanel.this._dockItem);
            } else {
                DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._dockSeparator);
                DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._dockItem);
            }
            this.validate();
        }

        private void _initMenuBar() {
            this.add(this._createFileMenu());
            this.add(this._createGoMenu());
            this.add(this._createToolsMenu());
            DefaultTopicPanel.this._emptyItem = new JMenuItem(" ");
        }

        private JMenu _createFileMenu() {
            DefaultTopicPanel.this._fileMenu = new JMenu();
            MenuUtils.setMenuLabelAndAccelerator(DefaultTopicPanel.this._fileMenu, "menu.File", false);
            DefaultTopicPanel.this._printItem = MenuUtils.createItem("menu.PrintTopic", false);
            DefaultTopicPanel.this._printItem.addActionListener(this);
            DefaultTopicPanel.this._fileMenu.add(DefaultTopicPanel.this._printItem);
            DefaultTopicPanel.this._fileMenu.addSeparator();
            DefaultTopicPanel.this._closeItem = MenuUtils.createItem("menu.Close", false);
            DefaultTopicPanel.this._closeItem.addActionListener(this);
            DefaultTopicPanel.this._fileMenu.add(DefaultTopicPanel.this._closeItem);
            DefaultTopicPanel.this._exitItem = MenuUtils.createItem("menu.Exit", false);
            DefaultTopicPanel.this._exitItem.addActionListener(this);
            DefaultTopicPanel.this._fileMenu.add(DefaultTopicPanel.this._exitItem);
            DefaultTopicPanel.this._fileMenu.setEnabled(true);
            return DefaultTopicPanel.this._fileMenu;
        }

        private JMenu _createGoMenu() {
            DefaultTopicPanel.this._goMenu = new JMenu();
            MenuUtils.setMenuLabelAndAccelerator(DefaultTopicPanel.this._goMenu, "menu.Go", false);
            DefaultTopicPanel.this._backItem = MenuUtils.createItem("menu.Back", false);
            DefaultTopicPanel.this._backItem.addActionListener(this);
            DefaultTopicPanel.this._backItem.setEnabled(false);
            DefaultTopicPanel.this._goMenu.add(DefaultTopicPanel.this._backItem);
            DefaultTopicPanel.this._forwardItem = MenuUtils.createItem("menu.Forward", false);
            DefaultTopicPanel.this._forwardItem.addActionListener(this);
            DefaultTopicPanel.this._forwardItem.setEnabled(false);
            DefaultTopicPanel.this._goMenu.add(DefaultTopicPanel.this._forwardItem);
            DefaultTopicPanel.this._goMenu.setEnabled(true);
            return DefaultTopicPanel.this._goMenu;
        }

        private JMenu _createToolsMenu() {
            DefaultTopicPanel.this._toolsMenu = new JMenu();
            DefaultTopicPanel.this._toolsSubMenu = DefaultTopicPanel.this._toolsMenu.getPopupMenu();
            DefaultTopicPanel.this._toolsSubMenu.addPopupMenuListener(this);
            MenuUtils.setMenuLabelAndAccelerator(DefaultTopicPanel.this._toolsMenu, "menu.Tools", false);
            DefaultTopicPanel.this._navigatorItem = MenuUtils.createItem("menu.Navigator", false);
            DefaultTopicPanel.this._navigatorItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._navigatorItem);
            ResourceBundle miscBundle = ResourceBundle.getBundle(DefaultTopicPanel.MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
            String copyLabel = miscBundle.getString("edit.copy");
            DefaultTopicPanel.this._copyItem = MenuUtils.createItem(copyLabel, MenuUtils.getMiscBundleKeyStroke("edit.copy"), false);
            DefaultTopicPanel.this._copyItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._copyItem);
            String selectAllLabel = miscBundle.getString("edit.selectAll");
            DefaultTopicPanel.this._selectAllItem = MenuUtils.createItem(selectAllLabel, MenuUtils.getMiscBundleKeyStroke("edit.selectAll"), false);
            DefaultTopicPanel.this._selectAllItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._selectAllItem);
            DefaultTopicPanel.this._findItem = MenuUtils.createItem("menu.Find", false);
            DefaultTopicPanel.this._findItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._findItem);
            JMenu fontSizeMenu = new JMenu();
            String fontSizeMenuLabel = miscBundle.getString("edit.fontSize");
            MenuUtils.setMenuLabelAndAccelerator(fontSizeMenu, fontSizeMenuLabel, null, false);
            DefaultTopicPanel.this._toolsMenu.add(fontSizeMenu);
            String increaseLabel = miscBundle.getString("edit.increase");
            DefaultTopicPanel.this._increaseItem = MenuUtils.createItem(increaseLabel, MenuUtils.getMiscBundleKeyStroke("edit.increase"), false);
            DefaultTopicPanel.this._increaseItem.addActionListener(this);
            fontSizeMenu.add(DefaultTopicPanel.this._increaseItem);
            String decreaseLabel = miscBundle.getString("edit.decrease");
            DefaultTopicPanel.this._decreaseItem = MenuUtils.createItem(decreaseLabel, MenuUtils.getMiscBundleKeyStroke("edit.decrease"), false);
            DefaultTopicPanel.this._decreaseItem.addActionListener(this);
            fontSizeMenu.add(DefaultTopicPanel.this._decreaseItem);
            DefaultTopicPanel.this._dockSeparator = new JPopupMenu.Separator();
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._dockSeparator);
            DefaultTopicPanel.this._dockItem = MenuUtils.createItem("menu.Dock", false);
            DefaultTopicPanel.this._dockItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._dockItem);
            DefaultTopicPanel.this._optionsItem = MenuUtils.createItem("menu.Preferences", false);
            DefaultTopicPanel.this._optionsItem.addActionListener(this);
            if (DefaultTopicPanel.this._manager.getFavoritesModel() != null) {
                String addFavoriteLabel = miscBundle.getString("addfavoriteitem.addtofavoritesdot");
                DefaultTopicPanel.this._addFavoriteItem = MenuUtils.createItem(addFavoriteLabel, MenuUtils.getMiscBundleKeyStroke("addfavoriteitem.addtofavoritesdot"), false);
                DefaultTopicPanel.this._addFavoriteItem.addActionListener(this);
                DefaultTopicPanel.this._toolsMenu.addSeparator();
                DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._addFavoriteItem);
            }
            DefaultTopicPanel.this._toolsMenu.setEnabled(true);
            return DefaultTopicPanel.this._toolsMenu;
        }
    }
}

