/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.net.URL;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectPropertyNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.ObjectFolder;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;

class PropertyNode
extends ObjectFolder
implements DBObjectPropertyNode {
    private URL m_url;
    private Object m_parentObject;
    private final boolean m_lazy;
    private final PropertyInfo m_info;

    public PropertyNode(PropertyInfo propertyInfo, Object object, DBObjectProvider dBObjectProvider) {
        this(propertyInfo, object, dBObjectProvider, false);
    }

    protected PropertyNode(PropertyInfo propertyInfo, Object object, DBObjectProvider dBObjectProvider, boolean bl) {
        super(null, dBObjectProvider, propertyInfo.getPropertyName());
        this.m_info = propertyInfo;
        this.m_lazy = bl;
        this.setParentObject(object);
    }

    protected final PropertyInfo getPropertyInfo() {
        return this.m_info;
    }

    @Override
    public Object getKey() {
        return this.getProperty();
    }

    @Override
    public boolean mayHaveChildren() {
        return super.mayHaveChildren() && !"schema".toString().equals(this.getProperty());
    }

    @Override
    protected String createPropertyLabel(String string, Object object, DBObject dBObject) {
        if (dBObject == null && this.m_parentObject instanceof DBObject) {
            dBObject = (DBObject)this.m_parentObject;
        }
        return super.createPropertyLabel(string, object, dBObject);
    }

    @Override
    protected DBObjectProvider useDBRunnable() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        return dBObjectProvider instanceof Database && this.m_parentObject instanceof AbstractBuildableObject ? dBObjectProvider : null;
    }

    protected final Object getParentObject() {
        return this.m_parentObject;
    }

    public final void setParentObject(Object object) {
        this.m_parentObject = object;
        this.setObject(this.m_lazy ? null : this.m_info.getPropertyValue(object));
    }

    public DBObject getParentDBObject() {
        DBObject dBObject = null;
        if (this.m_parentObject instanceof DBObject) {
            dBObject = (DBObject)this.m_parentObject;
        } else {
            Element element = this.getParentElement();
            if (element instanceof DBObjectPropertyNode) {
                dBObject = ((DBObjectPropertyNode)element).getParentDBObject();
            } else if (element instanceof DBObjectNode) {
                dBObject = ((DBObjectNode)element).getDBObject();
            }
        }
        return dBObject;
    }

    public String getPropertyName() {
        String string = this.getProperty();
        if (!(this.m_parentObject instanceof DBObject)) {
            Element element = this.getParentElement();
            string = element instanceof DBObjectPropertyNode ? Property.createPath((String[])new String[]{((DBObjectPropertyNode)element).getPropertyName(), string}) : null;
        }
        return string;
    }

    public void setURL(URL uRL) {
        this.m_url = uRL;
    }

    public URL getURL() {
        return this.m_url;
    }
}

