/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

class ObjectFolder
extends BaseFolder {
    private DBObjectProvider m_pro;
    private Object m_obj;
    private String m_propName;
    private Icon m_icon;
    private String m_text;

    public ObjectFolder(Object object, DBObjectProvider dBObjectProvider, String string) {
        this.m_obj = object;
        this.m_pro = dBObjectProvider;
        this.m_propName = string;
    }

    @Override
    protected List<Element> createChildren(List<Element> list) throws CancelledException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        DBObjectProvider dBObjectProvider = this.getProvider();
        Object object = this.getObject();
        if (object != null) {
            PropertyCriteria propertyCriteria = PropertyCriteria.createEmptyCriteria();
            propertyCriteria.setIncludeExtra(false);
            propertyCriteria.addPredicate(propertyInfo -> !this.isIgnoredProperty((PropertyInfo)propertyInfo, dBObjectProvider, object));
            Map map = object instanceof DBObject ? dBObjectProvider.getPropertyManager().getPropertyInfos(((DBObject)object).getClass(), propertyCriteria) : PropertyHelper.getPropertyInfos(object.getClass(), null, (PropertyCriteria)propertyCriteria);
            ExplorerModelHelper explorerModelHelper = this.getHelper();
            for (PropertyInfo propertyInfo2 : map.values()) {
                DBExplorerElement dBExplorerElement = this.findOrCreateElement(propertyInfo2, dBObjectProvider, object, list);
                if (dBExplorerElement == null) continue;
                arrayList.add(dBExplorerElement);
            }
        }
        return arrayList;
    }

    protected DBExplorerElement findOrCreateElement(PropertyInfo propertyInfo, DBObjectProvider dBObjectProvider, Object object, List<Element> list) throws CancelledException {
        return this.getHelper().findOrCreateElement(object, propertyInfo, dBObjectProvider, list);
    }

    protected String getProperty() {
        return this.m_propName;
    }

    protected Object getObject() {
        return this.m_obj;
    }

    void setObject(Object object) {
        this.m_obj = object;
    }

    public final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_text = null;
        this.m_icon = null;
    }

    @Override
    public boolean mayHaveChildren() {
        Object object = this.getObject();
        return object instanceof Copyable && !(object instanceof DBObjectID);
    }

    @Override
    public Object getKey() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        if (this.m_text == null) {
            this.m_text = this.createLabel();
        }
        return this.m_text;
    }

    public Icon getIcon() {
        if (this.m_icon == null) {
            this.m_icon = this.createIcon();
        }
        return this.m_icon;
    }

    protected Icon createIcon() {
        Icon icon = null;
        if (this.m_obj instanceof DBObject) {
            icon = DBTypeDisplayRegistry.getNodeIcon((DBObject)((DBObject)this.m_obj));
        } else if (this.m_obj instanceof DBObjectID) {
            icon = DBTypeDisplayRegistry.getNodeIcon((String)((DBObjectID)this.m_obj).getType());
        }
        if (icon == null) {
            icon = OracleIcons.getIcon((String)"properties.png");
        }
        return icon;
    }

    protected String createPropertyLabel(String string, Object object, DBObject dBObject) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(PropertyDisplayRegistry.getDisplayName((String)string, (DBObjectProvider)this.getProvider(), (DBObject)dBObject));
        }
        if (ModelUtil.hasLength((String)(string2 = PropertyDisplayRegistry.getPropValueDisplay((String)string, (Object)object)))) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" : ");
            }
            if (string2.contains("\n")) {
                stringBuilder.append(string2.replaceAll("\\n", " "));
            } else {
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    protected String createLabel() {
        Object object = null;
        if (this.m_obj instanceof DBObject) {
            object = ((DBObject)this.m_obj).getName();
            if (object == null) {
                object = "";
            }
        } else if (this.m_obj instanceof DBObjectID && (object = this.m_obj instanceof DataTypeID ? ((DataTypeID)this.m_obj).getTypeName() : (this.getHelper().isChildOfTopObject((DBObjectID)this.m_obj) ? DBUtil.getDBObjectName((DBObjectID)((DBObjectID)this.m_obj)) : DBUtil.getFullyQualifiedName((DBObjectID)((DBObjectID)this.m_obj)))) == null) {
            object = "";
        }
        if (object == null) {
            object = this.m_obj;
        }
        return this.createPropertyLabel(this.m_propName, object, this.m_obj instanceof DBObject ? (DBObject)this.m_obj : null);
    }
}

