/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.DBTypeFolder;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.ideimpl.db.explorer.model.PropertiesFolder;
import oracle.ideimpl.db.explorer.model.PropertyNode;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.ModelUtil;

final class ExplorerModelHelper {
    private Context m_context;
    private DBObjectFolder m_rootFolder;

    public ExplorerModelHelper(Context context) {
        this.m_context = context;
        if (context == null || !(context.getNode() instanceof DBObjectNode)) {
            throw new IllegalArgumentException("Context must contain a DBObject.");
        }
    }

    public DBExplorerElement findOrCreateElement(Object object, PropertyInfo propertyInfo, DBObjectProvider dBObjectProvider, List<Element> list) {
        DBExplorerElement dBExplorerElement = null;
        String string = propertyInfo.getPropertyName();
        Class clazz = propertyInfo.getPropertyClass();
        if (Schema.class == clazz) {
            dBExplorerElement = new PropertyNode(propertyInfo, object, dBObjectProvider);
        } else if (DBObject.class.isAssignableFrom(clazz)) {
            DBObject dBObject = (DBObject)propertyInfo.getPropertyValue(object);
            if (dBObject != null) {
                dBExplorerElement = ExplorerModelHelper.find(list, ExplorerModelHelper.getKeyForObject(dBObject, string));
                if (dBExplorerElement instanceof DBObjectFolder) {
                    ((DBObjectFolder)dBExplorerElement).setObject(dBObject);
                } else {
                    dBExplorerElement = dBObject instanceof DBObjectPlSqlFragment ? new PlSqlFragmentElement(dBObject, dBObjectProvider, string) : new DBObjectFolder(dBObject, dBObjectProvider, string);
                }
            }
        } else {
            dBExplorerElement = ExplorerModelHelper.find(list, string);
            if (dBExplorerElement == null) {
                if (clazz.isArray()) {
                    if (object instanceof DBObject) {
                        dBExplorerElement = new DBTypeFolder(propertyInfo, (DBObject)object, dBObjectProvider);
                    }
                } else {
                    dBExplorerElement = Map.class.isAssignableFrom(clazz) || DynamicPropertySet.class.isAssignableFrom(clazz) ? new PropertiesFolder(propertyInfo, object, dBObjectProvider) : new PropertyNode(propertyInfo, object, dBObjectProvider);
                }
            } else if (dBExplorerElement instanceof PropertyNode) {
                ((PropertyNode)dBExplorerElement).setParentObject(object);
            }
        }
        if (dBExplorerElement != null) {
            dBExplorerElement.setHelper(this);
            if (this.shouldInclude(dBExplorerElement, object, propertyInfo, dBObjectProvider)) {
                DBLog.getLogger((Object)this).log(Level.FINEST, "Including {0}", propertyInfo.getPropertyName());
            } else {
                dBExplorerElement = null;
                DBLog.getLogger((Object)this).log(Level.FINEST, "Ignoring {0}", propertyInfo.getPropertyName());
            }
        }
        return dBExplorerElement;
    }

    private boolean shouldInclude(DBExplorerElement dBExplorerElement, Object object, PropertyInfo propertyInfo2, DBObjectProvider dBObjectProvider) {
        boolean bl;
        if (object instanceof DBObject && dBExplorerElement.mayHaveChildren()) {
            if (dBExplorerElement instanceof BaseFolder && ((BaseFolder)dBExplorerElement).useDBRunnable() != null) {
                String string = propertyInfo2.getPropertyName();
                if ("properties".equals(string)) {
                    Class<?> clazz = ((DBObject)object).getClass();
                    PropertyCriteria propertyCriteria = new PropertyCriteria();
                    propertyCriteria.setIncludeBean(false);
                    propertyCriteria.addPredicate(propertyInfo -> this.isLazy((DBObject)object, propertyInfo.getPropertyName()) || this.hasValue((PropertyInfo)propertyInfo, object));
                    bl = Metadata.getInstance().hasSupportedProperty(clazz, dBObjectProvider.getClass(), (Predicate)propertyCriteria);
                } else {
                    bl = this.isLazy((DBObject)object, string) ? dBObjectProvider.getPropertyManager().supportsProperty(((DBObject)object).getClass(), string) : this.hasValue(propertyInfo2, object);
                }
            } else {
                bl = dBExplorerElement instanceof PropertiesFolder || dBExplorerElement instanceof DBTypeFolder ? dBExplorerElement.getChildren().hasNext() : this.hasValue(propertyInfo2, object);
            }
        } else {
            bl = this.hasValue(propertyInfo2, object);
        }
        return bl;
    }

    private boolean isLazy(DBObject dBObject, String string) {
        return DBUtil.getDBObjectBuilder((DBObject)dBObject, (String)string) != null;
    }

    private boolean hasValue(PropertyInfo propertyInfo, Object object) {
        Object object2 = propertyInfo.getPropertyValue(object);
        boolean bl = object2 == null ? propertyInfo.getNullBehaviour() == Nullable.NullBehaviour.NULLABLE : (object2 instanceof Object[] ? ((Object[])object2).length > 0 : (object2 instanceof Map ? !((Map)object2).isEmpty() : true));
        return bl;
    }

    void setRootFolder(DBObjectFolder dBObjectFolder) {
        this.m_rootFolder = dBObjectFolder;
    }

    public boolean isChildOfTopObject(DBObjectID dBObjectID) {
        DBObject dBObject;
        boolean bl = false;
        if (this.m_rootFolder != null && (dBObject = this.m_rootFolder.getDBObject()) != null) {
            DBObjectID dBObjectID2 = dBObject.getID();
            bl = DBUtil.isSameOrChildOf((DBObjectID)dBObjectID, (DBObjectID)dBObjectID2, (boolean)true);
        }
        return bl;
    }

    DBObjectNode getNode() {
        Node node = this.m_context.getNode();
        if (!(node instanceof DBObjectNode)) {
            String string = node == null ? "null" : node.getClass().getName() + " " + node.getLongLabel();
            throw new IllegalStateException("Context must have a DBObjectNode, not " + string);
        }
        DBObjectNode dBObjectNode = (DBObjectNode)node;
        return dBObjectNode;
    }

    static final Object getKeyForObject(DBObject dBObject, String string) {
        String string2 = dBObject.getName();
        if (!ModelUtil.hasLength((String)string2)) {
            string2 = string;
        }
        return String.valueOf(string2);
    }

    static final DBExplorerElement find(List<Element> list, Object object) {
        DBExplorerElement dBExplorerElement = null;
        if (list != null) {
            for (Element element : list) {
                if (!(element instanceof DBExplorerElement) || !ModelUtil.areEqual((Object)((DBExplorerElement)element).getKey(), (Object)object)) continue;
                dBExplorerElement = (DBExplorerElement)element;
                break;
            }
        }
        return dBExplorerElement;
    }
}

